/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.user.RowDeletingIterator;
import org.apache.accumulo.core.iterators.user.TimestampFilter;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.CreateMode;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilder;
import org.vertexium.EdgeBuilderBase;
import org.vertexium.Element;
import org.vertexium.ElementFilter;
import org.vertexium.ElementType;
import org.vertexium.FetchHint;
import org.vertexium.FindPathOptions;
import org.vertexium.Graph;
import org.vertexium.GraphBaseWithSearchIndex;
import org.vertexium.GraphConfiguration;
import org.vertexium.GraphMetadataEntry;
import org.vertexium.GraphMetadataStore;
import org.vertexium.HistoricalPropertyValue;
import org.vertexium.Metadata;
import org.vertexium.Path;
import org.vertexium.ProgressCallback;
import org.vertexium.Property;
import org.vertexium.PropertyDescriptor;
import org.vertexium.Range;
import org.vertexium.RelatedEdge;
import org.vertexium.RelatedEdgeImpl;
import org.vertexium.SecurityVertexiumException;
import org.vertexium.Traceable;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.VertexiumSerializer;
import org.vertexium.Visibility;
import org.vertexium.accumulo.AccumuloAuthorizations;
import org.vertexium.accumulo.AccumuloEdge;
import org.vertexium.accumulo.AccumuloEdgeBuilderByVertexId;
import org.vertexium.accumulo.AccumuloElement;
import org.vertexium.accumulo.AccumuloFindPathStrategy;
import org.vertexium.accumulo.AccumuloGraphConfiguration;
import org.vertexium.accumulo.AccumuloGraphLogger;
import org.vertexium.accumulo.AccumuloNameSubstitutionStrategy;
import org.vertexium.accumulo.AccumuloVertex;
import org.vertexium.accumulo.AccumuloVertexBuilder;
import org.vertexium.accumulo.ElementMutationBuilder;
import org.vertexium.accumulo.StreamingPropertyValueTable;
import org.vertexium.accumulo.StreamingPropertyValueTableRef;
import org.vertexium.accumulo.iterator.CountingIterator;
import org.vertexium.accumulo.iterator.EdgeIterator;
import org.vertexium.accumulo.iterator.EdgeRefFilter;
import org.vertexium.accumulo.iterator.HasAuthorizationFilter;
import org.vertexium.accumulo.iterator.VertexEdgeIdIterator;
import org.vertexium.accumulo.iterator.VertexIterator;
import org.vertexium.accumulo.iterator.model.EdgeInfo;
import org.vertexium.accumulo.iterator.model.PropertyColumnQualifier;
import org.vertexium.accumulo.iterator.model.PropertyMetadataColumnQualifier;
import org.vertexium.accumulo.iterator.util.ByteArrayWrapper;
import org.vertexium.accumulo.keys.DataTableRowKey;
import org.vertexium.accumulo.keys.KeyHelper;
import org.vertexium.accumulo.util.RangeUtils;
import org.vertexium.event.AddEdgeEvent;
import org.vertexium.event.AddPropertyEvent;
import org.vertexium.event.AddVertexEvent;
import org.vertexium.event.DeleteEdgeEvent;
import org.vertexium.event.DeletePropertyEvent;
import org.vertexium.event.DeleteVertexEvent;
import org.vertexium.event.GraphEvent;
import org.vertexium.event.MarkHiddenEdgeEvent;
import org.vertexium.event.MarkHiddenPropertyEvent;
import org.vertexium.event.MarkHiddenVertexEvent;
import org.vertexium.event.MarkVisibleEdgeEvent;
import org.vertexium.event.MarkVisiblePropertyEvent;
import org.vertexium.event.MarkVisibleVertexEvent;
import org.vertexium.event.SoftDeleteEdgeEvent;
import org.vertexium.event.SoftDeletePropertyEvent;
import org.vertexium.event.SoftDeleteVertexEvent;
import org.vertexium.mutation.AlterPropertyVisibility;
import org.vertexium.mutation.PropertyDeleteMutation;
import org.vertexium.mutation.PropertySoftDeleteMutation;
import org.vertexium.mutation.SetPropertyMetadata;
import org.vertexium.property.MutableProperty;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.property.StreamingPropertyValueRef;
import org.vertexium.search.IndexHint;
import org.vertexium.util.CloseableIterable;
import org.vertexium.util.EmptyClosableIterable;
import org.vertexium.util.IncreasingTime;
import org.vertexium.util.IterableUtils;
import org.vertexium.util.JavaSerializableUtils;
import org.vertexium.util.LookAheadIterable;
import org.vertexium.util.Preconditions;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class AccumuloGraph
extends GraphBaseWithSearchIndex
implements Traceable {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(AccumuloGraph.class);
    static final AccumuloGraphLogger GRAPH_LOGGER = new AccumuloGraphLogger(QUERY_LOGGER);
    private static final String ROW_DELETING_ITERATOR_NAME = RowDeletingIterator.class.getSimpleName();
    private static final int ROW_DELETING_ITERATOR_PRIORITY = 7;
    private static final Object addIteratorLock = new Object();
    private static final Integer METADATA_ACCUMULO_GRAPH_VERSION = 2;
    private static final String METADATA_ACCUMULO_GRAPH_VERSION_KEY = "accumulo.graph.version";
    private static final String METADATA_SERIALIZER = "accumulo.graph.serializer";
    private static final Authorizations METADATA_AUTHORIZATIONS = new AccumuloAuthorizations(new String[0]);
    public static final int SINGLE_VERSION = 1;
    public static final Integer ALL_VERSIONS = null;
    private static final int ACCUMULO_DEFAULT_VERSIONING_ITERATOR_PRIORITY = 20;
    private static final String ACCUMULO_DEFAULT_VERSIONING_ITERATOR_NAME = "vers";
    private static final ColumnVisibility EMPTY_COLUMN_VISIBILITY = new ColumnVisibility();
    private static final String CLASSPATH_CONTEXT_NAME = "vertexium";
    private final Connector connector;
    private final VertexiumSerializer vertexiumSerializer;
    private final FileSystem fileSystem;
    private final String dataDir;
    private final CuratorFramework curatorFramework;
    private final boolean historyInSeparateTable;
    private ThreadLocal<VertexiumMultiTableBatchWriter> elementWriter = new ThreadLocal();
    private ThreadLocal<BatchWriter> metadataWriter = new ThreadLocal();
    protected ElementMutationBuilder elementMutationBuilder;
    private final Queue<GraphEvent> graphEventQueue = new LinkedList<GraphEvent>();
    private Integer accumuloGraphVersion;
    private boolean foundVertexiumSerializerMetadata;
    private final AccumuloNameSubstitutionStrategy nameSubstitutionStrategy;
    private final String verticesTableName;
    private final String historyVerticesTableName;
    private final String edgesTableName;
    private final String historyEdgesTableName;
    private final String dataTableName;
    private final String metadataTableName;
    private final int numberOfQueryThreads;
    private AccumuloGraphMetadataStore graphMetadataStore;
    private boolean distributedTraceEnabled;

    protected AccumuloGraph(AccumuloGraphConfiguration config, Connector connector, FileSystem fileSystem) {
        super((GraphConfiguration)config);
        this.connector = connector;
        this.vertexiumSerializer = config.createSerializer((Graph)this);
        this.fileSystem = fileSystem;
        this.dataDir = config.getDataDir();
        this.nameSubstitutionStrategy = AccumuloNameSubstitutionStrategy.create(config.createSubstitutionStrategy((Graph)this));
        long maxStreamingPropertyValueTableDataSize = config.getMaxStreamingPropertyValueTableDataSize();
        this.elementMutationBuilder = new ElementMutationBuilder(fileSystem, this.vertexiumSerializer, maxStreamingPropertyValueTableDataSize, this.dataDir){

            @Override
            protected void saveVertexMutation(Mutation m) {
                AccumuloGraph.this.addMutations(ElementType.VERTEX, m);
            }

            @Override
            protected void saveEdgeMutation(Mutation m) {
                AccumuloGraph.this.addMutations(ElementType.EDGE, m);
            }

            @Override
            protected AccumuloNameSubstitutionStrategy getNameSubstitutionStrategy() {
                return AccumuloGraph.this.getNameSubstitutionStrategy();
            }

            @Override
            protected void saveDataMutation(Mutation dataMutation) {
                AccumuloGraph.this._addMutations(AccumuloGraph.this.getDataWriter(), dataMutation);
            }

            @Override
            protected StreamingPropertyValueRef saveStreamingPropertyValue(String rowKey, Property property, StreamingPropertyValue propertyValue) {
                StreamingPropertyValueRef streamingPropertyValueRef = super.saveStreamingPropertyValue(rowKey, property, propertyValue);
                ((MutableProperty)property).setValue((Object)streamingPropertyValueRef.toStreamingPropertyValue((Graph)AccumuloGraph.this, property.getTimestamp()));
                return streamingPropertyValueRef;
            }
        };
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        this.curatorFramework = CuratorFrameworkFactory.newClient((String)config.getZookeeperServers(), (RetryPolicy)retryPolicy);
        this.curatorFramework.start();
        String zkPath = config.getZookeeperMetadataSyncPath();
        this.graphMetadataStore = new AccumuloGraphMetadataStore(this.curatorFramework, zkPath);
        this.verticesTableName = AccumuloGraph.getVerticesTableName(this.getConfiguration().getTableNamePrefix());
        this.edgesTableName = AccumuloGraph.getEdgesTableName(this.getConfiguration().getTableNamePrefix());
        this.dataTableName = AccumuloGraph.getDataTableName(this.getConfiguration().getTableNamePrefix());
        this.metadataTableName = AccumuloGraph.getMetadataTableName(this.getConfiguration().getTableNamePrefix());
        this.numberOfQueryThreads = this.getConfiguration().getNumberOfQueryThreads();
        this.historyInSeparateTable = this.getConfiguration().isHistoryInSeparateTable();
        if (this.isHistoryInSeparateTable()) {
            this.historyVerticesTableName = AccumuloGraph.getHistoryVerticesTableName(this.getConfiguration().getTableNamePrefix());
            this.historyEdgesTableName = AccumuloGraph.getHistoryEdgesTableName(this.getConfiguration().getTableNamePrefix());
        } else {
            this.historyVerticesTableName = null;
            this.historyEdgesTableName = null;
        }
    }

    public static AccumuloGraph create(AccumuloGraphConfiguration config) throws AccumuloSecurityException, AccumuloException, VertexiumException, InterruptedException, IOException, URISyntaxException {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        Connector connector = config.createConnector();
        FileSystem fs = config.createFileSystem();
        if (config.isHistoryInSeparateTable()) {
            AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getVerticesTableName(config.getTableNamePrefix()), 1, config.getHdfsContextClasspath(), config.isCreateTables());
            AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getEdgesTableName(config.getTableNamePrefix()), 1, config.getHdfsContextClasspath(), config.isCreateTables());
            AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getHistoryVerticesTableName(config.getTableNamePrefix()), config.getMaxVersions(), config.getHdfsContextClasspath(), config.isCreateTables());
            AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getHistoryEdgesTableName(config.getTableNamePrefix()), config.getMaxVersions(), config.getHdfsContextClasspath(), config.isCreateTables());
            AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getHistoryVerticesTableName(config.getTableNamePrefix()));
            AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getHistoryEdgesTableName(config.getTableNamePrefix()));
        } else {
            AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getVerticesTableName(config.getTableNamePrefix()), config.getMaxVersions(), config.getHdfsContextClasspath(), config.isCreateTables());
            AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getEdgesTableName(config.getTableNamePrefix()), config.getMaxVersions(), config.getHdfsContextClasspath(), config.isCreateTables());
        }
        AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getDataTableName(config.getTableNamePrefix()), 1, config.getHdfsContextClasspath(), config.isCreateTables());
        AccumuloGraph.ensureTableExists(connector, AccumuloGraph.getMetadataTableName(config.getTableNamePrefix()), 1, config.getHdfsContextClasspath(), config.isCreateTables());
        AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getVerticesTableName(config.getTableNamePrefix()));
        AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getEdgesTableName(config.getTableNamePrefix()));
        AccumuloGraph.ensureRowDeletingIteratorIsAttached(connector, AccumuloGraph.getDataTableName(config.getTableNamePrefix()));
        AccumuloGraph graph = new AccumuloGraph(config, connector, fs);
        graph.setup();
        return graph;
    }

    protected void setup() {
        super.setup();
        if (this.accumuloGraphVersion == null) {
            this.setMetadata(METADATA_ACCUMULO_GRAPH_VERSION_KEY, METADATA_ACCUMULO_GRAPH_VERSION);
        } else if (!METADATA_ACCUMULO_GRAPH_VERSION.equals(this.accumuloGraphVersion)) {
            throw new VertexiumException("Invalid accumulo graph version. Expected " + METADATA_ACCUMULO_GRAPH_VERSION + " found " + this.accumuloGraphVersion);
        }
    }

    protected void setupGraphMetadata() {
        this.foundVertexiumSerializerMetadata = false;
        super.setupGraphMetadata();
        if (!this.foundVertexiumSerializerMetadata) {
            this.setMetadata(METADATA_SERIALIZER, this.vertexiumSerializer.getClass().getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setupGraphMetadata(GraphMetadataEntry graphMetadataEntry) {
        super.setupGraphMetadata(graphMetadataEntry);
        if (graphMetadataEntry.getKey().equals(METADATA_ACCUMULO_GRAPH_VERSION_KEY)) {
            if (!(graphMetadataEntry.getValue() instanceof Integer)) throw new VertexiumException("Invalid accumulo version in metadata. " + graphMetadataEntry);
            this.accumuloGraphVersion = (Integer)graphMetadataEntry.getValue();
            LOGGER.info("%s=%s", new Object[]{METADATA_ACCUMULO_GRAPH_VERSION_KEY, this.accumuloGraphVersion});
            return;
        } else {
            if (!graphMetadataEntry.getKey().equals(METADATA_SERIALIZER)) return;
            if (!(graphMetadataEntry.getValue() instanceof String)) throw new VertexiumException("Invalid accumulo.graph.serializer expected string found " + graphMetadataEntry.getValue().getClass().getName());
            String vertexiumSerializerClassName = (String)graphMetadataEntry.getValue();
            if (!vertexiumSerializerClassName.equals(this.vertexiumSerializer.getClass().getName())) {
                throw new VertexiumException("Invalid accumulo.graph.serializer expected " + vertexiumSerializerClassName + " found " + this.vertexiumSerializer.getClass().getName());
            }
            this.foundVertexiumSerializerMetadata = true;
        }
    }

    protected static void ensureTableExists(Connector connector, String tableName, Integer maxVersions, String hdfsContextClasspath, boolean createTable) {
        try {
            if (!connector.tableOperations().exists(tableName)) {
                if (!createTable) {
                    throw new VertexiumException("Table '" + tableName + "' does not exist and 'graph." + "createTables" + "' is set to false");
                }
                NewTableConfiguration ntc = new NewTableConfiguration().setTimeType(TimeType.MILLIS).withoutDefaultIterators();
                connector.tableOperations().create(tableName, ntc);
                if (maxVersions != null) {
                    IteratorSetting versioningSettings = new IteratorSetting(20, ACCUMULO_DEFAULT_VERSIONING_ITERATOR_NAME, VersioningIterator.class);
                    VersioningIterator.setMaxVersions((IteratorSetting)versioningSettings, (int)maxVersions);
                    EnumSet<IteratorUtil.IteratorScope> scope = EnumSet.allOf(IteratorUtil.IteratorScope.class);
                    connector.tableOperations().attachIterator(tableName, versioningSettings, scope);
                }
            }
            if (hdfsContextClasspath != null) {
                connector.instanceOperations().setProperty("general.vfs.context.classpath.vertexium-" + tableName, hdfsContextClasspath);
                connector.tableOperations().setProperty(tableName, "table.classpath.context", "vertexium-" + tableName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create table " + tableName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void ensureRowDeletingIteratorIsAttached(Connector connector, String tableName) {
        try {
            Object object = addIteratorLock;
            synchronized (object) {
                block8: {
                    IteratorSetting is = new IteratorSetting(7, ROW_DELETING_ITERATOR_NAME, RowDeletingIterator.class);
                    if (!connector.tableOperations().listIterators(tableName).containsKey(ROW_DELETING_ITERATOR_NAME)) {
                        try {
                            connector.tableOperations().attachIterator(tableName, is);
                        }
                        catch (Exception ex) {
                            int SLEEP_TIME = 5000;
                            LOGGER.warn("Failed to attach RowDeletingIterator. Retrying in %dms.", new Object[]{5000});
                            Thread.sleep(5000L);
                            if (connector.tableOperations().listIterators(tableName).containsKey(ROW_DELETING_ITERATOR_NAME)) break block8;
                            connector.tableOperations().attachIterator(tableName, is);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new VertexiumException("Could not attach RowDeletingIterator", (Throwable)e);
        }
    }

    public static AccumuloGraph create(Map config) throws AccumuloSecurityException, AccumuloException, VertexiumException, InterruptedException, IOException, URISyntaxException {
        return AccumuloGraph.create(new AccumuloGraphConfiguration(config));
    }

    public AccumuloVertexBuilder prepareVertex(String vertexId, Long timestamp, Visibility visibility) {
        if (vertexId == null) {
            vertexId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        final String finalVertexId = vertexId;
        return new AccumuloVertexBuilder(finalVertexId, visibility, this.elementMutationBuilder){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Vertex save(Authorizations authorizations) {
                Span trace = Trace.start((String)"prepareVertex");
                trace.data("vertexId", finalVertexId);
                try {
                    this.getElementMutationBuilder().saveVertexBuilder(AccumuloGraph.this, this, timestampLong);
                    AccumuloVertex vertex = this.createVertex(authorizations);
                    if (this.getIndexHint() != IndexHint.DO_NOT_INDEX) {
                        AccumuloGraph.this.getSearchIndex().addElement((Graph)AccumuloGraph.this, (Element)vertex, authorizations);
                    }
                    if (AccumuloGraph.this.hasEventListeners()) {
                        AccumuloGraph.this.queueEvent((GraphEvent)new AddVertexEvent((Graph)AccumuloGraph.this, (Vertex)vertex));
                        for (Property property : this.getProperties()) {
                            AccumuloGraph.this.queueEvent((GraphEvent)new AddPropertyEvent((Graph)AccumuloGraph.this, (Element)vertex, property));
                        }
                        for (PropertyDeleteMutation propertyDeleteMutation : this.getPropertyDeletes()) {
                            AccumuloGraph.this.queueEvent((GraphEvent)new DeletePropertyEvent((Graph)AccumuloGraph.this, (Element)vertex, propertyDeleteMutation));
                        }
                    }
                    Iterator iterator = vertex;
                    return iterator;
                }
                finally {
                    trace.stop();
                }
            }

            @Override
            protected AccumuloVertex createVertex(Authorizations authorizations) {
                Iterable<Visibility> hiddenVisibilities = null;
                return new AccumuloVertex(AccumuloGraph.this, this.getVertexId(), this.getVisibility(), (Iterable<Property>)this.getProperties(), (Iterable<PropertyDeleteMutation>)this.getPropertyDeletes(), (Iterable<PropertySoftDeleteMutation>)this.getPropertySoftDeletes(), hiddenVisibilities, timestampLong, authorizations);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEvent(GraphEvent graphEvent) {
        Queue<GraphEvent> queue = this.graphEventQueue;
        synchronized (queue) {
            this.graphEventQueue.add(graphEvent);
        }
    }

    void saveProperties(AccumuloElement element, Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeletes, Iterable<PropertySoftDeleteMutation> propertySoftDeletes, IndexHint indexHint, Authorizations authorizations) {
        String elementRowKey = element.getId();
        Mutation m = new Mutation((CharSequence)elementRowKey);
        boolean hasProperty = false;
        for (PropertyDeleteMutation propertyDelete : propertyDeletes) {
            hasProperty = true;
            this.elementMutationBuilder.addPropertyDeleteToMutation(m, propertyDelete);
        }
        for (PropertySoftDeleteMutation propertySoftDelete : propertySoftDeletes) {
            hasProperty = true;
            this.elementMutationBuilder.addPropertySoftDeleteToMutation(m, propertySoftDelete);
        }
        for (Property property : properties) {
            hasProperty = true;
            this.elementMutationBuilder.addPropertyToMutation(this, m, elementRowKey, property);
        }
        if (hasProperty) {
            this.addMutations((Element)element, m);
        }
        if (indexHint != IndexHint.DO_NOT_INDEX) {
            ArrayList propertyList = Lists.newArrayList();
            propertyDeletes.forEach(p -> propertyList.add(PropertyDescriptor.fromPropertyDeleteMutation((PropertyDeleteMutation)p)));
            propertySoftDeletes.forEach(p -> propertyList.add(PropertyDescriptor.fromPropertySoftDeleteMutation((PropertySoftDeleteMutation)p)));
            this.getSearchIndex().deleteProperties((Graph)this, (Element)element, (Collection)propertyList, authorizations);
            this.getSearchIndex().addElement((Graph)this, (Element)element, authorizations);
        }
        if (this.hasEventListeners()) {
            for (Property property : properties) {
                this.queueEvent((GraphEvent)new AddPropertyEvent((Graph)this, (Element)element, property));
            }
            for (PropertyDeleteMutation propertyDeleteMutation : propertyDeletes) {
                this.queueEvent((GraphEvent)new DeletePropertyEvent((Graph)this, (Element)element, propertyDeleteMutation));
            }
            for (PropertySoftDeleteMutation propertySoftDeleteMutation : propertySoftDeletes) {
                this.queueEvent((GraphEvent)new SoftDeletePropertyEvent((Graph)this, (Element)element, propertySoftDeleteMutation));
            }
        }
    }

    void deleteProperty(AccumuloElement element, Property property, Authorizations authorizations) {
        Mutation m = new Mutation((CharSequence)element.getId());
        this.elementMutationBuilder.addPropertyDeleteToMutation(m, property);
        this.addMutations((Element)element, m);
        this.getSearchIndex().deleteProperty((Graph)this, (Element)element, PropertyDescriptor.fromProperty((Property)property), authorizations);
        if (this.hasEventListeners()) {
            this.queueEvent((GraphEvent)new DeletePropertyEvent((Graph)this, (Element)element, property));
        }
    }

    void softDeleteProperty(AccumuloElement element, Property property, Authorizations authorizations) {
        Mutation m = new Mutation((CharSequence)element.getId());
        this.elementMutationBuilder.addPropertySoftDeleteToMutation(m, property);
        this.addMutations((Element)element, m);
        this.getSearchIndex().deleteProperty((Graph)this, (Element)element, PropertyDescriptor.fromProperty((Property)property), authorizations);
        if (this.hasEventListeners()) {
            this.queueEvent((GraphEvent)new SoftDeletePropertyEvent((Graph)this, (Element)element, property));
        }
    }

    protected void addMutations(Element element, Mutation ... mutations) {
        this.addMutations(ElementType.getTypeFromElement((Element)element), mutations);
    }

    protected void addMutations(ElementType elementType, Mutation ... mutations) {
        this._addMutations(this.getWriterFromElementType(elementType), mutations);
        if (this.isHistoryInSeparateTable()) {
            this._addMutations(this.getHistoryWriterFromElementType(elementType), mutations);
        }
    }

    protected void _addMutations(BatchWriter writer, Mutation ... mutations) {
        try {
            for (Mutation mutation : mutations) {
                writer.addMutation(mutation);
            }
            if (this.getConfiguration().isAutoFlush()) {
                this.flush();
            }
        }
        catch (MutationsRejectedException ex) {
            throw new RuntimeException("Could not add mutation", ex);
        }
    }

    private BatchWriter getElementWriter(String tableName) {
        if (this.elementWriter.get() == null) {
            BatchWriterConfig writerConfig = this.getConfiguration().createBatchWriterConfig();
            this.elementWriter.set(new VertexiumMultiTableBatchWriter(this.connector.createMultiTableBatchWriter(writerConfig)));
        }
        return this.elementWriter.get().getBatchWriter(tableName);
    }

    public BatchWriter getVerticesWriter() {
        return this.getElementWriter(this.getVerticesTableName());
    }

    public BatchWriter getHistoryVerticesWriter() {
        return this.getElementWriter(this.getHistoryVerticesTableName());
    }

    public BatchWriter getEdgesWriter() {
        return this.getElementWriter(this.getEdgesTableName());
    }

    public BatchWriter getHistoryEdgesWriter() {
        return this.getElementWriter(this.getHistoryEdgesTableName());
    }

    public BatchWriter getDataWriter() {
        return this.getElementWriter(this.getDataTableName());
    }

    public BatchWriter getWriterFromElementType(Element element) {
        return this.getWriterFromElementType(ElementType.getTypeFromElement((Element)element));
    }

    public BatchWriter getWriterFromElementType(ElementType elementType) {
        switch (elementType) {
            case VERTEX: {
                return this.getVerticesWriter();
            }
            case EDGE: {
                return this.getEdgesWriter();
            }
        }
        throw new VertexiumException("Unexpected element type: " + elementType);
    }

    public BatchWriter getHistoryWriterFromElementType(Element element) {
        return this.getHistoryWriterFromElementType(ElementType.getTypeFromElement((Element)element));
    }

    public BatchWriter getHistoryWriterFromElementType(ElementType elementType) {
        switch (elementType) {
            case VERTEX: {
                return this.getHistoryVerticesWriter();
            }
            case EDGE: {
                return this.getHistoryEdgesWriter();
            }
        }
        throw new VertexiumException("Unexpected element type: " + elementType);
    }

    protected BatchWriter getMetadataWriter() {
        try {
            if (this.metadataWriter.get() != null) {
                return this.metadataWriter.get();
            }
            BatchWriterConfig writerConfig = this.getConfiguration().createBatchWriterConfig();
            this.metadataWriter.set(this.connector.createBatchWriter(this.getMetadataTableName(), writerConfig));
            return this.metadataWriter.get();
        }
        catch (TableNotFoundException ex) {
            throw new RuntimeException("Could not create batch writer", ex);
        }
    }

    public Iterable<Vertex> getVertices(EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) throws VertexiumException {
        Span trace = Trace.start((String)"getVertices");
        return this.getVerticesInRange(trace, null, null, fetchHints, endTime, authorizations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVertex(Vertex vertex, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)vertex, (Object)"vertex cannot be null");
        Span trace = Trace.start((String)"deleteVertex");
        trace.data("vertexId", vertex.getId());
        try {
            this.getSearchIndex().deleteElement((Graph)this, (Element)vertex, authorizations);
            for (Edge edge : vertex.getEdges(Direction.BOTH, authorizations)) {
                this.deleteEdge(edge, authorizations);
            }
            Mutation deleteRowMutation = this.getDeleteRowMutation(vertex.getId());
            this.addMutations(ElementType.VERTEX, deleteRowMutation);
            if (this.hasEventListeners()) {
                this.queueEvent((GraphEvent)new DeleteVertexEvent((Graph)this, vertex));
            }
        }
        finally {
            trace.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void softDeleteVertex(Vertex vertex, Long timestamp, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)vertex, (Object)"vertex cannot be null");
        Span trace = Trace.start((String)"softDeleteVertex");
        trace.data("vertexId", vertex.getId());
        try {
            if (timestamp == null) {
                timestamp = IncreasingTime.currentTimeMillis();
            }
            this.getSearchIndex().deleteElement((Graph)this, (Element)vertex, authorizations);
            for (Edge edge : vertex.getEdges(Direction.BOTH, authorizations)) {
                this.softDeleteEdge(edge, timestamp, authorizations);
            }
            this.addMutations(ElementType.VERTEX, this.getSoftDeleteRowMutation(vertex.getId(), timestamp));
            if (this.hasEventListeners()) {
                this.queueEvent((GraphEvent)new SoftDeleteVertexEvent((Graph)this, vertex));
            }
        }
        finally {
            trace.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markVertexHidden(Vertex vertex, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)vertex, (Object)"vertex cannot be null");
        Span trace = Trace.start((String)"softDeleteVertex");
        trace.data("vertexId", vertex.getId());
        try {
            ColumnVisibility columnVisibility = AccumuloGraph.visibilityToAccumuloVisibility(visibility);
            for (Edge edge : vertex.getEdges(Direction.BOTH, authorizations)) {
                this.markEdgeHidden(edge, visibility, authorizations);
            }
            this.addMutations(ElementType.VERTEX, this.getMarkHiddenRowMutation(vertex.getId(), columnVisibility));
            if (this.hasEventListeners()) {
                this.queueEvent((GraphEvent)new MarkHiddenVertexEvent((Graph)this, vertex));
            }
        }
        finally {
            trace.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markVertexVisible(Vertex vertex, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)vertex, (Object)"vertex cannot be null");
        Span trace = Trace.start((String)"softDeleteVertex");
        trace.data("vertexId", vertex.getId());
        try {
            ColumnVisibility columnVisibility = AccumuloGraph.visibilityToAccumuloVisibility(visibility);
            for (Edge edge : vertex.getEdges(Direction.BOTH, FetchHint.ALL_INCLUDING_HIDDEN, authorizations)) {
                this.markEdgeVisible(edge, visibility, authorizations);
            }
            this.addMutations(ElementType.VERTEX, this.getMarkVisibleRowMutation(vertex.getId(), columnVisibility));
            if (this.hasEventListeners()) {
                this.queueEvent((GraphEvent)new MarkVisibleVertexEvent((Graph)this, vertex));
            }
        }
        finally {
            trace.stop();
        }
    }

    public AccumuloEdgeBuilderByVertexId prepareEdge(String edgeId, String outVertexId, String inVertexId, String label, Long timestamp, Visibility visibility) {
        Preconditions.checkNotNull((Object)outVertexId, (Object)"outVertexId cannot be null");
        Preconditions.checkNotNull((Object)inVertexId, (Object)"inVertexId cannot be null");
        Preconditions.checkNotNull((Object)label, (Object)"label cannot be null");
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        final String finalEdgeId = edgeId;
        return new AccumuloEdgeBuilderByVertexId(finalEdgeId, outVertexId, inVertexId, label, visibility, this.elementMutationBuilder){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Edge save(Authorizations authorizations) {
                Span trace = Trace.start((String)"prepareEdge");
                trace.data("edgeId", finalEdgeId);
                try {
                    AccumuloGraph.this.elementMutationBuilder.saveEdgeBuilder(AccumuloGraph.this, (EdgeBuilderBase)this, timestampLong);
                    AccumuloEdge edge = AccumuloGraph.this.createEdge(AccumuloGraph.this, (EdgeBuilderBase)this, timestampLong, authorizations);
                    Edge edge2 = AccumuloGraph.this.savePreparedEdge((EdgeBuilderBase)this, edge, null, authorizations);
                    return edge2;
                }
                finally {
                    trace.stop();
                }
            }

            @Override
            protected AccumuloEdge createEdge(Authorizations authorizations) {
                return AccumuloGraph.this.createEdge(AccumuloGraph.this, (EdgeBuilderBase)this, timestampLong, authorizations);
            }
        };
    }

    public EdgeBuilder prepareEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Long timestamp, Visibility visibility) {
        Preconditions.checkNotNull((Object)outVertex, (Object)"outVertex cannot be null");
        Preconditions.checkNotNull((Object)inVertex, (Object)"inVertex cannot be null");
        Preconditions.checkNotNull((Object)label, (Object)"label cannot be null");
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        final String finalEdgeId = edgeId;
        return new EdgeBuilder(finalEdgeId, outVertex, inVertex, label, visibility){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Edge save(Authorizations authorizations) {
                Span trace = Trace.start((String)"prepareEdge");
                trace.data("edgeId", finalEdgeId);
                try {
                    AddEdgeToVertexRunnable addEdgeToVertex = new AddEdgeToVertexRunnable(){

                        @Override
                        public void run(AccumuloEdge edge) {
                            if (this.getOutVertex() instanceof AccumuloVertex) {
                                ((AccumuloVertex)this.getOutVertex()).addOutEdge(edge);
                            }
                            if (this.getInVertex() instanceof AccumuloVertex) {
                                ((AccumuloVertex)this.getInVertex()).addInEdge(edge);
                            }
                        }
                    };
                    AccumuloGraph.this.elementMutationBuilder.saveEdgeBuilder(AccumuloGraph.this, (EdgeBuilderBase)this, timestampLong);
                    AccumuloEdge edge = AccumuloGraph.this.createEdge(AccumuloGraph.this, (EdgeBuilderBase)this, timestampLong, authorizations);
                    Edge edge2 = AccumuloGraph.this.savePreparedEdge((EdgeBuilderBase)this, edge, addEdgeToVertex, authorizations);
                    return edge2;
                }
                finally {
                    trace.stop();
                }
            }
        };
    }

    private AccumuloEdge createEdge(AccumuloGraph accumuloGraph, EdgeBuilderBase edgeBuilder, long timestamp, Authorizations authorizations) {
        Iterable<Visibility> hiddenVisibilities = null;
        AccumuloEdge edge = new AccumuloEdge((Graph)accumuloGraph, edgeBuilder.getEdgeId(), edgeBuilder.getOutVertexId(), edgeBuilder.getInVertexId(), edgeBuilder.getLabel(), edgeBuilder.getNewEdgeLabel(), edgeBuilder.getVisibility(), edgeBuilder.getProperties(), edgeBuilder.getPropertyDeletes(), edgeBuilder.getPropertySoftDeletes(), hiddenVisibilities, timestamp, authorizations);
        return edge;
    }

    private Edge savePreparedEdge(EdgeBuilderBase edgeBuilder, AccumuloEdge edge, AddEdgeToVertexRunnable addEdgeToVertex, Authorizations authorizations) {
        if (addEdgeToVertex != null) {
            addEdgeToVertex.run(edge);
        }
        if (edgeBuilder.getIndexHint() != IndexHint.DO_NOT_INDEX) {
            this.getSearchIndex().addElement((Graph)this, (Element)edge, authorizations);
        }
        if (this.hasEventListeners()) {
            this.queueEvent((GraphEvent)new AddEdgeEvent((Graph)this, (Edge)edge));
            for (Property property : edgeBuilder.getProperties()) {
                this.queueEvent((GraphEvent)new AddPropertyEvent((Graph)this, (Element)edge, property));
            }
            for (PropertyDeleteMutation propertyDeleteMutation : edgeBuilder.getPropertyDeletes()) {
                this.queueEvent((GraphEvent)new DeletePropertyEvent((Graph)this, (Element)edge, propertyDeleteMutation));
            }
            for (PropertySoftDeleteMutation propertySoftDeleteMutation : edgeBuilder.getPropertySoftDeletes()) {
                this.queueEvent((GraphEvent)new SoftDeletePropertyEvent((Graph)this, (Element)edge, propertySoftDeleteMutation));
            }
        }
        return edge;
    }

    public AccumuloNameSubstitutionStrategy getNameSubstitutionStrategy() {
        return this.nameSubstitutionStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(Element element, String key, String name, Visibility visibility, Long startTime, Long endTime, Authorizations authorizations) {
        Span trace = Trace.start((String)"getHistoricalPropertyValues");
        if (Trace.isTracing()) {
            trace.data("key", key);
            trace.data("name", name);
            trace.data("visibility", visibility.getVisibilityString());
            if (startTime != null) {
                trace.data("startTime", Long.toString(startTime));
            }
            if (endTime != null) {
                trace.data("endTime", Long.toString(endTime));
            }
        }
        try {
            TreeSet treeSet;
            ElementType elementType = ElementType.getTypeFromElement((Element)element);
            EnumSet<FetchHint> fetchHints = EnumSet.of(FetchHint.PROPERTIES, FetchHint.PROPERTY_METADATA);
            this.traceDataFetchHints(trace, fetchHints);
            org.apache.accumulo.core.data.Range range = RangeUtils.createRangeFromString(element.getId());
            ScannerBase scanner = this.createElementScanner(fetchHints, elementType, ALL_VERSIONS, startTime, endTime, Lists.newArrayList((Object[])new org.apache.accumulo.core.data.Range[]{range}), false, authorizations);
            try {
                String cq;
                HashMap<String, HistoricalPropertyValue> results = new HashMap<String, HistoricalPropertyValue>();
                ArrayListMultimap activeVisibilities = ArrayListMultimap.create();
                HashMap softDeleteObserved = Maps.newHashMap();
                for (Map.Entry column : scanner) {
                    PropertyMetadataColumnQualifier propertyMetadataColumnQualifier;
                    HistoricalPropertyValue hpv;
                    String resultsKey;
                    PropertyColumnQualifier propertyColumnQualifier;
                    cq = ((Key)column.getKey()).getColumnQualifier().toString();
                    String columnVisibility = ((Key)column.getKey()).getColumnVisibility().toString();
                    if (((Key)column.getKey()).getColumnFamily().equals((Object)AccumuloElement.CF_PROPERTY)) {
                        if (visibility != null && !columnVisibility.equals(visibility.getVisibilityString())) continue;
                        propertyColumnQualifier = KeyHelper.createPropertyColumnQualifier(cq, this.getNameSubstitutionStrategy());
                        if (name != null && !propertyColumnQualifier.getPropertyName().equals(name) || key != null && !propertyColumnQualifier.getPropertyKey().equals(key)) continue;
                        resultsKey = propertyColumnQualifier.getDiscriminator(columnVisibility, ((Key)column.getKey()).getTimestamp());
                        long timestamp = ((Key)column.getKey()).getTimestamp();
                        Object value = this.vertexiumSerializer.bytesToObject(((Value)column.getValue()).get());
                        Metadata metadata = new Metadata();
                        Set hiddenVisibilities = null;
                        if (value instanceof StreamingPropertyValueTableRef) {
                            value = ((StreamingPropertyValueTableRef)((Object)value)).toStreamingPropertyValue(this, timestamp);
                        }
                        String propertyKey = propertyColumnQualifier.getPropertyKey();
                        String propertyName = propertyColumnQualifier.getPropertyName();
                        Visibility propertyVisibility = AccumuloGraph.accumuloVisibilityToVisibility(columnVisibility);
                        HistoricalPropertyValue hpv2 = new HistoricalPropertyValue.HistoricalPropertyValueBuilder(propertyKey, propertyName, timestamp).propertyVisibility(propertyVisibility).value(value).metadata(metadata).hiddenVisibilities(hiddenVisibilities).build();
                        String propIdent = propertyKey + ":" + propertyName;
                        activeVisibilities.put((Object)propIdent, (Object)columnVisibility);
                        results.put(resultsKey, hpv2);
                        continue;
                    }
                    if (((Key)column.getKey()).getColumnFamily().equals((Object)AccumuloElement.CF_PROPERTY_SOFT_DELETE)) {
                        propertyColumnQualifier = KeyHelper.createPropertyColumnQualifier(cq, this.getNameSubstitutionStrategy());
                        String propertyKey = propertyColumnQualifier.getPropertyKey();
                        String propertyName = propertyColumnQualifier.getPropertyName();
                        String propIdent = propertyKey + ":" + propertyName;
                        activeVisibilities.remove((Object)propIdent, (Object)columnVisibility);
                        softDeleteObserved.put(propIdent, column.getKey());
                        continue;
                    }
                    if (!((Key)column.getKey()).getColumnFamily().equals((Object)AccumuloElement.CF_PROPERTY_METADATA) || (hpv = (HistoricalPropertyValue)results.get(resultsKey = (propertyMetadataColumnQualifier = KeyHelper.createPropertyMetadataColumnQualifier(cq, this.getNameSubstitutionStrategy())).getPropertyDiscriminator(((Key)column.getKey()).getTimestamp()))) == null) continue;
                    Object value = this.vertexiumSerializer.bytesToObject(((Value)column.getValue()).get());
                    Visibility metadataVisibility = AccumuloGraph.accumuloVisibilityToVisibility(columnVisibility);
                    hpv.getMetadata().add(propertyMetadataColumnQualifier.getMetadataKey(), value, metadataVisibility);
                }
                for (Key entry : softDeleteObserved.values()) {
                    cq = entry.getColumnQualifier().toString();
                    PropertyColumnQualifier propertyColumnQualifier = KeyHelper.createPropertyColumnQualifier(cq, this.getNameSubstitutionStrategy());
                    String propertyKey = propertyColumnQualifier.getPropertyKey();
                    String propertyName = propertyColumnQualifier.getPropertyName();
                    String propIdent = propertyKey + ":" + propertyName;
                    List active = activeVisibilities.get((Object)propIdent);
                    if (active != null && !active.isEmpty()) continue;
                    long timestamp = entry.getTimestamp() + 1L;
                    String columnVisibility = entry.getColumnVisibility().toString();
                    Visibility propertyVisibility = AccumuloGraph.accumuloVisibilityToVisibility(columnVisibility);
                    HistoricalPropertyValue hpv = new HistoricalPropertyValue.HistoricalPropertyValueBuilder(propertyKey, propertyName, timestamp).propertyVisibility(propertyVisibility).isDeleted(Boolean.valueOf(true)).build();
                    String resultsKey = propertyColumnQualifier.getDiscriminator(columnVisibility, timestamp);
                    results.put(resultsKey, hpv);
                }
                treeSet = new TreeSet(results.values());
            }
            catch (Throwable throwable) {
                scanner.close();
                throw throwable;
            }
            scanner.close();
            return treeSet;
        }
        finally {
            trace.stop();
        }
    }

    public List<InputStream> getStreamingPropertyValueInputStreams(List<StreamingPropertyValue> streamingPropertyValues) {
        if (streamingPropertyValues.size() == 0) {
            return Collections.emptyList();
        }
        List<StreamingPropertyValueTable> notLoadedTableSpvs = streamingPropertyValues.stream().filter(spv -> spv instanceof StreamingPropertyValueTable).map(spv -> (StreamingPropertyValueTable)((Object)spv)).filter(spv -> !spv.isDataLoaded()).collect(Collectors.toList());
        List<String> dataRowKeys = notLoadedTableSpvs.stream().map(StreamingPropertyValueTable::getDataRowKey).collect(Collectors.toList());
        Map<String, byte[]> tableInputStreams = this.streamingPropertyValueTableDatas(dataRowKeys);
        notLoadedTableSpvs.forEach(spv -> {
            String dataRowKey = spv.getDataRowKey();
            byte[] bytes = (byte[])tableInputStreams.get(dataRowKey);
            if (bytes == null) {
                throw new VertexiumException("Could not find StreamingPropertyValue data: " + dataRowKey);
            }
            spv.setData(bytes);
        });
        return streamingPropertyValues.stream().map(StreamingPropertyValue::getInputStream).collect(Collectors.toList());
    }

    public CloseableIterable<Edge> getEdges(EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        Span trace = Trace.start((String)"getEdges");
        return this.getEdgesInRange(trace, null, null, fetchHints, endTime, authorizations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEdge(Edge edge, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)edge);
        Span trace = Trace.start((String)"deleteEdge");
        trace.data("edgeId", edge.getId());
        try {
            this.getSearchIndex().deleteElement((Graph)this, (Element)edge, authorizations);
            ColumnVisibility visibility = AccumuloGraph.visibilityToAccumuloVisibility(edge.getVisibility());
            Mutation outMutation = new Mutation((CharSequence)edge.getVertexId(Direction.OUT));
            outMutation.putDelete(AccumuloVertex.CF_OUT_EDGE, new Text(edge.getId()), visibility);
            Mutation inMutation = new Mutation((CharSequence)edge.getVertexId(Direction.IN));
            inMutation.putDelete(AccumuloVertex.CF_IN_EDGE, new Text(edge.getId()), visibility);
            this.addMutations(ElementType.VERTEX, outMutation, inMutation);
            this.addMutations(ElementType.EDGE, this.getDeleteRowMutation(edge.getId()));
            if (this.hasEventListeners()) {
                this.queueEvent((GraphEvent)new DeleteEdgeEvent((Graph)this, edge));
            }
        }
        finally {
            trace.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void softDeleteEdge(Edge edge, Long timestamp, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)edge);
        Span trace = Trace.start((String)"softDeleteEdge");
        trace.data("edgeId", edge.getId());
        try {
            if (timestamp == null) {
                timestamp = IncreasingTime.currentTimeMillis();
            }
            this.getSearchIndex().deleteElement((Graph)this, (Element)edge, authorizations);
            ColumnVisibility visibility = AccumuloGraph.visibilityToAccumuloVisibility(edge.getVisibility());
            Mutation outMutation = new Mutation((CharSequence)edge.getVertexId(Direction.OUT));
            outMutation.put(AccumuloVertex.CF_OUT_EDGE_SOFT_DELETE, new Text(edge.getId()), visibility, timestamp.longValue(), AccumuloElement.SOFT_DELETE_VALUE);
            Mutation inMutation = new Mutation((CharSequence)edge.getVertexId(Direction.IN));
            inMutation.put(AccumuloVertex.CF_IN_EDGE_SOFT_DELETE, new Text(edge.getId()), visibility, timestamp.longValue(), AccumuloElement.SOFT_DELETE_VALUE);
            this.addMutations(ElementType.VERTEX, outMutation, inMutation);
            this.addMutations(ElementType.EDGE, this.getSoftDeleteRowMutation(edge.getId(), timestamp));
            if (this.hasEventListeners()) {
                this.queueEvent((GraphEvent)new SoftDeleteEdgeEvent((Graph)this, edge));
            }
        }
        finally {
            trace.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markEdgeHidden(Edge edge, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)edge);
        Span trace = Trace.start((String)"markEdgeHidden");
        trace.data("edgeId", edge.getId());
        try {
            Vertex out = edge.getVertex(Direction.OUT, authorizations);
            if (out == null) {
                throw new VertexiumException(String.format("Unable to mark edge hidden %s, can't find out vertex %s", edge.getId(), edge.getVertexId(Direction.OUT)));
            }
            Vertex in = edge.getVertex(Direction.IN, authorizations);
            if (in == null) {
                throw new VertexiumException(String.format("Unable to mark edge hidden %s, can't find in vertex %s", edge.getId(), edge.getVertexId(Direction.IN)));
            }
            ColumnVisibility columnVisibility = AccumuloGraph.visibilityToAccumuloVisibility(visibility);
            Mutation outMutation = new Mutation((CharSequence)out.getId());
            outMutation.put(AccumuloVertex.CF_OUT_EDGE_HIDDEN, new Text(edge.getId()), columnVisibility, AccumuloElement.HIDDEN_VALUE);
            Mutation inMutation = new Mutation((CharSequence)in.getId());
            inMutation.put(AccumuloVertex.CF_IN_EDGE_HIDDEN, new Text(edge.getId()), columnVisibility, AccumuloElement.HIDDEN_VALUE);
            this.addMutations(ElementType.VERTEX, outMutation, inMutation);
            this.addMutations(ElementType.EDGE, this.getMarkHiddenRowMutation(edge.getId(), columnVisibility));
            if (out instanceof AccumuloVertex) {
                ((AccumuloVertex)out).removeOutEdge(edge);
            }
            if (in instanceof AccumuloVertex) {
                ((AccumuloVertex)in).removeInEdge(edge);
            }
            if (this.hasEventListeners()) {
                this.queueEvent((GraphEvent)new MarkHiddenEdgeEvent((Graph)this, edge));
            }
        }
        finally {
            trace.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markEdgeVisible(Edge edge, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)edge);
        Span trace = Trace.start((String)"markEdgeVisible");
        trace.data("edgeId", edge.getId());
        try {
            Vertex out = edge.getVertex(Direction.OUT, FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
            if (out == null) {
                throw new VertexiumException(String.format("Unable to mark edge visible %s, can't find out vertex %s", edge.getId(), edge.getVertexId(Direction.OUT)));
            }
            Vertex in = edge.getVertex(Direction.IN, FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
            if (in == null) {
                throw new VertexiumException(String.format("Unable to mark edge visible %s, can't find in vertex %s", edge.getId(), edge.getVertexId(Direction.IN)));
            }
            ColumnVisibility columnVisibility = AccumuloGraph.visibilityToAccumuloVisibility(visibility);
            Mutation outMutation = new Mutation((CharSequence)out.getId());
            outMutation.putDelete(AccumuloVertex.CF_OUT_EDGE_HIDDEN, new Text(edge.getId()), columnVisibility);
            Mutation inMutation = new Mutation((CharSequence)in.getId());
            inMutation.putDelete(AccumuloVertex.CF_IN_EDGE_HIDDEN, new Text(edge.getId()), columnVisibility);
            this.addMutations(ElementType.VERTEX, outMutation, inMutation);
            this.addMutations(ElementType.EDGE, this.getMarkVisibleRowMutation(edge.getId(), columnVisibility));
            if (out instanceof AccumuloVertex) {
                ((AccumuloVertex)out).addOutEdge(edge);
            }
            if (in instanceof AccumuloVertex) {
                ((AccumuloVertex)in).addInEdge(edge);
            }
            if (this.hasEventListeners()) {
                this.queueEvent((GraphEvent)new MarkVisibleEdgeEvent((Graph)this, edge));
            }
        }
        finally {
            trace.stop();
        }
    }

    public Authorizations createAuthorizations(String ... auths) {
        return new AccumuloAuthorizations(auths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markPropertyHidden(AccumuloElement element, Property property, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)element);
        Span trace = Trace.start((String)"markPropertyHidden");
        trace.data("elementId", element.getId());
        trace.data("propertyName", property.getName());
        trace.data("propertyKey", property.getKey());
        try {
            if (timestamp == null) {
                timestamp = IncreasingTime.currentTimeMillis();
            }
            ColumnVisibility columnVisibility = AccumuloGraph.visibilityToAccumuloVisibility(visibility);
            if (element instanceof Vertex) {
                this.addMutations(ElementType.VERTEX, this.getMarkHiddenPropertyMutation(element.getId(), property, timestamp, columnVisibility));
            } else if (element instanceof Edge) {
                this.addMutations(ElementType.EDGE, this.getMarkHiddenPropertyMutation(element.getId(), property, timestamp, columnVisibility));
            }
            if (this.hasEventListeners()) {
                this.fireGraphEvent((GraphEvent)new MarkHiddenPropertyEvent((Graph)this, (Element)element, property, visibility));
            }
        }
        finally {
            trace.stop();
        }
    }

    private Mutation getMarkHiddenPropertyMutation(String rowKey, Property property, long timestamp, ColumnVisibility visibility) {
        Mutation m = new Mutation((CharSequence)rowKey);
        Text columnQualifier = KeyHelper.getColumnQualifierFromPropertyHiddenColumnQualifier(property, this.getNameSubstitutionStrategy());
        m.put(AccumuloElement.CF_PROPERTY_HIDDEN, columnQualifier, visibility, timestamp, AccumuloElement.HIDDEN_VALUE);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markPropertyVisible(AccumuloElement element, Property property, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)element);
        Span trace = Trace.start((String)"markPropertyVisible");
        trace.data("elementId", element.getId());
        trace.data("propertyName", property.getName());
        trace.data("propertyKey", property.getKey());
        try {
            if (timestamp == null) {
                timestamp = IncreasingTime.currentTimeMillis();
            }
            ColumnVisibility columnVisibility = AccumuloGraph.visibilityToAccumuloVisibility(visibility);
            if (element instanceof Vertex) {
                this.addMutations(ElementType.VERTEX, this.getMarkVisiblePropertyMutation(element.getId(), property, timestamp, columnVisibility));
            } else if (element instanceof Edge) {
                this.addMutations(ElementType.EDGE, this.getMarkVisiblePropertyMutation(element.getId(), property, timestamp, columnVisibility));
            }
            if (this.hasEventListeners()) {
                this.fireGraphEvent((GraphEvent)new MarkVisiblePropertyEvent((Graph)this, (Element)element, property, visibility));
            }
        }
        finally {
            trace.stop();
        }
    }

    private Mutation getMarkVisiblePropertyMutation(String rowKey, Property property, long timestamp, ColumnVisibility visibility) {
        Mutation m = new Mutation((CharSequence)rowKey);
        Text columnQualifier = KeyHelper.getColumnQualifierFromPropertyHiddenColumnQualifier(property, this.getNameSubstitutionStrategy());
        m.put(AccumuloElement.CF_PROPERTY_HIDDEN, columnQualifier, visibility, timestamp, AccumuloElement.HIDDEN_VALUE_DELETED);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.hasEventListeners()) {
            Queue<GraphEvent> queue = this.graphEventQueue;
            synchronized (queue) {
                this.flushWritersAndSuper();
                this.flushGraphEventQueue();
            }
        } else {
            this.flushWritersAndSuper();
        }
    }

    private void flushWritersAndSuper() {
        AccumuloGraph.flushWriter(this.elementWriter.get());
        super.flush();
    }

    private void flushGraphEventQueue() {
        GraphEvent graphEvent;
        while ((graphEvent = this.graphEventQueue.poll()) != null) {
            this.fireGraphEvent(graphEvent);
        }
    }

    private static void flushWriter(VertexiumMultiTableBatchWriter writer) {
        if (writer == null) {
            return;
        }
        writer.flush();
    }

    public void shutdown() {
        try {
            this.flush();
            super.shutdown();
            this.fileSystem.close();
            this.graphMetadataStore.close();
            this.curatorFramework.close();
        }
        catch (Exception ex) {
            throw new VertexiumException(ex);
        }
    }

    private Mutation getDeleteRowMutation(String rowKey) {
        Mutation m = new Mutation((CharSequence)rowKey);
        m.put(AccumuloElement.DELETE_ROW_COLUMN_FAMILY, AccumuloElement.DELETE_ROW_COLUMN_QUALIFIER, RowDeletingIterator.DELETE_ROW_VALUE);
        return m;
    }

    private Mutation getSoftDeleteRowMutation(String rowKey, long timestamp) {
        Mutation m = new Mutation((CharSequence)rowKey);
        m.put(AccumuloElement.CF_SOFT_DELETE, AccumuloElement.CQ_SOFT_DELETE, timestamp, AccumuloElement.SOFT_DELETE_VALUE);
        return m;
    }

    private Mutation getMarkHiddenRowMutation(String rowKey, ColumnVisibility visibility) {
        Mutation m = new Mutation((CharSequence)rowKey);
        m.put(AccumuloElement.CF_HIDDEN, AccumuloElement.CQ_HIDDEN, visibility, AccumuloElement.HIDDEN_VALUE);
        return m;
    }

    private Mutation getMarkVisibleRowMutation(String rowKey, ColumnVisibility visibility) {
        Mutation m = new Mutation((CharSequence)rowKey);
        m.putDelete(AccumuloElement.CF_HIDDEN, AccumuloElement.CQ_HIDDEN, visibility);
        return m;
    }

    public VertexiumSerializer getVertexiumSerializer() {
        return this.vertexiumSerializer;
    }

    public AccumuloGraphConfiguration getConfiguration() {
        return (AccumuloGraphConfiguration)super.getConfiguration();
    }

    public Vertex getVertex(String vertexId, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) throws VertexiumException {
        try {
            if (vertexId == null) {
                return null;
            }
            Span trace = Trace.start((String)"getVertex");
            trace.data("vertexId", vertexId);
            this.traceDataFetchHints(trace, fetchHints);
            return (Vertex)IterableUtils.singleOrDefault(this.getVerticesInRange(trace, new org.apache.accumulo.core.data.Range((CharSequence)vertexId), fetchHints, endTime, authorizations), null);
        }
        catch (IllegalStateException ex) {
            throw new VertexiumException("Failed to find vertex with id: " + vertexId, (Throwable)ex);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof AccumuloSecurityException) {
                throw new SecurityVertexiumException("Could not get vertex " + vertexId + " with authorizations: " + authorizations, authorizations, ex.getCause());
            }
            throw ex;
        }
    }

    public Iterable<Vertex> getVerticesWithPrefix(String vertexIdPrefix, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        Span trace = Trace.start((String)"getVerticesWithPrefix");
        trace.data("vertexIdPrefix", vertexIdPrefix);
        this.traceDataFetchHints(trace, fetchHints);
        org.apache.accumulo.core.data.Range range = org.apache.accumulo.core.data.Range.prefix((CharSequence)vertexIdPrefix);
        return this.getVerticesInRange(trace, range, fetchHints, endTime, authorizations);
    }

    public Iterable<Vertex> getVerticesInRange(Range idRange, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        Span trace = Trace.start((String)"getVerticesInRange");
        trace.data("rangeInclusiveStart", idRange.getInclusiveStart());
        trace.data("rangeExclusiveStart", idRange.getExclusiveEnd());
        this.traceDataFetchHints(trace, fetchHints);
        org.apache.accumulo.core.data.Range range = this.vertexiumRangeToAccumuloRange(idRange);
        return this.getVerticesInRange(trace, range, fetchHints, endTime, authorizations);
    }

    private CloseableIterable<Vertex> getVerticesInRange(Span trace, String startId, String endId, EnumSet<FetchHint> fetchHints, Long timestamp, Authorizations authorizations) throws VertexiumException {
        trace.data("startId", startId);
        trace.data("endId", endId);
        if (Trace.isTracing() && timestamp != null) {
            trace.data("timestamp", Long.toString(timestamp));
        }
        this.traceDataFetchHints(trace, fetchHints);
        Key startKey = startId == null ? null : new Key((CharSequence)startId);
        Key endKey = endId == null ? null : new Key((CharSequence)endId).followingKey(PartialKey.ROW);
        org.apache.accumulo.core.data.Range range = new org.apache.accumulo.core.data.Range(startKey, endKey);
        return this.getVerticesInRange(trace, range, fetchHints, timestamp, authorizations);
    }

    protected ScannerBase createVertexScanner(EnumSet<FetchHint> fetchHints, Integer maxVersions, Long startTime, Long endTime, org.apache.accumulo.core.data.Range range, Authorizations authorizations) throws VertexiumException {
        return this.createElementScanner(fetchHints, ElementType.VERTEX, maxVersions, startTime, endTime, Lists.newArrayList((Object[])new org.apache.accumulo.core.data.Range[]{range}), authorizations);
    }

    protected ScannerBase createEdgeScanner(EnumSet<FetchHint> fetchHints, Integer maxVersions, Long startTime, Long endTime, org.apache.accumulo.core.data.Range range, Authorizations authorizations) throws VertexiumException {
        return this.createElementScanner(fetchHints, ElementType.EDGE, maxVersions, startTime, endTime, Lists.newArrayList((Object[])new org.apache.accumulo.core.data.Range[]{range}), authorizations);
    }

    private ScannerBase createElementScanner(EnumSet<FetchHint> fetchHints, ElementType elementType, Integer maxVersions, Long startTime, Long endTime, Collection<org.apache.accumulo.core.data.Range> ranges, Authorizations authorizations) throws VertexiumException {
        return this.createElementScanner(fetchHints, elementType, maxVersions, startTime, endTime, ranges, true, authorizations);
    }

    ScannerBase createElementScanner(EnumSet<FetchHint> fetchHints, ElementType elementType, Integer maxVersions, Long startTime, Long endTime, Collection<org.apache.accumulo.core.data.Range> ranges, boolean useVertexiumElementIterators, Authorizations authorizations) throws VertexiumException {
        try {
            ScannerBase scanner;
            String tableName = this.isHistoryInSeparateTable() && (startTime != null || endTime != null || maxVersions == null || maxVersions > 1) ? this.getHistoryTableNameFromElementType(elementType) : this.getTableNameFromElementType(elementType);
            if (ranges == null || ranges.size() == 1) {
                org.apache.accumulo.core.data.Range range = ranges == null ? null : ranges.iterator().next();
                scanner = this.createScanner(tableName, range, authorizations);
            } else {
                scanner = this.createBatchScanner(tableName, ranges, authorizations);
            }
            if (startTime != null || endTime != null) {
                IteratorSetting iteratorSetting = new IteratorSetting(80, TimestampFilter.class.getSimpleName(), TimestampFilter.class);
                if (startTime != null) {
                    TimestampFilter.setStart((IteratorSetting)iteratorSetting, (long)startTime, (boolean)true);
                }
                if (endTime != null) {
                    TimestampFilter.setEnd((IteratorSetting)iteratorSetting, (long)endTime, (boolean)true);
                }
                scanner.addScanIterator(iteratorSetting);
            }
            if (maxVersions != null) {
                IteratorSetting versioningIteratorSettings = new IteratorSetting(90, VersioningIterator.class.getSimpleName(), VersioningIterator.class);
                VersioningIterator.setMaxVersions((IteratorSetting)versioningIteratorSettings, (int)maxVersions);
                scanner.addScanIterator(versioningIteratorSettings);
            }
            if (useVertexiumElementIterators) {
                if (elementType == ElementType.VERTEX) {
                    IteratorSetting vertexIteratorSettings = new IteratorSetting(1000, VertexIterator.class.getSimpleName(), VertexIterator.class);
                    VertexIterator.setFetchHints((IteratorSetting)vertexIteratorSettings, AccumuloGraph.toIteratorFetchHints(fetchHints));
                    scanner.addScanIterator(vertexIteratorSettings);
                } else if (elementType == ElementType.EDGE) {
                    IteratorSetting edgeIteratorSettings = new IteratorSetting(1000, EdgeIterator.class.getSimpleName(), EdgeIterator.class);
                    EdgeIterator.setFetchHints((IteratorSetting)edgeIteratorSettings, AccumuloGraph.toIteratorFetchHints(fetchHints));
                    scanner.addScanIterator(edgeIteratorSettings);
                } else {
                    throw new VertexiumException("Unexpected element type: " + elementType);
                }
            }
            this.applyFetchHints(scanner, fetchHints, elementType);
            GRAPH_LOGGER.logStartIterator(scanner);
            return scanner;
        }
        catch (TableNotFoundException e) {
            throw new VertexiumException((Exception)((Object)e));
        }
    }

    public static EnumSet<org.vertexium.accumulo.iterator.model.FetchHint> toIteratorFetchHints(EnumSet<FetchHint> fetchHints) {
        ArrayList<org.vertexium.accumulo.iterator.model.FetchHint> results = new ArrayList<org.vertexium.accumulo.iterator.model.FetchHint>();
        for (FetchHint fetchHint : fetchHints) {
            results.add(AccumuloGraph.toIteratorFetchHint(fetchHint));
        }
        return org.vertexium.accumulo.iterator.model.FetchHint.create(results);
    }

    private static org.vertexium.accumulo.iterator.model.FetchHint toIteratorFetchHint(FetchHint fetchHint) {
        return org.vertexium.accumulo.iterator.model.FetchHint.valueOf((String)fetchHint.name());
    }

    protected ScannerBase createVertexScanner(EnumSet<FetchHint> fetchHints, Integer maxVersions, Long startTime, Long endTime, Collection<org.apache.accumulo.core.data.Range> ranges, Authorizations authorizations) throws VertexiumException {
        return this.createElementScanner(fetchHints, ElementType.VERTEX, maxVersions, startTime, endTime, ranges, authorizations);
    }

    protected ScannerBase createEdgeScanner(EnumSet<FetchHint> fetchHints, Integer maxVersions, Long startTime, Long endTime, Collection<org.apache.accumulo.core.data.Range> ranges, Authorizations authorizations) throws VertexiumException {
        return this.createElementScanner(fetchHints, ElementType.EDGE, maxVersions, startTime, endTime, ranges, authorizations);
    }

    private ScannerBase createBatchScanner(String tableName, Collection<org.apache.accumulo.core.data.Range> ranges, Authorizations authorizations) throws TableNotFoundException {
        org.apache.accumulo.core.security.Authorizations accumuloAuthorizations = this.toAccumuloAuthorizations(authorizations);
        return this.createBatchScanner(tableName, ranges, accumuloAuthorizations);
    }

    private ScannerBase createBatchScanner(String tableName, Collection<org.apache.accumulo.core.data.Range> ranges, org.apache.accumulo.core.security.Authorizations accumuloAuthorizations) throws TableNotFoundException {
        BatchScanner scanner = this.connector.createBatchScanner(tableName, accumuloAuthorizations, this.numberOfQueryThreads);
        scanner.setRanges(ranges);
        return scanner;
    }

    private Scanner createScanner(String tableName, org.apache.accumulo.core.data.Range range, Authorizations authorizations) throws TableNotFoundException {
        org.apache.accumulo.core.security.Authorizations accumuloAuthorizations = this.toAccumuloAuthorizations(authorizations);
        return this.createScanner(tableName, range, accumuloAuthorizations);
    }

    private Scanner createScanner(String tableName, org.apache.accumulo.core.data.Range range, org.apache.accumulo.core.security.Authorizations accumuloAuthorizations) throws TableNotFoundException {
        Scanner scanner = this.connector.createScanner(tableName, accumuloAuthorizations);
        if (range != null) {
            scanner.setRange(range);
        }
        return scanner;
    }

    private void applyFetchHints(ScannerBase scanner, EnumSet<FetchHint> fetchHints, ElementType elementType) {
        scanner.clearColumns();
        if (fetchHints.equals(FetchHint.ALL)) {
            return;
        }
        Iterable<Text> columnFamiliesToFetch = AccumuloGraph.getColumnFamiliesToFetch(elementType, fetchHints);
        for (Text columnFamilyToFetch : columnFamiliesToFetch) {
            scanner.fetchColumnFamily(columnFamilyToFetch);
        }
    }

    public static Iterable<Text> getColumnFamiliesToFetch(ElementType elementType, EnumSet<FetchHint> fetchHints) {
        ArrayList<Text> columnFamiliesToFetch = new ArrayList<Text>();
        columnFamiliesToFetch.add(AccumuloElement.CF_HIDDEN);
        columnFamiliesToFetch.add(AccumuloElement.CF_SOFT_DELETE);
        if (elementType == ElementType.VERTEX) {
            columnFamiliesToFetch.add(AccumuloVertex.CF_SIGNAL);
        } else if (elementType == ElementType.EDGE) {
            columnFamiliesToFetch.add(AccumuloEdge.CF_SIGNAL);
            columnFamiliesToFetch.add(AccumuloEdge.CF_IN_VERTEX);
            columnFamiliesToFetch.add(AccumuloEdge.CF_OUT_VERTEX);
        } else {
            throw new VertexiumException("Unhandled element type: " + elementType);
        }
        if (fetchHints.contains(FetchHint.IN_EDGE_REFS) || fetchHints.contains(FetchHint.IN_EDGE_LABELS)) {
            columnFamiliesToFetch.add(AccumuloVertex.CF_IN_EDGE);
            columnFamiliesToFetch.add(AccumuloVertex.CF_IN_EDGE_HIDDEN);
            columnFamiliesToFetch.add(AccumuloVertex.CF_IN_EDGE_SOFT_DELETE);
        }
        if (fetchHints.contains(FetchHint.OUT_EDGE_REFS) || fetchHints.contains(FetchHint.OUT_EDGE_LABELS)) {
            columnFamiliesToFetch.add(AccumuloVertex.CF_OUT_EDGE);
            columnFamiliesToFetch.add(AccumuloVertex.CF_OUT_EDGE_HIDDEN);
            columnFamiliesToFetch.add(AccumuloVertex.CF_OUT_EDGE_SOFT_DELETE);
        }
        if (fetchHints.contains(FetchHint.PROPERTIES)) {
            columnFamiliesToFetch.add(AccumuloElement.CF_PROPERTY);
            columnFamiliesToFetch.add(AccumuloElement.CF_PROPERTY_HIDDEN);
            columnFamiliesToFetch.add(AccumuloElement.CF_PROPERTY_SOFT_DELETE);
        }
        if (fetchHints.contains(FetchHint.PROPERTY_METADATA)) {
            columnFamiliesToFetch.add(AccumuloElement.CF_PROPERTY_METADATA);
            columnFamiliesToFetch.add(AccumuloElement.CF_PROPERTY_HIDDEN);
            columnFamiliesToFetch.add(AccumuloElement.CF_PROPERTY_SOFT_DELETE);
        }
        return columnFamiliesToFetch;
    }

    public String getTableNameFromElementType(ElementType elementType) {
        switch (elementType) {
            case VERTEX: {
                return this.getVerticesTableName();
            }
            case EDGE: {
                return this.getEdgesTableName();
            }
        }
        throw new VertexiumException("Unexpected element type: " + elementType);
    }

    public String getHistoryTableNameFromElementType(ElementType elementType) {
        switch (elementType) {
            case VERTEX: {
                return this.getHistoryVerticesTableName();
            }
            case EDGE: {
                return this.getHistoryEdgesTableName();
            }
        }
        throw new VertexiumException("Unexpected element type: " + elementType);
    }

    public org.apache.accumulo.core.security.Authorizations toAccumuloAuthorizations(Authorizations authorizations) {
        if (authorizations == null) {
            throw new NullPointerException("authorizations is required");
        }
        return new org.apache.accumulo.core.security.Authorizations(authorizations.getAuthorizations());
    }

    public Edge getEdge(String edgeId, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        Span trace = Trace.start((String)"getEdge");
        trace.data("edgeId", edgeId);
        try {
            return (Edge)IterableUtils.singleOrDefault(this.getEdgesInRange(trace, edgeId, edgeId, fetchHints, endTime, authorizations), null);
        }
        catch (IllegalStateException ex) {
            throw new VertexiumException("Failed to find edge with id: " + edgeId, (Throwable)ex);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof AccumuloSecurityException) {
                throw new SecurityVertexiumException("Could not get edge " + edgeId + " with authorizations: " + authorizations, authorizations, ex.getCause());
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] streamingPropertyValueTableData(String dataRowKey, Long timestamp) {
        Iterator iterator;
        ArrayList ranges = Lists.newArrayList((Object[])new org.apache.accumulo.core.data.Range[]{RangeUtils.createRangeFromString(dataRowKey)});
        long timerStartTime = System.currentTimeMillis();
        ScannerBase scanner = this.createBatchScanner(this.getDataTableName(), (Collection<org.apache.accumulo.core.data.Range>)ranges, new org.apache.accumulo.core.security.Authorizations());
        if (timestamp != null && !DataTableRowKey.isLegacy(dataRowKey)) {
            IteratorSetting iteratorSetting = new IteratorSetting(80, TimestampFilter.class.getSimpleName(), TimestampFilter.class);
            TimestampFilter.setStart((IteratorSetting)iteratorSetting, (long)timestamp, (boolean)true);
            scanner.addScanIterator(iteratorSetting);
        }
        GRAPH_LOGGER.logStartIterator(scanner);
        Span trace = Trace.start((String)"streamingPropertyValueTableData");
        trace.data("dataRowKeyCount", Integer.toString(1));
        try {
            byte[] result = null;
            for (Map.Entry col : scanner) {
                String foundKey = ((Key)col.getKey()).getRow().toString();
                byte[] value = ((Value)col.getValue()).get();
                if (!foundKey.equals(dataRowKey)) continue;
                result = value;
            }
            if (result == null) {
                throw new VertexiumException("Could not find data with key: " + dataRowKey);
            }
            iterator = result;
        }
        catch (Throwable throwable) {
            try {
                scanner.close();
                trace.stop();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
                throw throwable;
            }
            catch (Exception ex) {
                throw new VertexiumException(ex);
            }
        }
        scanner.close();
        trace.stop();
        GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, byte[]> streamingPropertyValueTableDatas(List<String> dataRowKeys) {
        HashMap<String, byte[]> hashMap;
        if (dataRowKeys.size() == 0) {
            return Collections.emptyMap();
        }
        List<org.apache.accumulo.core.data.Range> ranges = dataRowKeys.stream().map(RangeUtils::createRangeFromString).collect(Collectors.toList());
        long timerStartTime = System.currentTimeMillis();
        ScannerBase scanner = this.createBatchScanner(this.getDataTableName(), ranges, new org.apache.accumulo.core.security.Authorizations());
        GRAPH_LOGGER.logStartIterator(scanner);
        Span trace = Trace.start((String)"streamingPropertyValueTableData");
        trace.data("dataRowKeyCount", Integer.toString(dataRowKeys.size()));
        try {
            HashMap<String, byte[]> results = new HashMap<String, byte[]>();
            for (Map.Entry col : scanner) {
                results.put(((Key)col.getKey()).getRow().toString(), ((Value)col.getValue()).get());
            }
            hashMap = results;
        }
        catch (Throwable throwable) {
            try {
                scanner.close();
                trace.stop();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
                throw throwable;
            }
            catch (Exception ex) {
                throw new VertexiumException(ex);
            }
        }
        scanner.close();
        trace.stop();
        GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
        return hashMap;
    }

    public static ColumnVisibility visibilityToAccumuloVisibility(Visibility visibility) {
        return new ColumnVisibility(visibility.getVisibilityString());
    }

    public static ColumnVisibility visibilityToAccumuloVisibility(String visibilityString) {
        return new ColumnVisibility(visibilityString);
    }

    public static Visibility accumuloVisibilityToVisibility(ColumnVisibility columnVisibility) {
        if (columnVisibility.equals(EMPTY_COLUMN_VISIBILITY)) {
            return Visibility.EMPTY;
        }
        String columnVisibilityString = columnVisibility.toString();
        return AccumuloGraph.accumuloVisibilityToVisibility(columnVisibilityString);
    }

    public static Visibility accumuloVisibilityToVisibility(String columnVisibilityString) {
        if (columnVisibilityString.startsWith("[") && columnVisibilityString.endsWith("]")) {
            if (columnVisibilityString.length() == 2) {
                return Visibility.EMPTY;
            }
            columnVisibilityString = columnVisibilityString.substring(1, columnVisibilityString.length() - 1);
        }
        if (columnVisibilityString.length() == 0) {
            return Visibility.EMPTY;
        }
        return new Visibility(columnVisibilityString);
    }

    public static String getVerticesTableName(String tableNamePrefix) {
        return tableNamePrefix + "_v";
    }

    public static String getHistoryVerticesTableName(String tableNamePrefix) {
        return tableNamePrefix + "_vh";
    }

    public static String getEdgesTableName(String tableNamePrefix) {
        return tableNamePrefix.concat("_e");
    }

    public static String getHistoryEdgesTableName(String tableNamePrefix) {
        return tableNamePrefix.concat("_eh");
    }

    public static String getDataTableName(String tableNamePrefix) {
        return tableNamePrefix.concat("_d");
    }

    public static String getMetadataTableName(String tableNamePrefix) {
        return tableNamePrefix.concat("_m");
    }

    public String getVerticesTableName() {
        return this.verticesTableName;
    }

    public String getHistoryVerticesTableName() {
        return this.historyVerticesTableName;
    }

    public String getEdgesTableName() {
        return this.edgesTableName;
    }

    public String getHistoryEdgesTableName() {
        return this.historyEdgesTableName;
    }

    public String getDataTableName() {
        return this.dataTableName;
    }

    public String getMetadataTableName() {
        return this.metadataTableName;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Iterable<Range> listVerticesTableSplits() {
        return this.listTableSplits(this.getVerticesTableName());
    }

    public Iterable<Range> listHistoryVerticesTableSplits() {
        return this.listTableSplits(this.getHistoryVerticesTableName());
    }

    public Iterable<Range> listEdgesTableSplits() {
        return this.listTableSplits(this.getEdgesTableName());
    }

    public Iterable<Range> listHistoryEdgesTableSplits() {
        return this.listTableSplits(this.getHistoryEdgesTableName());
    }

    public Iterable<Range> listDataTableSplits() {
        return this.listTableSplits(this.getDataTableName());
    }

    private Iterable<Range> listTableSplits(String tableName) {
        try {
            return this.splitsIterableToRangeIterable(this.getConnector().tableOperations().listSplits(tableName));
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not get splits for: " + tableName, (Throwable)ex);
        }
    }

    private Iterable<Range> splitsIterableToRangeIterable(Iterable<Text> splits) {
        String inclusiveStart = null;
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Text split : splits) {
            String exclusiveEnd = new Key(split).getRow().toString();
            ranges.add(new Range(inclusiveStart, exclusiveEnd));
            inclusiveStart = exclusiveEnd;
        }
        ranges.add(new Range(inclusiveStart, null));
        return ranges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void alterElementVisibility(AccumuloElement element, Visibility newVisibility, Authorizations authorizations) {
        String elementRowKey = element.getId();
        Visibility oldVisibility = element.getVisibility();
        Span trace = Trace.start((String)"alterElementVisibility");
        trace.data("elementRowKey", elementRowKey);
        try {
            Mutation m;
            if (element instanceof Edge) {
                String vertexInRowKey;
                Mutation vertexInMutation;
                Edge edge = (Edge)element;
                String vertexOutRowKey = edge.getVertexId(Direction.OUT);
                Mutation vertexOutMutation = new Mutation((CharSequence)vertexOutRowKey);
                if (this.elementMutationBuilder.alterEdgeVertexOutVertex(vertexOutMutation, edge, newVisibility)) {
                    this.addMutations(ElementType.VERTEX, vertexOutMutation);
                }
                if (this.elementMutationBuilder.alterEdgeVertexInVertex(vertexInMutation = new Mutation((CharSequence)(vertexInRowKey = edge.getVertexId(Direction.IN))), edge, newVisibility)) {
                    this.addMutations(ElementType.VERTEX, vertexInMutation);
                }
            }
            if (this.elementMutationBuilder.alterElementVisibility(m = new Mutation((CharSequence)elementRowKey), element, newVisibility)) {
                this.addMutations((Element)element, m);
            }
            element.setVisibility(newVisibility);
            this.getSearchIndex().alterElementVisibility((Graph)this, (Element)element, oldVisibility, newVisibility, authorizations);
        }
        finally {
            trace.stop();
        }
    }

    public void alterEdgeLabel(AccumuloEdge edge, String newEdgeLabel) {
        this.elementMutationBuilder.alterEdgeLabel(edge, newEdgeLabel);
    }

    void alterElementPropertyVisibilities(AccumuloElement element, List<AlterPropertyVisibility> alterPropertyVisibilities, Authorizations authorizations) {
        if (alterPropertyVisibilities.size() == 0) {
            return;
        }
        String elementRowKey = element.getId();
        Mutation m = new Mutation((CharSequence)elementRowKey);
        ArrayList propertyList = Lists.newArrayList();
        for (AlterPropertyVisibility apv : alterPropertyVisibilities) {
            MutableProperty property = (MutableProperty)element.getProperty(apv.getKey(), apv.getName(), apv.getExistingVisibility());
            if (property == null) {
                throw new VertexiumException("Could not find property " + apv.getKey() + ":" + apv.getName());
            }
            if (property.getVisibility().equals((Object)apv.getVisibility())) continue;
            if (apv.getExistingVisibility() == null) {
                apv.setExistingVisibility(property.getVisibility());
            }
            this.elementMutationBuilder.addPropertySoftDeleteToMutation(m, (Property)property);
            property.setVisibility(apv.getVisibility());
            property.setTimestamp(apv.getTimestamp());
            this.elementMutationBuilder.addPropertyToMutation(this, m, elementRowKey, (Property)property);
            propertyList.add(PropertyDescriptor.from((String)apv.getKey(), (String)apv.getName(), (Visibility)apv.getExistingVisibility()));
        }
        if (!propertyList.isEmpty()) {
            this.getSearchIndex().deleteProperties((Graph)this, (Element)element, (Collection)propertyList, authorizations);
            this.addMutations((Element)element, m);
        }
    }

    void alterPropertyMetadatas(AccumuloElement element, List<SetPropertyMetadata> setPropertyMetadatas) {
        if (setPropertyMetadatas.size() == 0) {
            return;
        }
        ArrayList<Property> propertiesToSave = new ArrayList<Property>();
        for (SetPropertyMetadata apm : setPropertyMetadatas) {
            Property property = element.getProperty(apm.getPropertyKey(), apm.getPropertyName(), apm.getPropertyVisibility());
            if (property == null) {
                throw new VertexiumException(String.format("Could not find property %s:%s(%s)", apm.getPropertyKey(), apm.getPropertyName(), apm.getPropertyVisibility()));
            }
            property.getMetadata().add(apm.getMetadataName(), apm.getNewValue(), apm.getMetadataVisibility());
            propertiesToSave.add(property);
        }
        String elementRowKey = element.getId();
        Mutation m = new Mutation((CharSequence)elementRowKey);
        for (Property property : propertiesToSave) {
            this.elementMutationBuilder.addPropertyMetadataToMutation(m, property);
        }
        this.addMutations((Element)element, m);
    }

    public boolean isVisibilityValid(Visibility visibility, Authorizations authorizations) {
        return authorizations.canRead(visibility);
    }

    private boolean isHistoryInSeparateTable() {
        return this.historyInSeparateTable;
    }

    public void truncate() {
        try {
            this.connector.tableOperations().deleteRows(this.getDataTableName(), null, null);
            this.connector.tableOperations().deleteRows(this.getEdgesTableName(), null, null);
            this.connector.tableOperations().deleteRows(this.getVerticesTableName(), null, null);
            this.connector.tableOperations().deleteRows(this.getMetadataTableName(), null, null);
            if (this.isHistoryInSeparateTable()) {
                this.connector.tableOperations().deleteRows(this.getHistoryEdgesTableName(), null, null);
                this.connector.tableOperations().deleteRows(this.getHistoryVerticesTableName(), null, null);
            }
            this.getSearchIndex().truncate((Graph)this);
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not delete rows", (Throwable)ex);
        }
    }

    public void drop() {
        try {
            this.dropTableIfExists(this.getDataTableName());
            this.dropTableIfExists(this.getEdgesTableName());
            this.dropTableIfExists(this.getVerticesTableName());
            this.dropTableIfExists(this.getMetadataTableName());
            if (this.isHistoryInSeparateTable()) {
                this.dropTableIfExists(this.getHistoryEdgesTableName());
                this.dropTableIfExists(this.getHistoryVerticesTableName());
            }
            this.getSearchIndex().drop((Graph)this);
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not drop tables", (Throwable)ex);
        }
    }

    private void dropTableIfExists(String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (this.connector.tableOperations().exists(tableName)) {
            this.connector.tableOperations().delete(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> findRelatedEdgeIds(Iterable<String> vertexIds, Long endTime, Authorizations authorizations) {
        Set vertexIdsSet = IterableUtils.toSet(vertexIds);
        Span trace = Trace.start((String)"findRelatedEdges");
        try {
            ArrayList<String> arrayList;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("findRelatedEdges:\n  %s", new Object[]{IterableUtils.join((Iterable)vertexIdsSet, (String)"\n  ")});
            }
            if (vertexIdsSet.size() == 0) {
                HashSet<String> hashSet = new HashSet<String>();
                return hashSet;
            }
            ArrayList<org.apache.accumulo.core.data.Range> ranges = new ArrayList<org.apache.accumulo.core.data.Range>();
            for (String vertexId : vertexIdsSet) {
                ranges.add(RangeUtils.createRangeFromString(vertexId));
            }
            Long startTime = null;
            int maxVersions = 1;
            ScannerBase scanner = this.createElementScanner(EnumSet.of(FetchHint.OUT_EDGE_REFS), ElementType.VERTEX, maxVersions, startTime, endTime, ranges, false, authorizations);
            IteratorSetting edgeRefFilterSettings = new IteratorSetting(1000, EdgeRefFilter.class.getSimpleName(), EdgeRefFilter.class);
            EdgeRefFilter.setVertexIds((IteratorSetting)edgeRefFilterSettings, (Set)vertexIdsSet);
            scanner.addScanIterator(edgeRefFilterSettings);
            IteratorSetting vertexEdgeIdIteratorSettings = new IteratorSetting(1001, VertexEdgeIdIterator.class.getSimpleName(), VertexEdgeIdIterator.class);
            scanner.addScanIterator(vertexEdgeIdIteratorSettings);
            long timerStartTime = System.currentTimeMillis();
            try {
                Iterator it = scanner.iterator();
                ArrayList<String> edgeIds = new ArrayList<String>();
                while (it.hasNext()) {
                    Map.Entry c = (Map.Entry)it.next();
                    for (ByteArrayWrapper edgeId : VertexEdgeIdIterator.decodeValue((Value)((Value)c.getValue()))) {
                        edgeIds.add(new Text(edgeId.getData()).toString());
                    }
                }
                arrayList = edgeIds;
            }
            catch (Throwable throwable) {
                scanner.close();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
                throw throwable;
            }
            scanner.close();
            GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            return arrayList;
        }
        finally {
            trace.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<RelatedEdge> findRelatedEdgeSummary(Iterable<String> vertexIds, Long endTime, Authorizations authorizations) {
        Set vertexIdsSet = IterableUtils.toSet(vertexIds);
        Span trace = Trace.start((String)"findRelatedEdgeSummary");
        try {
            ArrayList<Object> arrayList;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("findRelatedEdgeSummary:\n  %s", new Object[]{IterableUtils.join((Iterable)vertexIdsSet, (String)"\n  ")});
            }
            if (vertexIdsSet.size() == 0) {
                ArrayList<RelatedEdge> arrayList2 = new ArrayList<RelatedEdge>();
                return arrayList2;
            }
            ArrayList<org.apache.accumulo.core.data.Range> ranges = new ArrayList<org.apache.accumulo.core.data.Range>();
            for (String vertexId : vertexIdsSet) {
                ranges.add(RangeUtils.createRangeFromString(vertexId));
            }
            Long startTime = null;
            int maxVersions = 1;
            ScannerBase scanner = this.createElementScanner(EnumSet.of(FetchHint.OUT_EDGE_REFS), ElementType.VERTEX, maxVersions, startTime, endTime, ranges, false, authorizations);
            IteratorSetting edgeRefFilterSettings = new IteratorSetting(1000, EdgeRefFilter.class.getSimpleName(), EdgeRefFilter.class);
            EdgeRefFilter.setVertexIds((IteratorSetting)edgeRefFilterSettings, (Set)vertexIdsSet);
            scanner.addScanIterator(edgeRefFilterSettings);
            long timerStartTime = System.currentTimeMillis();
            try {
                ArrayList<Object> results = new ArrayList<Object>();
                ArrayList<String> softDeletedEdgeIds = new ArrayList<String>();
                for (Map.Entry row : scanner) {
                    Text columnFamily = ((Key)row.getKey()).getColumnFamily();
                    if (!columnFamily.equals((Object)AccumuloVertex.CF_OUT_EDGE)) {
                        if (!columnFamily.equals((Object)AccumuloVertex.CF_OUT_EDGE_SOFT_DELETE) && !columnFamily.equals((Object)AccumuloVertex.CF_OUT_EDGE_HIDDEN)) continue;
                        softDeletedEdgeIds.add(((Key)row.getKey()).getColumnQualifier().toString());
                        results.removeIf(relatedEdge -> softDeletedEdgeIds.contains(relatedEdge.getEdgeId()));
                        continue;
                    }
                    EdgeInfo edgeInfo = new EdgeInfo(((Value)row.getValue()).get(), ((Key)row.getKey()).getTimestamp());
                    String edgeId = ((Key)row.getKey()).getColumnQualifier().toString();
                    String outVertexId = ((Key)row.getKey()).getRow().toString();
                    String inVertexId = edgeInfo.getVertexId();
                    String label = this.getNameSubstitutionStrategy().inflate(edgeInfo.getLabel());
                    if (softDeletedEdgeIds.contains(edgeId)) continue;
                    results.add(new RelatedEdgeImpl(edgeId, label, outVertexId, inVertexId));
                }
                arrayList = results;
            }
            catch (Throwable throwable) {
                scanner.close();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
                throw throwable;
            }
            scanner.close();
            GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            return arrayList;
        }
        finally {
            trace.stop();
        }
    }

    public Iterable<Path> findPaths(FindPathOptions options, Authorizations authorizations) {
        ProgressCallback progressCallback = options.getProgressCallback();
        if (progressCallback == null) {
            progressCallback = new ProgressCallback(){

                public void progress(double progressPercent, ProgressCallback.Step step, Integer edgeIndex, Integer vertexCount) {
                    LOGGER.debug("findPaths progress %d%%: %s", new Object[]{(int)(progressPercent * 100.0), step.formatMessage(edgeIndex, vertexCount)});
                }
            };
        }
        return new AccumuloFindPathStrategy(this, options, progressCallback, authorizations).findPaths();
    }

    public Iterable<String> filterEdgeIdsByAuthorization(Iterable<String> edgeIds, String authorizationToMatch, EnumSet<ElementFilter> filters, Authorizations authorizations) {
        return this.filterElementIdsByAuthorization(ElementType.EDGE, edgeIds, authorizationToMatch, filters, authorizations);
    }

    public Iterable<String> filterVertexIdsByAuthorization(Iterable<String> vertexIds, String authorizationToMatch, EnumSet<ElementFilter> filters, Authorizations authorizations) {
        return this.filterElementIdsByAuthorization(ElementType.VERTEX, vertexIds, authorizationToMatch, filters, authorizations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<String> filterElementIdsByAuthorization(ElementType elementType, Iterable<String> elementIds, String authorizationToMatch, EnumSet<ElementFilter> filters, Authorizations authorizations) {
        Set elementIdsSet = IterableUtils.toSet(elementIds);
        Span trace = Trace.start((String)"filterElementIdsByAuthorization");
        try {
            HashSet<String> hashSet;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("filterElementIdsByAuthorization:\n  %s", new Object[]{IterableUtils.join((Iterable)elementIdsSet, (String)"\n  ")});
            }
            if (elementIdsSet.size() == 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                return arrayList;
            }
            ArrayList<org.apache.accumulo.core.data.Range> ranges = new ArrayList<org.apache.accumulo.core.data.Range>();
            for (String elementId : elementIdsSet) {
                ranges.add(RangeUtils.createRangeFromString(elementId));
            }
            Long startTime = null;
            Long endTime = null;
            int maxVersions = 1;
            ScannerBase scanner = this.createElementScanner(FetchHint.ALL_INCLUDING_HIDDEN, elementType, maxVersions, startTime, endTime, ranges, false, authorizations);
            IteratorSetting hasAuthorizationFilterSettings = new IteratorSetting(1000, HasAuthorizationFilter.class.getSimpleName(), HasAuthorizationFilter.class);
            HasAuthorizationFilter.setAuthorizationToMatch((IteratorSetting)hasAuthorizationFilterSettings, (String)authorizationToMatch);
            HasAuthorizationFilter.setFilters((IteratorSetting)hasAuthorizationFilterSettings, filters);
            scanner.addScanIterator(hasAuthorizationFilterSettings);
            long timerStartTime = System.currentTimeMillis();
            try {
                HashSet<String> results = new HashSet<String>();
                for (Map.Entry row : scanner) {
                    results.add(((Key)row.getKey()).getRow().toString());
                }
                hashSet = results;
            }
            catch (Throwable throwable) {
                scanner.close();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
                throw throwable;
            }
            scanner.close();
            GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            return hashSet;
        }
        finally {
            trace.stop();
        }
    }

    public Iterable<GraphMetadataEntry> getMetadataInRange(final org.apache.accumulo.core.data.Range range) {
        final long timerStartTime = System.currentTimeMillis();
        return new LookAheadIterable<Map.Entry<Key, Value>, GraphMetadataEntry>(){
            public Scanner scanner;

            protected boolean isIncluded(Map.Entry<Key, Value> src, GraphMetadataEntry graphMetadataEntry) {
                return true;
            }

            protected GraphMetadataEntry convert(Map.Entry<Key, Value> entry) {
                String key = entry.getKey().getRow().toString();
                return new GraphMetadataEntry(key, entry.getValue().get());
            }

            protected Iterator<Map.Entry<Key, Value>> createIterator() {
                try {
                    this.scanner = AccumuloGraph.this.createScanner(AccumuloGraph.this.getMetadataTableName(), range, METADATA_AUTHORIZATIONS);
                    GRAPH_LOGGER.logStartIterator((ScannerBase)this.scanner);
                    IteratorSetting versioningIteratorSettings = new IteratorSetting(90, VersioningIterator.class.getSimpleName(), VersioningIterator.class);
                    VersioningIterator.setMaxVersions((IteratorSetting)versioningIteratorSettings, (int)1);
                    this.scanner.addScanIterator(versioningIteratorSettings);
                    return this.scanner.iterator();
                }
                catch (TableNotFoundException ex) {
                    throw new VertexiumException("Could not create metadata scanner", (Throwable)ex);
                }
            }

            public void close() {
                super.close();
                this.scanner.close();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            }
        };
    }

    protected GraphMetadataStore getGraphMetadataStore() {
        return this.graphMetadataStore;
    }

    protected CloseableIterable<Vertex> getVerticesInRange(final Span trace, final org.apache.accumulo.core.data.Range range, final EnumSet<FetchHint> fetchHints, final Long endTime, final Authorizations authorizations) {
        final long timerStartTime = System.currentTimeMillis();
        return new LookAheadIterable<Map.Entry<Key, Value>, Vertex>(){
            public ScannerBase scanner;

            protected boolean isIncluded(Map.Entry<Key, Value> src, Vertex dest) {
                return dest != null;
            }

            protected Vertex convert(Map.Entry<Key, Value> next) {
                return AccumuloGraph.this.createVertexFromVertexIteratorValue(next.getKey(), next.getValue(), authorizations);
            }

            protected Iterator<Map.Entry<Key, Value>> createIterator() {
                try {
                    this.scanner = AccumuloGraph.this.createVertexScanner((EnumSet<FetchHint>)fetchHints, (Integer)1, null, endTime, range, authorizations);
                    return this.scanner.iterator();
                }
                catch (RuntimeException ex) {
                    if (ex.getCause() instanceof AccumuloSecurityException) {
                        throw new SecurityVertexiumException("Could not get vertices with authorizations: " + authorizations, authorizations, ex.getCause());
                    }
                    throw ex;
                }
            }

            public void close() {
                super.close();
                this.scanner.close();
                if (trace != null) {
                    trace.stop();
                }
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            }
        };
    }

    private Vertex createVertexFromVertexIteratorValue(Key key, Value value, Authorizations authorizations) {
        return AccumuloVertex.createFromIteratorValue(this, key, value, authorizations);
    }

    private Edge createEdgeFromEdgeIteratorValue(Key key, Value value, Authorizations authorizations) {
        return AccumuloEdge.createFromIteratorValue(this, key, value, authorizations);
    }

    public CloseableIterable<Vertex> getVertices(Iterable<String> ids, final EnumSet<FetchHint> fetchHints, final Long endTime, final Authorizations authorizations) {
        final ArrayList<org.apache.accumulo.core.data.Range> ranges = new ArrayList<org.apache.accumulo.core.data.Range>();
        int idCount = 0;
        for (String id : ids) {
            ranges.add(RangeUtils.createRangeFromString(id));
            ++idCount;
        }
        if (ranges.size() == 0) {
            return new EmptyClosableIterable();
        }
        final Span trace = Trace.start((String)"getVertices");
        trace.data("idCount", Integer.toString(idCount));
        this.traceDataFetchHints(trace, fetchHints);
        final long timerStartTime = System.currentTimeMillis();
        return new LookAheadIterable<Map.Entry<Key, Value>, Vertex>(){
            public ScannerBase scanner;

            protected boolean isIncluded(Map.Entry<Key, Value> src, Vertex dest) {
                return dest != null;
            }

            protected Vertex convert(Map.Entry<Key, Value> row) {
                return AccumuloGraph.this.createVertexFromVertexIteratorValue(row.getKey(), row.getValue(), authorizations);
            }

            protected Iterator<Map.Entry<Key, Value>> createIterator() {
                Long startTime = null;
                this.scanner = AccumuloGraph.this.createVertexScanner((EnumSet<FetchHint>)fetchHints, (Integer)1, startTime, endTime, ranges, authorizations);
                return this.scanner.iterator();
            }

            public void close() {
                super.close();
                this.scanner.close();
                trace.stop();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            }
        };
    }

    public CloseableIterable<Edge> getEdges(Iterable<String> ids, final EnumSet<FetchHint> fetchHints, final Long endTime, final Authorizations authorizations) {
        final ArrayList<org.apache.accumulo.core.data.Range> ranges = new ArrayList<org.apache.accumulo.core.data.Range>();
        int idCount = 0;
        for (String id : ids) {
            ranges.add(RangeUtils.createRangeFromString(id));
            ++idCount;
        }
        if (ranges.size() == 0) {
            return new EmptyClosableIterable();
        }
        final Span trace = Trace.start((String)"getEdges");
        trace.data("idCount", Integer.toString(idCount));
        this.traceDataFetchHints(trace, fetchHints);
        final long timerStartTime = System.currentTimeMillis();
        return new LookAheadIterable<Map.Entry<Key, Value>, Edge>(){
            public ScannerBase scanner;

            protected boolean isIncluded(Map.Entry<Key, Value> src, Edge dest) {
                return dest != null;
            }

            protected Edge convert(Map.Entry<Key, Value> row) {
                return AccumuloGraph.this.createEdgeFromEdgeIteratorValue(row.getKey(), row.getValue(), authorizations);
            }

            protected Iterator<Map.Entry<Key, Value>> createIterator() {
                Long startTime = null;
                this.scanner = AccumuloGraph.this.createEdgeScanner((EnumSet<FetchHint>)fetchHints, (Integer)1, startTime, endTime, ranges, authorizations);
                return this.scanner.iterator();
            }

            public void close() {
                super.close();
                this.scanner.close();
                trace.stop();
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            }
        };
    }

    public Iterable<Edge> getEdgesInRange(Range idRange, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        Span trace = Trace.start((String)"getEdgesInRange");
        trace.data("rangeInclusiveStart", idRange.getInclusiveStart());
        trace.data("rangeExclusiveStart", idRange.getExclusiveEnd());
        this.traceDataFetchHints(trace, fetchHints);
        org.apache.accumulo.core.data.Range range = this.vertexiumRangeToAccumuloRange(idRange);
        return this.getEdgesInRange(trace, range, fetchHints, endTime, authorizations);
    }

    private org.apache.accumulo.core.data.Range vertexiumRangeToAccumuloRange(Range range) {
        Key inclusiveStartRow = range.getInclusiveStart() == null ? null : new Key((CharSequence)range.getInclusiveStart());
        Key exclusiveEndRow = range.getExclusiveEnd() == null ? null : new Key((CharSequence)range.getExclusiveEnd());
        boolean startKeyInclusive = true;
        boolean endKeyInclusive = false;
        return new org.apache.accumulo.core.data.Range(inclusiveStartRow, startKeyInclusive, exclusiveEndRow, endKeyInclusive);
    }

    protected CloseableIterable<Edge> getEdgesInRange(Span trace, String startId, String endId, EnumSet<FetchHint> fetchHints, Long timestamp, Authorizations authorizations) throws VertexiumException {
        trace.data("startId", startId);
        trace.data("endId", endId);
        if (Trace.isTracing() && timestamp != null) {
            trace.data("timestamp", Long.toString(timestamp));
        }
        this.traceDataFetchHints(trace, fetchHints);
        Key startKey = startId == null ? null : new Key((CharSequence)startId);
        Key endKey = endId == null ? null : new Key((CharSequence)endId).followingKey(PartialKey.ROW);
        org.apache.accumulo.core.data.Range range = new org.apache.accumulo.core.data.Range(startKey, endKey);
        return this.getEdgesInRange(trace, range, fetchHints, timestamp, authorizations);
    }

    protected CloseableIterable<Edge> getEdgesInRange(final Span trace, final org.apache.accumulo.core.data.Range range, final EnumSet<FetchHint> fetchHints, final Long endTime, final Authorizations authorizations) throws VertexiumException {
        this.traceDataFetchHints(trace, fetchHints);
        final long timerStartTime = System.currentTimeMillis();
        return new LookAheadIterable<Map.Entry<Key, Value>, Edge>(){
            public ScannerBase scanner;

            protected boolean isIncluded(Map.Entry<Key, Value> src, Edge dest) {
                return dest != null;
            }

            protected Edge convert(Map.Entry<Key, Value> next) {
                return AccumuloGraph.this.createEdgeFromEdgeIteratorValue(next.getKey(), next.getValue(), authorizations);
            }

            protected Iterator<Map.Entry<Key, Value>> createIterator() {
                this.scanner = AccumuloGraph.this.createEdgeScanner((EnumSet<FetchHint>)fetchHints, (Integer)1, null, endTime, range, authorizations);
                return this.scanner.iterator();
            }

            public void close() {
                super.close();
                this.scanner.close();
                if (trace != null) {
                    trace.stop();
                }
                GRAPH_LOGGER.logEndIterator(System.currentTimeMillis() - timerStartTime);
            }
        };
    }

    public long getVertexCount(Authorizations authorizations) {
        String tableName = this.getTableNameFromElementType(ElementType.VERTEX);
        return this.getRowCountFromTable(tableName, AccumuloVertex.CF_SIGNAL, authorizations);
    }

    public long getEdgeCount(Authorizations authorizations) {
        String tableName = this.getTableNameFromElementType(ElementType.EDGE);
        return this.getRowCountFromTable(tableName, AccumuloEdge.CF_SIGNAL, authorizations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRowCountFromTable(String tableName, Text signalColumn, Authorizations authorizations) {
        long l;
        LOGGER.debug("BEGIN getRowCountFromTable(%s)", new Object[]{tableName});
        Scanner scanner = this.createScanner(tableName, null, authorizations);
        try {
            scanner.fetchColumnFamily(signalColumn);
            IteratorSetting countingIterator = new IteratorSetting(100, CountingIterator.class.getSimpleName(), CountingIterator.class);
            scanner.addScanIterator(countingIterator);
            GRAPH_LOGGER.logStartIterator((ScannerBase)scanner);
            long count = 0L;
            for (Map.Entry entry : scanner) {
                Long countForKey = (Long)LongCombiner.FIXED_LEN_ENCODER.decode(((Value)entry.getValue()).get());
                LOGGER.debug("getRowCountFromTable(%s): %s: %d", new Object[]{tableName, ((Key)entry.getKey()).getRow(), countForKey});
                count += countForKey.longValue();
            }
            LOGGER.debug("getRowCountFromTable(%s): TOTAL: %d", new Object[]{tableName, count});
            l = count;
        }
        catch (Throwable throwable) {
            try {
                scanner.close();
                throw throwable;
            }
            catch (TableNotFoundException ex) {
                throw new VertexiumException("Could not get count from table: " + tableName, (Throwable)ex);
            }
        }
        scanner.close();
        return l;
    }

    public void traceOn(String description) {
        this.traceOn(description, new HashMap<String, String>());
    }

    public void traceOn(String description, Map<String, String> data) {
        if (!this.distributedTraceEnabled) {
            try {
                ClientConfiguration conf = this.getConfiguration().getClientConfiguration();
                DistributedTrace.enable(null, (String)AccumuloGraph.class.getSimpleName(), (ClientConfiguration)conf);
                this.distributedTraceEnabled = true;
            }
            catch (Exception e) {
                throw new VertexiumException("Could not enable DistributedTrace", (Throwable)e);
            }
        }
        if (Trace.isTracing()) {
            throw new VertexiumException("Trace already running");
        }
        Span span = Trace.on((String)description);
        for (Map.Entry<String, String> dataEntry : data.entrySet()) {
            span.data(dataEntry.getKey(), dataEntry.getValue());
        }
        LOGGER.info("Started trace '%s'", new Object[]{description});
    }

    public void traceOff() {
        if (!Trace.isTracing()) {
            throw new VertexiumException("No trace currently running");
        }
        Trace.off();
    }

    private void traceDataFetchHints(Span trace, EnumSet<FetchHint> fetchHints) {
        if (Trace.isTracing()) {
            trace.data("fetchHints", FetchHint.toString(fetchHints));
        }
    }

    protected Class<?> getValueType(Object value) {
        if (value instanceof StreamingPropertyValueTableRef) {
            return ((StreamingPropertyValueTableRef)((Object)value)).getValueType();
        }
        return super.getValueType(value);
    }

    private class VertexiumMultiTableBatchWriter {
        private final MultiTableBatchWriter multiTableBatchWriter;

        public VertexiumMultiTableBatchWriter(MultiTableBatchWriter multiTableBatchWriter) {
            this.multiTableBatchWriter = multiTableBatchWriter;
        }

        public BatchWriter getBatchWriter(String tableName) {
            try {
                return this.multiTableBatchWriter.getBatchWriter(tableName);
            }
            catch (AccumuloException | AccumuloSecurityException | TableNotFoundException ex) {
                throw new VertexiumException("Could not get batch writer for table: " + tableName, ex);
            }
        }

        public void flush() {
            try {
                this.multiTableBatchWriter.flush();
            }
            catch (MutationsRejectedException ex) {
                throw new VertexiumException("Could not flush writer", (Throwable)ex);
            }
        }

        public String toString() {
            return "VertexiumMultiTableBatchWriter{multiTableBatchWriter=" + this.multiTableBatchWriter + '}';
        }

        protected void finalize() throws Throwable {
            if (!this.multiTableBatchWriter.isClosed()) {
                this.multiTableBatchWriter.close();
            }
            super.finalize();
        }
    }

    private class AccumuloGraphMetadataStore
    extends GraphMetadataStore {
        private final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(AccumuloGraphMetadataStore.class);
        private final Pattern ZK_PATH_REPLACEMENT_PATTERN = Pattern.compile("[^a-zA-Z]+");
        private final CuratorFramework curatorFramework;
        private final String zkPath;
        private final TreeCache treeCache;
        private final Map<String, GraphMetadataEntry> entries = new HashMap<String, GraphMetadataEntry>();

        public AccumuloGraphMetadataStore(CuratorFramework curatorFramework, String zkPath) {
            this.zkPath = zkPath;
            this.curatorFramework = curatorFramework;
            this.treeCache = new TreeCache(curatorFramework, zkPath);
            this.treeCache.getListenable().addListener((client, event) -> {
                if (this.LOGGER.isTraceEnabled()) {
                    this.LOGGER.trace("treeCache event, clearing cache", new Object[0]);
                }
                Map<String, GraphMetadataEntry> map = this.entries;
                synchronized (map) {
                    this.entries.clear();
                }
            });
            try {
                this.treeCache.start();
            }
            catch (Exception e) {
                throw new VertexiumException("Could not start metadata sync", (Throwable)e);
            }
        }

        public void close() {
            this.treeCache.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterable<GraphMetadataEntry> getMetadata() {
            Map<String, GraphMetadataEntry> map = this.entries;
            synchronized (map) {
                if (this.LOGGER.isTraceEnabled()) {
                    this.LOGGER.trace("getMetadata", new Object[0]);
                }
                this.ensureMetadataLoaded();
                return IterableUtils.toList(this.entries.values());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureMetadataLoaded() {
            Map<String, GraphMetadataEntry> map = this.entries;
            synchronized (map) {
                if (this.entries.size() > 0) {
                    return;
                }
                if (this.LOGGER.isTraceEnabled()) {
                    this.LOGGER.trace("metadata is stale... loading", new Object[0]);
                }
                Iterable<GraphMetadataEntry> metadata = AccumuloGraph.this.getMetadataInRange(null);
                for (GraphMetadataEntry graphMetadataEntry : metadata) {
                    this.entries.put(graphMetadataEntry.getKey(), graphMetadataEntry);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMetadata(String key, Object value) {
            if (this.LOGGER.isTraceEnabled()) {
                this.LOGGER.trace("setMetadata: %s = %s", new Object[]{key, value});
            }
            try {
                Mutation m = new Mutation((CharSequence)key);
                byte[] valueBytes = JavaSerializableUtils.objectToBytes((Object)value);
                m.put(AccumuloElement.METADATA_COLUMN_FAMILY, AccumuloElement.METADATA_COLUMN_QUALIFIER, new Value(valueBytes));
                BatchWriter writer = AccumuloGraph.this.getMetadataWriter();
                writer.addMutation(m);
                writer.flush();
            }
            catch (MutationsRejectedException ex) {
                throw new VertexiumException("Could not add metadata " + key, (Throwable)ex);
            }
            Map<String, GraphMetadataEntry> map = this.entries;
            synchronized (map) {
                this.entries.clear();
                try {
                    this.signalMetadataChange(key);
                }
                catch (Exception e) {
                    this.LOGGER.error("Could not notify other nodes via ZooKeeper", (Throwable)e);
                }
            }
        }

        private void signalMetadataChange(String key) throws Exception {
            String path = this.zkPath + "/" + this.ZK_PATH_REPLACEMENT_PATTERN.matcher(key).replaceAll("_");
            this.LOGGER.debug("signaling change to metadata via path: %s", new Object[]{path});
            byte[] data = Longs.toByteArray((long)IncreasingTime.currentTimeMillis());
            ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(path, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getMetadata(String key) {
            Map<String, GraphMetadataEntry> map = this.entries;
            synchronized (map) {
                this.ensureMetadataLoaded();
                GraphMetadataEntry e = this.entries.get(key);
                if (e == null) {
                    return null;
                }
                return e.getValue();
            }
        }
    }

    private static abstract class AddEdgeToVertexRunnable {
        private AddEdgeToVertexRunnable() {
        }

        public abstract void run(AccumuloEdge var1);
    }
}

