/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.keys;

import org.apache.commons.lang.StringUtils;
import org.vertexium.Property;
import org.vertexium.accumulo.iterator.model.KeyBase;

public class DataTableRowKey
extends KeyBase {
    private static final int LEGACY_VALUE_SEPARATOR_COUNT = 3;
    private static final int PARTS_INDEX_ELEMENT_ROW_KEY = 0;
    private static final int PARTS_INDEX_PROPERTY_NAME = 1;
    private static final int PARTS_INDEX_PROPERTY_KEY = 2;
    private final String[] parts;

    public DataTableRowKey(String elementRowKey, Property property) {
        this(elementRowKey, property.getKey(), property.getName());
    }

    public DataTableRowKey(String elementRowKey, String propertyKey, String propertyName) {
        this.parts = new String[]{elementRowKey, propertyName, propertyKey};
    }

    public String getRowKey() {
        DataTableRowKey.assertNoValueSeparator((String)this.getElementRowKey());
        DataTableRowKey.assertNoValueSeparator((String)this.getPropertyName());
        DataTableRowKey.assertNoValueSeparator((String)this.getPropertyKey());
        return this.getElementRowKey() + '\u001f' + this.getPropertyName() + '\u001f' + this.getPropertyKey();
    }

    public String getElementRowKey() {
        return this.parts[0];
    }

    public String getPropertyName() {
        return this.parts[1];
    }

    public String getPropertyKey() {
        return this.parts[2];
    }

    public static boolean isLegacy(String dataRowKey) {
        return StringUtils.countMatches((String)dataRowKey, (String)"\u001f") == 3;
    }
}

