/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.tools;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.vertexium.Authorizations;
import org.vertexium.VertexiumException;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.ElementMutationBuilder;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class DeleteHistoricalLegacyStreamingPropertyValueData {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(DeleteHistoricalLegacyStreamingPropertyValueData.class);
    private final AccumuloGraph graph;

    public DeleteHistoricalLegacyStreamingPropertyValueData(AccumuloGraph graph) {
        this.graph = graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Options options, Authorizations authorizations) {
        try {
            org.apache.accumulo.core.security.Authorizations accumuloAuthorizations = this.graph.toAccumuloAuthorizations(authorizations);
            Scanner scanner = this.graph.getConnector().createScanner(this.graph.getDataTableName(), accumuloAuthorizations);
            BatchWriter writer = this.graph.getConnector().createBatchWriter(this.graph.getDataTableName(), this.graph.getConfiguration().createBatchWriterConfig());
            String lastRowIdPrefix = null;
            ArrayList<Key> rowsToDelete = new ArrayList<Key>();
            try {
                int rowCount = 0;
                for (Map.Entry row : scanner) {
                    String rowId;
                    String[] rowIdParts;
                    if (rowCount % 10000 == 0) {
                        writer.flush();
                        LOGGER.debug("looking at row: %s (row count: %d)", new Object[]{((Key)row.getKey()).getRow().toString(), rowCount});
                    }
                    ++rowCount;
                    if (!ElementMutationBuilder.EMPTY_TEXT.equals((Object)((Key)row.getKey()).getColumnFamily()) || !ElementMutationBuilder.EMPTY_TEXT.equals((Object)((Key)row.getKey()).getColumnQualifier()) || (rowIdParts = (rowId = ((Key)row.getKey()).getRow().toString()).split("\u001f")).length < 3) continue;
                    if (lastRowIdPrefix == null || !this.isSameProperty(lastRowIdPrefix, rowId)) {
                        this.deleteRows(writer, rowsToDelete, options);
                        rowsToDelete.clear();
                        lastRowIdPrefix = rowIdParts[0] + '\u001f' + rowIdParts[1] + '\u001f' + rowIdParts[2];
                    }
                    rowsToDelete.add((Key)row.getKey());
                }
                this.deleteRows(writer, rowsToDelete, options);
            }
            finally {
                writer.flush();
                scanner.close();
            }
        }
        catch (Exception ex) {
            throw new VertexiumException("Could not delete old SPV data", (Throwable)ex);
        }
    }

    private boolean isSameProperty(String lastRowIdPrefix, String rowId) {
        return rowId.startsWith(lastRowIdPrefix + '\u001f') || lastRowIdPrefix.equals(rowId);
    }

    private void deleteRows(BatchWriter writer, List<Key> rowsToDelete, Options options) throws MutationsRejectedException {
        rowsToDelete.sort(Comparator.comparingLong(Key::getTimestamp));
        int i = 0;
        for (Key key : rowsToDelete) {
            if (i < rowsToDelete.size() - options.getVersionsToKeep()) {
                LOGGER.debug("deleting row: %s", new Object[]{key.getRow().toString()});
                if (!options.isDryRun()) {
                    Mutation mutation = new Mutation(key.getRow());
                    mutation.putDelete(key.getColumnFamily(), key.getColumnQualifier(), key.getColumnVisibilityParsed(), key.getTimestamp());
                    writer.addMutation(mutation);
                }
            } else if (options.isDryRun()) {
                LOGGER.debug("skipping row: %s", new Object[]{key.getRow().toString()});
            }
            ++i;
        }
    }

    public static class Options {
        private int versionsToKeep = 1;
        private boolean dryRun = true;

        public int getVersionsToKeep() {
            return this.versionsToKeep;
        }

        public Options setVersionsToKeep(int versionsToKeep) {
            this.versionsToKeep = versionsToKeep;
            return this;
        }

        public boolean isDryRun() {
            return this.dryRun;
        }

        public Options setDryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }
    }
}

