/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.io.Text;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.AccumuloNameSubstitutionStrategy;
import org.vertexium.accumulo.LazyMutableProperty;
import org.vertexium.accumulo.LazyPropertyMetadata;
import org.vertexium.accumulo.iterator.model.EdgeInfo;
import org.vertexium.accumulo.iterator.model.Edges;
import org.vertexium.accumulo.iterator.model.EdgesWithCount;
import org.vertexium.accumulo.iterator.model.EdgesWithEdgeInfo;
import org.vertexium.accumulo.iterator.model.ElementData;
import org.vertexium.accumulo.iterator.util.DataOutputStreamUtils;
import org.vertexium.id.NameSubstitutionStrategy;

public class DataInputStreamUtils {
    public static Text decodeText(DataInputStream in) throws IOException {
        return org.vertexium.accumulo.iterator.util.DataInputStreamUtils.decodeText((DataInputStream)in);
    }

    public static String decodeString(DataInputStream in) throws IOException {
        return org.vertexium.accumulo.iterator.util.DataInputStreamUtils.decodeString((DataInputStream)in);
    }

    public static List<Text> decodeTextList(DataInputStream in) throws IOException {
        int count = in.readInt();
        if (count == -1) {
            return null;
        }
        ArrayList<Text> results = new ArrayList<Text>();
        for (int i = 0; i < count; ++i) {
            results.add(DataInputStreamUtils.decodeText(in));
        }
        return results;
    }

    public static Iterable<Property> decodeProperties(AccumuloGraph graph, DataInputStream in) throws IOException {
        int propId;
        ArrayList<Property> results = new ArrayList<Property>();
        while ((propId = in.read()) != 2) {
            if (propId != 1) {
                throw new IOException("Unexpected prop id: " + propId);
            }
            String propertyKey = graph.getNameSubstitutionStrategy().inflate(DataInputStreamUtils.decodeString(in));
            String propertyName = graph.getNameSubstitutionStrategy().inflate(DataInputStreamUtils.decodeString(in));
            Visibility propertyVisibility = new Visibility(DataInputStreamUtils.decodeText(in).toString());
            long propertyTimestamp = in.readLong();
            int propertyValueLength = in.readInt();
            byte[] propertyValue = new byte[propertyValueLength];
            int read = in.read(propertyValue);
            if (read != propertyValueLength) {
                throw new IOException("Unexpected data length expected " + propertyValueLength + " found " + read);
            }
            List<Text> propertyHiddenVisibilitiesTextList = DataInputStreamUtils.decodeTextList(in);
            HashSet propertyHiddenVisibilities = null;
            if (propertyHiddenVisibilitiesTextList != null) {
                propertyHiddenVisibilities = Sets.newHashSet((Iterable)Iterables.transform(propertyHiddenVisibilitiesTextList, (Function)new Function<Text, Visibility>(){

                    @Nullable
                    public Visibility apply(Text input) {
                        return new Visibility(input.toString());
                    }
                }));
            }
            LazyPropertyMetadata metadata = DataInputStreamUtils.decodePropertyMetadata(in, graph.getNameSubstitutionStrategy());
            results.add((Property)new LazyMutableProperty(graph, graph.getVertexiumSerializer(), propertyKey, propertyName, propertyValue, metadata, propertyHiddenVisibilities, propertyVisibility, propertyTimestamp));
        }
        return results;
    }

    private static LazyPropertyMetadata decodePropertyMetadata(DataInputStream in, AccumuloNameSubstitutionStrategy nameSubstitutionStrategy) throws IOException {
        LazyPropertyMetadata metadata = new LazyPropertyMetadata();
        int entryCount = in.readInt();
        for (int i = 0; i < entryCount; ++i) {
            String key = nameSubstitutionStrategy.deflate(DataInputStreamUtils.decodeString(in));
            Visibility visibility = new Visibility(DataInputStreamUtils.decodeString(in));
            int valueLength = in.readInt();
            byte[] value = new byte[valueLength];
            int read = in.read(value);
            if (read != valueLength) {
                throw new IOException("Unexpected data length expected " + valueLength + " found " + read);
            }
            metadata.add(key, visibility, value);
        }
        return metadata;
    }

    public static Edges decodeEdges(DataInputStream in, NameSubstitutionStrategy nameSubstitutionStrategy) throws IOException {
        byte edgeLabelMarker = in.readByte();
        if (edgeLabelMarker == 2) {
            return DataInputStreamUtils.decodeEdgesWithRefs(in, nameSubstitutionStrategy);
        }
        if (edgeLabelMarker == 1) {
            return DataInputStreamUtils.decodeEdgesLabelsOnly(in, nameSubstitutionStrategy);
        }
        throw new IOException("Unexpected edge label marker: " + edgeLabelMarker);
    }

    private static Edges decodeEdgesLabelsOnly(DataInputStream in, NameSubstitutionStrategy nameSubstitutionStrategy) throws IOException {
        EdgesWithCount edges = new EdgesWithCount();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String label = nameSubstitutionStrategy.inflate(DataInputStreamUtils.decodeString(in));
            int edgeByLabelCount = in.readInt();
            edges.add(label, edgeByLabelCount);
        }
        return edges;
    }

    private static Edges decodeEdgesWithRefs(DataInputStream in, NameSubstitutionStrategy nameSubstitutionStrategy) throws IOException {
        EdgesWithEdgeInfo edges = new EdgesWithEdgeInfo();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String label = new String(DataInputStreamUtils.decodeByteArray(in), DataOutputStreamUtils.CHARSET);
            int edgeByLabelCount = in.readInt();
            for (int edgeByLabelIndex = 0; edgeByLabelIndex < edgeByLabelCount; ++edgeByLabelIndex) {
                Text edgeId = DataInputStreamUtils.decodeText(in);
                long timestamp = in.readLong();
                String vertexId = DataInputStreamUtils.decodeString(in);
                EdgeInfo edgeInfo = new EdgeInfo(nameSubstitutionStrategy.inflate(label), vertexId, timestamp);
                edges.add(edgeId, edgeInfo);
            }
        }
        return edges;
    }

    public static byte[] decodeByteArray(DataInputStream in) throws IOException {
        return org.vertexium.accumulo.iterator.util.DataInputStreamUtils.decodeByteArray((DataInputStream)in);
    }

    public static void decodeHeader(DataInputStream in, byte expectedTypeId) throws IOException {
        byte[] header = new byte[ElementData.HEADER.length];
        int read = in.read(header);
        if (read != header.length) {
            throw new IOException("Unexpected header length. Expected " + ElementData.HEADER.length + " found " + read);
        }
        if (!Arrays.equals(header, ElementData.HEADER)) {
            throw new IOException("Unexpected header");
        }
        int typeId = in.read();
        if (typeId != expectedTypeId) {
            throw new IOException("Unexpected type id. Expected " + expectedTypeId + " found " + typeId);
        }
    }
}

