/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.locking.consistentkey;

import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.TimestampRid;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.WriteBufferUtil;
import com.thinkaurelius.titan.diskstorage.util.WriteByteBuffer;

public class ConsistentKeyLockerSerializer {
    public StaticBuffer toLockKey(StaticBuffer key, StaticBuffer column) {
        WriteByteBuffer b = new WriteByteBuffer(key.length() + column.length() + 4);
        b.putInt(key.length());
        WriteBufferUtil.put((WriteBuffer)b, key);
        WriteBufferUtil.put((WriteBuffer)b, column);
        return b.getStaticBuffer();
    }

    public StaticBuffer toLockCol(long ts, StaticBuffer rid) {
        WriteByteBuffer b = new WriteByteBuffer(rid.length() + 8);
        b.putLong(ts);
        WriteBufferUtil.put((WriteBuffer)b, rid);
        return b.getStaticBuffer();
    }

    public TimestampRid fromLockColumn(StaticBuffer lockKey) {
        ReadBuffer r = lockKey.asReadBuffer();
        int len = r.length();
        long tsNS = r.getLong();
        byte[] curRid = new byte[len -= 8];
        int i = 0;
        while (r.hasRemaining()) {
            curRid[i] = r.getByte();
            ++i;
        }
        StaticArrayBuffer rid = new StaticArrayBuffer(curRid);
        return new TimestampRid(tsNS, rid);
    }
}

