/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database;

import com.carrotsearch.hppc.LongArrayList;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.diskstorage.Backend;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import com.thinkaurelius.titan.diskstorage.indexing.IndexTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.KCVSCache;
import com.thinkaurelius.titan.diskstorage.log.Log;
import com.thinkaurelius.titan.diskstorage.log.Message;
import com.thinkaurelius.titan.diskstorage.log.ReadMarker;
import com.thinkaurelius.titan.diskstorage.log.kcvs.ExternalPersistor;
import com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLog;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.graphdb.blueprints.TitanBlueprintsGraph;
import com.thinkaurelius.titan.graphdb.blueprints.TitanFeatures;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.database.RelationQueryCache;
import com.thinkaurelius.titan.graphdb.database.cache.SchemaCache;
import com.thinkaurelius.titan.graphdb.database.idassigner.VertexIDAssigner;
import com.thinkaurelius.titan.graphdb.database.idhandling.IDHandler;
import com.thinkaurelius.titan.graphdb.database.log.LogTxStatus;
import com.thinkaurelius.titan.graphdb.database.log.TransactionLogHeader;
import com.thinkaurelius.titan.graphdb.database.management.ManagementLogger;
import com.thinkaurelius.titan.graphdb.database.management.ManagementSystem;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.idmanagement.IDInspector;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.InternalVertexLabel;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.transaction.StandardTransactionBuilder;
import com.thinkaurelius.titan.graphdb.transaction.TransactionConfiguration;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.MixedIndexType;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import com.thinkaurelius.titan.graphdb.types.system.BaseRelationType;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import com.thinkaurelius.titan.graphdb.util.ExceptionFactory;
import com.thinkaurelius.titan.util.system.IOUtils;
import com.thinkaurelius.titan.util.system.TXUtils;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Features;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTitanGraph
extends TitanBlueprintsGraph {
    private static final Logger log = LoggerFactory.getLogger(StandardTitanGraph.class);
    private final GraphDatabaseConfiguration config;
    private final Backend backend;
    private final IDManager idManager;
    private final VertexIDAssigner idAssigner;
    private final TimestampProvider times;
    protected final IndexSerializer indexSerializer;
    protected final EdgeSerializer edgeSerializer;
    protected final Serializer serializer;
    public final SliceQuery vertexExistenceQuery;
    private final RelationQueryCache queryCache;
    private final SchemaCache schemaCache;
    private final ManagementLogger mgmtLogger;
    private volatile ShutdownThread shutdownHook;
    private volatile boolean isOpen = true;
    private AtomicLong txCounter;
    private Set<StandardTitanTx> openTransactions;
    private final SchemaCache.StoreRetrieval typeCacheRetrieval = new SchemaCache.StoreRetrieval(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long retrieveSchemaByName(String typeName) {
            Long l;
            Configuration customTxOptions = StandardTitanGraph.this.backend.getStoreFeatures().getKeyConsistentTxConfig();
            StandardTitanTx consistentTx = null;
            try {
                consistentTx = StandardTitanGraph.this.newTransaction(new StandardTransactionBuilder(StandardTitanGraph.this.getConfiguration(), StandardTitanGraph.this, customTxOptions).setGroupName("com.thinkaurelius.titan.sys.schema"));
                consistentTx.getTxHandle().disableCache();
                TitanVertex v = (TitanVertex)Iterables.getOnlyElement(consistentTx.getVertices(BaseKey.SchemaName, (Object)typeName), null);
                l = v != null ? Long.valueOf(v.getLongId()) : null;
            }
            catch (Throwable throwable) {
                TXUtils.rollbackQuietly(consistentTx);
                throw throwable;
            }
            TXUtils.rollbackQuietly(consistentTx);
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public EntryList retrieveSchemaRelations(long schemaId, BaseRelationType type, Direction dir) {
            EntryList entryList;
            SliceQuery query = StandardTitanGraph.this.queryCache.getQuery(type, dir);
            Configuration customTxOptions = StandardTitanGraph.this.backend.getStoreFeatures().getKeyConsistentTxConfig();
            StandardTitanTx consistentTx = null;
            try {
                EntryList result;
                consistentTx = StandardTitanGraph.this.newTransaction(new StandardTransactionBuilder(StandardTitanGraph.this.getConfiguration(), StandardTitanGraph.this, customTxOptions).setGroupName("com.thinkaurelius.titan.sys.schema"));
                consistentTx.getTxHandle().disableCache();
                entryList = result = StandardTitanGraph.this.edgeQuery(schemaId, query, consistentTx.getTxHandle());
            }
            catch (Throwable throwable) {
                TXUtils.rollbackQuietly(consistentTx);
                throw throwable;
            }
            TXUtils.rollbackQuietly(consistentTx);
            return entryList;
        }
    };
    private static final Predicate<InternalRelation> SCHEMA_FILTER = new Predicate<InternalRelation>(){

        public boolean apply(@Nullable InternalRelation internalRelation) {
            return internalRelation.getType() instanceof BaseRelationType && internalRelation.getVertex(0) instanceof TitanSchemaVertex;
        }
    };
    private static final Predicate<InternalRelation> NO_SCHEMA_FILTER = new Predicate<InternalRelation>(){

        public boolean apply(@Nullable InternalRelation internalRelation) {
            return !SCHEMA_FILTER.apply((Object)internalRelation);
        }
    };
    private static final Predicate<InternalRelation> NO_FILTER = Predicates.alwaysTrue();

    public StandardTitanGraph(GraphDatabaseConfiguration configuration) {
        this.config = configuration;
        this.backend = configuration.getBackend();
        this.idAssigner = this.config.getIDAssigner(this.backend);
        this.idManager = this.idAssigner.getIDManager();
        this.serializer = this.config.getSerializer();
        StoreFeatures storeFeatures = this.backend.getStoreFeatures();
        this.indexSerializer = new IndexSerializer(configuration.getConfiguration(), this.serializer, this.backend.getIndexInformation(), storeFeatures.isDistributed() && storeFeatures.isKeyOrdered());
        this.edgeSerializer = new EdgeSerializer(this.serializer);
        this.vertexExistenceQuery = this.edgeSerializer.getQuery(BaseKey.VertexExists, Direction.OUT, new EdgeSerializer.TypedInterval[0]).setLimit(1);
        this.queryCache = new RelationQueryCache(this.edgeSerializer);
        this.schemaCache = configuration.getTypeCache(this.typeCacheRetrieval);
        this.times = configuration.getTimestampProvider();
        this.isOpen = true;
        this.txCounter = new AtomicLong(0L);
        this.openTransactions = Collections.newSetFromMap(new ConcurrentHashMap(100, 0.75f, 1));
        String uniqueInstanceId = configuration.getUniqueGraphId();
        ModifiableConfiguration globalConfig = GraphDatabaseConfiguration.getGlobalSystemConfig(this.backend);
        if (globalConfig.has(GraphDatabaseConfiguration.REGISTRATION_TIME, uniqueInstanceId)) {
            throw new TitanException(String.format("A Titan graph with the same instance id [%s] is already open. Might required forced shutdown.", uniqueInstanceId));
        }
        globalConfig.set(GraphDatabaseConfiguration.REGISTRATION_TIME, this.times.getTime(), uniqueInstanceId);
        Log mgmtLog = this.backend.getSystemMgmtLog();
        this.mgmtLogger = new ManagementLogger(this, mgmtLog, this.schemaCache, this.times);
        mgmtLog.registerReader(ReadMarker.fromNow(), this.mgmtLogger);
        this.shutdownHook = new ShutdownThread(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() throws TitanException {
        try {
            this.shutdownInternal();
        }
        finally {
            this.removeHook();
        }
    }

    private synchronized void shutdownInternal() throws TitanException {
        if (!this.isOpen) {
            return;
        }
        try {
            ModifiableConfiguration globalConfig = GraphDatabaseConfiguration.getGlobalSystemConfig(this.backend);
            globalConfig.remove(GraphDatabaseConfiguration.REGISTRATION_TIME, this.config.getUniqueGraphId());
            super.shutdown();
            IOUtils.closeQuietly(this.serializer);
            this.idAssigner.close();
            this.backend.close();
            this.queryCache.close();
        }
        catch (BackendException e) {
            throw new TitanException("Could not close storage backend", e);
        }
        finally {
            this.isOpen = false;
        }
    }

    private synchronized void removeHook() {
        if (null == this.shutdownHook) {
            return;
        }
        ShutdownThread tmp = this.shutdownHook;
        this.shutdownHook = null;
        try {
            Runtime.getRuntime().removeShutdownHook(tmp);
        }
        catch (IllegalStateException e) {
            log.warn("Failed to remove shutdown hook", (Throwable)e);
        }
    }

    public Features getFeatures() {
        return TitanFeatures.getFeatures(this.getConfiguration(), this.backend.getStoreFeatures());
    }

    public IndexSerializer getIndexSerializer() {
        return this.indexSerializer;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public IDInspector getIDInspector() {
        return this.idManager.getIdInspector();
    }

    public IDManager getIDManager() {
        return this.idManager;
    }

    public EdgeSerializer getEdgeSerializer() {
        return this.edgeSerializer;
    }

    public Serializer getDataSerializer() {
        return this.serializer;
    }

    public SchemaCache getSchemaCache() {
        return this.schemaCache;
    }

    public GraphDatabaseConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public TitanManagement getManagementSystem() {
        return new ManagementSystem(this, this.backend.getGlobalSystemConfig(), this.backend.getSystemMgmtLog(), this.mgmtLogger, this.schemaCache);
    }

    public Set<? extends TitanTransaction> getOpenTransactions() {
        return Sets.newHashSet(this.openTransactions);
    }

    @Override
    public TitanTransaction newTransaction() {
        return this.buildTransaction().start();
    }

    @Override
    public StandardTransactionBuilder buildTransaction() {
        return new StandardTransactionBuilder(this.getConfiguration(), this);
    }

    @Override
    public TitanTransaction newThreadBoundTransaction() {
        return this.buildTransaction().threadBound().start();
    }

    public StandardTitanTx newTransaction(TransactionConfiguration configuration) {
        if (!this.isOpen) {
            ExceptionFactory.graphShutdown();
        }
        try {
            StandardTitanTx tx = new StandardTitanTx(this, configuration);
            tx.setBackendTransaction(this.openBackendTransaction(tx));
            this.openTransactions.add(tx);
            return tx;
        }
        catch (BackendException e) {
            throw new TitanException("Could not start new transaction", e);
        }
    }

    private BackendTransaction openBackendTransaction(StandardTitanTx tx) throws BackendException {
        IndexSerializer.IndexInfoRetriever retriever = this.indexSerializer.getIndexInfoRetriever(tx);
        return this.backend.beginTransaction(tx.getConfiguration(), retriever);
    }

    public void closeTransaction(StandardTitanTx tx) {
        this.openTransactions.remove(tx);
    }

    public RecordIterator<Long> getVertexIDs(BackendTransaction tx) {
        Preconditions.checkArgument((this.backend.getStoreFeatures().hasOrderedScan() || this.backend.getStoreFeatures().hasUnorderedScan() ? 1 : 0) != 0, (Object)"The configured storage backend does not support global graph operations - use Faunus instead");
        final KeyIterator keyiter = this.backend.getStoreFeatures().hasUnorderedScan() ? tx.edgeStoreKeys(this.vertexExistenceQuery) : tx.edgeStoreKeys(new KeyRangeQuery(IDHandler.MIN_KEY, IDHandler.MAX_KEY, this.vertexExistenceQuery));
        return new RecordIterator<Long>(){

            @Override
            public boolean hasNext() {
                return keyiter.hasNext();
            }

            @Override
            public Long next() {
                return StandardTitanGraph.this.idManager.getKeyID((StaticBuffer)keyiter.next());
            }

            @Override
            public void close() throws IOException {
                keyiter.close();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal not supported");
            }
        };
    }

    public EntryList edgeQuery(long vid, SliceQuery query, BackendTransaction tx) {
        Preconditions.checkArgument((vid > 0L ? 1 : 0) != 0);
        return tx.edgeStoreQuery(new KeySliceQuery(this.idManager.getKey(vid), query));
    }

    public List<EntryList> edgeMultiQuery(LongArrayList vids, SliceQuery query, BackendTransaction tx) {
        Preconditions.checkArgument((vids != null && !vids.isEmpty() ? 1 : 0) != 0);
        ArrayList<StaticBuffer> vertexIds = new ArrayList<StaticBuffer>(vids.size());
        for (int i = 0; i < vids.size(); ++i) {
            Preconditions.checkArgument((vids.get(i) > 0L ? 1 : 0) != 0);
            vertexIds.add(this.idManager.getKey(vids.get(i)));
        }
        Map<StaticBuffer, EntryList> result = tx.edgeStoreMultiQuery(vertexIds, query);
        ArrayList<EntryList> resultList = new ArrayList<EntryList>(result.size());
        for (StaticBuffer v : vertexIds) {
            resultList.add(result.get(v));
        }
        return resultList;
    }

    public void assignID(InternalRelation relation) {
        this.idAssigner.assignID(relation);
    }

    public void assignID(InternalVertex vertex, VertexLabel label) {
        this.idAssigner.assignID(vertex, label);
    }

    public static boolean acquireLock(InternalRelation relation, int pos, boolean acquireLocksConfig) {
        InternalRelationType type = (InternalRelationType)relation.getType();
        return acquireLocksConfig && type.getConsistencyModifier() == ConsistencyModifier.LOCK && (type.getMultiplicity().isUnique(EdgeDirection.fromPosition(pos)) || pos == 0 && type.getMultiplicity() == Multiplicity.SIMPLE);
    }

    public static boolean acquireLock(CompositeIndexType index, boolean acquireLocksConfig) {
        return acquireLocksConfig && index.getConsistencyModifier() == ConsistencyModifier.LOCK && index.getCardinality() != Cardinality.LIST;
    }

    public static int getTTL(InternalRelation rel) {
        assert (rel.isNew());
        InternalRelationType baseType = (InternalRelationType)rel.getType();
        assert (baseType.getBaseType() == null);
        int ttl = 0;
        Integer ettl = baseType.getTTL();
        if (ettl > 0) {
            ttl = ettl;
        }
        for (int i = 0; i < rel.getArity(); ++i) {
            int vttl = StandardTitanGraph.getTTL(rel.getVertex(i));
            if (vttl <= 0 || vttl >= ttl && ttl > 0) continue;
            ttl = vttl;
        }
        return ttl;
    }

    public static int getTTL(InternalVertex v) {
        assert (v.hasId());
        if (IDManager.VertexIDType.UnmodifiableVertex.is(v.getLongId())) {
            assert (v.isNew()) : "Should not be able to add relations to existing static vertices: " + v;
            return ((InternalVertexLabel)v.getVertexLabel()).getTTL();
        }
        return 0;
    }

    public ModificationSummary prepareCommit(Collection<InternalRelation> addedRelations, Collection<InternalRelation> deletedRelations, Predicate<InternalRelation> filter, BackendTransaction mutator, StandardTitanTx tx, boolean acquireLocks) throws BackendException {
        Entry entry;
        InternalVertex vertex;
        int pos;
        ArrayListMultimap mutations = ArrayListMultimap.create();
        ArrayListMultimap mutatedProperties = ArrayListMultimap.create();
        ArrayList indexUpdates = Lists.newArrayList();
        for (InternalRelation del : Iterables.filter(deletedRelations, filter)) {
            Preconditions.checkArgument((boolean)del.isRemoved());
            for (pos = 0; pos < del.getLen(); ++pos) {
                vertex = del.getVertex(pos);
                if (pos == 0 || !del.isLoop()) {
                    if (del.isProperty()) {
                        mutatedProperties.put((Object)vertex, (Object)del);
                    }
                    mutations.put((Object)vertex.getLongId(), (Object)del);
                }
                if (!StandardTitanGraph.acquireLock(del, pos, acquireLocks)) continue;
                entry = this.edgeSerializer.writeRelation(del, pos, tx);
                mutator.acquireEdgeLock(this.idManager.getKey(vertex.getLongId()), entry);
            }
            indexUpdates.addAll(this.indexSerializer.getIndexUpdates(del));
        }
        for (InternalRelation add : Iterables.filter(addedRelations, filter)) {
            Preconditions.checkArgument((boolean)add.isNew());
            for (pos = 0; pos < add.getLen(); ++pos) {
                vertex = add.getVertex(pos);
                if (pos == 0 || !add.isLoop()) {
                    if (add.isProperty()) {
                        mutatedProperties.put((Object)vertex, (Object)add);
                    }
                    mutations.put((Object)vertex.getLongId(), (Object)add);
                }
                if (vertex.isNew() || !StandardTitanGraph.acquireLock(add, pos, acquireLocks)) continue;
                entry = this.edgeSerializer.writeRelation(add, pos, tx);
                mutator.acquireEdgeLock(this.idManager.getKey(vertex.getLongId()), entry.getColumn());
            }
            indexUpdates.addAll(this.indexSerializer.getIndexUpdates(add));
        }
        for (InternalVertex v : mutatedProperties.keySet()) {
            indexUpdates.addAll(this.indexSerializer.getIndexUpdates(v, mutatedProperties.get((Object)v)));
        }
        for (IndexSerializer.IndexUpdate update : indexUpdates) {
            CompositeIndexType iIndex;
            if (!update.isCompositeIndex() || !update.isDeletion() || !StandardTitanGraph.acquireLock(iIndex = (CompositeIndexType)update.getIndex(), acquireLocks)) continue;
            mutator.acquireIndexLock((StaticBuffer)update.getKey(), (Entry)update.getEntry());
        }
        for (IndexSerializer.IndexUpdate update : indexUpdates) {
            CompositeIndexType iIndex;
            if (!update.isCompositeIndex() || !update.isAddition() || !StandardTitanGraph.acquireLock(iIndex = (CompositeIndexType)update.getIndex(), acquireLocks)) continue;
            mutator.acquireIndexLock((StaticBuffer)update.getKey(), ((Entry)update.getEntry()).getColumn());
        }
        for (Long vertexid : mutations.keySet()) {
            Preconditions.checkArgument((vertexid > 0L ? 1 : 0) != 0, (String)"Vertex has no id: %s", (Object[])new Object[]{vertexid});
            List edges = mutations.get((Object)vertexid);
            ArrayList<Entry> additions = new ArrayList<Entry>(edges.size());
            ArrayList<Entry> deletions = new ArrayList<Entry>(Math.max(10, edges.size() / 10));
            for (InternalRelation edge : edges) {
                InternalRelationType baseType = (InternalRelationType)edge.getType();
                assert (baseType.getBaseType() == null);
                for (InternalRelationType type : baseType.getRelationIndexes()) {
                    if (type.getStatus() == SchemaStatus.DISABLED) continue;
                    for (int pos2 = 0; pos2 < edge.getArity(); ++pos2) {
                        if (!type.isUnidirected(Direction.BOTH) && !type.isUnidirected(EdgeDirection.fromPosition(pos2)) || edge.getVertex(pos2).getLongId() != vertexid.longValue()) continue;
                        StaticArrayEntry entry2 = this.edgeSerializer.writeRelation(edge, type, pos2, tx);
                        if (edge.isRemoved()) {
                            deletions.add(entry2);
                            continue;
                        }
                        Preconditions.checkArgument((boolean)edge.isNew());
                        int ttl = StandardTitanGraph.getTTL(edge);
                        if (ttl > 0) {
                            entry2.setMetaData(EntryMetaData.TTL, ttl);
                        }
                        additions.add(entry2);
                    }
                }
            }
            StaticBuffer vertexKey = this.idManager.getKey(vertexid);
            mutator.mutateEdges(vertexKey, additions, deletions);
        }
        boolean has2iMods = false;
        for (IndexSerializer.IndexUpdate indexUpdate : indexUpdates) {
            IndexSerializer.IndexUpdate update;
            assert (indexUpdate.isAddition() || indexUpdate.isDeletion());
            if (indexUpdate.isCompositeIndex()) {
                update = indexUpdate;
                if (update.isAddition()) {
                    mutator.mutateIndex((StaticBuffer)update.getKey(), Lists.newArrayList((Object[])new Entry[]{(Entry)update.getEntry()}), KCVSCache.NO_DELETIONS);
                    continue;
                }
                mutator.mutateIndex((StaticBuffer)update.getKey(), KeyColumnValueStore.NO_ADDITIONS, Lists.newArrayList((Object[])new Entry[]{(Entry)update.getEntry()}));
                continue;
            }
            update = indexUpdate;
            has2iMods = true;
            IndexTransaction itx = mutator.getIndexTransaction(update.getIndex().getBackingIndexName());
            String indexStore = ((MixedIndexType)update.getIndex()).getStoreName();
            if (update.isAddition()) {
                itx.add(indexStore, (String)update.getKey(), (IndexEntry)update.getEntry(), update.getElement().isNew());
                continue;
            }
            itx.delete(indexStore, (String)update.getKey(), ((IndexEntry)update.getEntry()).field, ((IndexEntry)update.getEntry()).value, update.getElement().isRemoved());
        }
        return new ModificationSummary(!mutations.isEmpty(), has2iMods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Collection<InternalRelation> addedRelations, Collection<InternalRelation> deletedRelations, StandardTitanTx tx) {
        block35: {
            if (addedRelations.isEmpty() && deletedRelations.isEmpty()) {
                return;
            }
            log.debug("Saving transaction. Added {}, removed {}", (Object)addedRelations.size(), (Object)deletedRelations.size());
            if (!tx.getConfiguration().hasCommitTime()) {
                tx.getConfiguration().setCommitTime(this.times.getTime());
            }
            Timepoint txTimestamp = tx.getConfiguration().getCommitTime();
            long transactionId = this.txCounter.incrementAndGet();
            if (!tx.getConfiguration().hasAssignIDsImmediately()) {
                this.idAssigner.assignIDs(addedRelations);
            }
            BackendTransaction mutator = tx.getTxHandle();
            boolean acquireLocks = tx.getConfiguration().hasAcquireLocks();
            boolean hasTxIsolation = this.backend.getStoreFeatures().hasTxIsolation();
            boolean logTransaction = this.config.hasLogTransactions() && !tx.getConfiguration().hasEnabledBatchLoading();
            KCVSLog txLog = logTransaction ? this.backend.getSystemTxLog() : null;
            TransactionLogHeader txLogHeader = new TransactionLogHeader(transactionId, txTimestamp);
            try {
                ModificationSummary commitSummary;
                if (logTransaction) {
                    txLog.add(txLogHeader.serializeModifications(this.serializer, LogTxStatus.PRECOMMIT, tx, addedRelations, deletedRelations), txLogHeader.getLogKey());
                }
                boolean hasSchemaElements = !Iterables.isEmpty((Iterable)Iterables.filter(deletedRelations, SCHEMA_FILTER)) || !Iterables.isEmpty((Iterable)Iterables.filter(addedRelations, SCHEMA_FILTER));
                Preconditions.checkArgument((!hasSchemaElements || !tx.getConfiguration().hasEnabledBatchLoading() && acquireLocks ? 1 : 0) != 0, (Object)"Attempting to create schema elements in inconsistent state");
                if (hasSchemaElements && !hasTxIsolation) {
                    BackendTransaction schemaMutator = this.openBackendTransaction(tx);
                    try {
                        commitSummary = this.prepareCommit(addedRelations, deletedRelations, SCHEMA_FILTER, schemaMutator, tx, acquireLocks);
                        assert (commitSummary.hasModifications && !commitSummary.has2iModifications);
                    }
                    catch (Throwable e) {
                        schemaMutator.rollback();
                        throw e;
                    }
                    try {
                        schemaMutator.commit();
                    }
                    catch (Throwable e) {
                        log.error("Could not commit transaction [" + transactionId + "] due to storage exception in system-commit", e);
                        throw e;
                    }
                }
                commitSummary = this.prepareCommit(addedRelations, deletedRelations, hasTxIsolation ? NO_FILTER : NO_SCHEMA_FILTER, mutator, tx, acquireLocks);
                if (commitSummary.hasModifications) {
                    boolean hasSecondaryPersistence;
                    String logTxIdentifier = tx.getConfiguration().getLogIdentifier();
                    boolean bl = hasSecondaryPersistence = logTxIdentifier != null || commitSummary.has2iModifications;
                    if (logTransaction) {
                        txLog.add(txLogHeader.serializePrimary(this.serializer, hasSecondaryPersistence ? LogTxStatus.PRIMARY_SUCCESS : LogTxStatus.COMPLETE_SUCCESS), txLogHeader.getLogKey(), (ExternalPersistor)mutator.getTxLogPersistor());
                    }
                    try {
                        mutator.commitStorage();
                    }
                    catch (Throwable e) {
                        log.error("Could not commit transaction [" + transactionId + "] due to storage exception in commit", e);
                        throw e;
                    }
                    if (hasSecondaryPersistence) {
                        LogTxStatus status = LogTxStatus.SECONDARY_SUCCESS;
                        Object indexFailures = ImmutableMap.of();
                        boolean userlogSuccess = true;
                        try {
                            indexFailures = mutator.commitIndexes();
                            if (!indexFailures.isEmpty()) {
                                status = LogTxStatus.SECONDARY_FAILURE;
                                for (Map.Entry entry : indexFailures.entrySet()) {
                                    log.error("Error while commiting index mutations for transaction [" + transactionId + "] on index: " + (String)entry.getKey(), (Throwable)entry.getValue());
                                }
                            }
                            if (logTxIdentifier == null) break block35;
                            try {
                                userlogSuccess = false;
                                Log userLog = this.backend.getUserLog(logTxIdentifier);
                                Future<Message> env = userLog.add(txLogHeader.serializeModifications(this.serializer, LogTxStatus.USER_LOG, tx, addedRelations, deletedRelations));
                                if (env.isDone()) {
                                    try {
                                        env.get();
                                    }
                                    catch (ExecutionException ex) {
                                        throw ex.getCause();
                                    }
                                }
                                userlogSuccess = true;
                            }
                            catch (Throwable e) {
                                status = LogTxStatus.SECONDARY_FAILURE;
                                log.error("Could not user-log committed transaction [" + transactionId + "] to " + logTxIdentifier, e);
                            }
                            break block35;
                        }
                        finally {
                            if (logTransaction) {
                                try {
                                    txLog.add(txLogHeader.serializeSecondary(this.serializer, status, (Map<String, Throwable>)indexFailures, userlogSuccess), txLogHeader.getLogKey());
                                }
                                catch (Throwable e) {
                                    log.error("Could not tx-log secondary persistence status on transaction [" + transactionId + "]", e);
                                }
                            }
                        }
                    }
                    mutator.commitIndexes();
                    break block35;
                }
                mutator.commit();
            }
            catch (Throwable e) {
                log.error("Could not commit transaction [" + transactionId + "] due to exception", e);
                try {
                    mutator.rollback();
                }
                catch (Throwable e2) {
                    log.error("Could not roll-back transaction [" + transactionId + "] after failure due to exception", e2);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new TitanException("Unexpected exception", e);
            }
        }
    }

    private static class ShutdownThread
    extends Thread {
        private final StandardTitanGraph graph;

        public ShutdownThread(StandardTitanGraph graph) {
            this.graph = graph;
        }

        @Override
        public void start() {
            if (this.graph.isOpen && log.isDebugEnabled()) {
                log.debug("Shutting down graph {} using built-in shutdown hook.", (Object)this.graph);
            }
            this.graph.shutdownInternal();
        }
    }

    private static class ModificationSummary {
        final boolean hasModifications;
        final boolean has2iModifications;

        private ModificationSummary(boolean hasModifications, boolean has2iModifications) {
            this.hasModifications = hasModifications;
            this.has2iModifications = has2iModifications;
        }
    }
}

