/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.thrift;

import com.thinkaurelius.thrift.AbstractDisruptorTest;
import com.thinkaurelius.thrift.test.OperationType;
import com.thinkaurelius.thrift.test.TestService;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.thrift.transport.TTransport;
import org.junit.Test;

public abstract class AbstractMultiConnectionTest
extends AbstractDisruptorTest {
    private static final int CONNECTIONS = 250;

    @Test
    public void multipleConnectionsTest() throws Exception {
        int i;
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<TTransport> transports = new ArrayList<TTransport>();
        final AtomicInteger ids = new AtomicInteger(1);
        final CountDownLatch latch = new CountDownLatch(250);
        for (i = 0; i < 250; ++i) {
            final TTransport transport = this.getNewTransport();
            transports.add(transport);
            service.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    int id = ids.incrementAndGet();
                    TestService.Client client = AbstractMultiConnectionTest.this.getNewClient(transport);
                    AbstractMultiConnectionTest.this.invokeRequests(client, id, AbstractDisruptorTest.getRandomArgument(), AbstractDisruptorTest.getRandomArgument());
                    client.ping();
                    latch.countDown();
                    return null;
                }
            });
        }
        latch.await();
        service.shutdown();
        for (i = 0; i < 250; ++i) {
            ((TTransport)transports.get(i)).close();
        }
    }

    @Test
    public void producerConsumerTest() throws Exception {
        CountDownLatch latch = new CountDownLatch(250);
        final SynchronousQueue<AbstractDisruptorTest.Work> queue = new SynchronousQueue<AbstractDisruptorTest.Work>();
        final ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        new Thread(){

            @Override
            public void run() {
                int count = 0;
                while (count < 250) {
                    AbstractDisruptorTest.Work newWork = (AbstractDisruptorTest.Work)queue.poll();
                    if (newWork == null) continue;
                    service.submit(newWork);
                    ++count;
                }
            }
        }.start();
        for (int i = 0; i < 250; ++i) {
            queue.put(new AbstractDisruptorTest.Work(latch, i, AbstractMultiConnectionTest.getRandomArgument(), AbstractMultiConnectionTest.getRandomArgument(), OperationType.ADD));
        }
        latch.await();
        service.shutdown();
    }
}

