/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.cli;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ClientOpts
extends Help {
    @Parameter(names={"-u", "--user"}, description="Connection user")
    private String principal = null;
    @Parameter(names={"-p"}, converter=PasswordConverter.class, description="Connection password")
    private Password password = null;
    @Parameter(names={"--password"}, converter=PasswordConverter.class, description="Enter the connection password", password=true)
    private Password securePassword = null;
    @Parameter(names={"-tc", "--tokenClass"}, description="Token class")
    private String tokenClassName = null;
    @DynamicParameter(names={"-l"}, description="login properties in the format key=value. Reuse -l for each property (prompt for properties if this option is missing")
    public Map<String, String> loginProps = new LinkedHashMap<String, String>();
    @Parameter(names={"-z", "--keepers"}, description="Comma separated list of zookeeper hosts (host:port,host:port)")
    public String zookeepers = "localhost:2181";
    @Parameter(names={"-i", "--instance"}, description="The name of the accumulo instance")
    public String instance = null;
    @Parameter(names={"-auths", "--auths"}, converter=AuthConverter.class, description="the authorizations to use when reading or writing")
    public Authorizations auths = Authorizations.EMPTY;
    @Parameter(names={"--debug"}, description="turn on TRACE-level log messages")
    public boolean debug = false;
    @Parameter(names={"-fake", "--mock"}, description="Use a mock Instance")
    public boolean mock = false;
    @Parameter(names={"--site-file"}, description="Read the given accumulo site file to find the accumulo instance")
    public String siteFile = null;
    @Parameter(names={"--ssl"}, description="Connect to accumulo over SSL")
    public boolean sslEnabled = false;
    @Parameter(names={"--sasl"}, description="Connecto to Accumulo using SASL (supports Kerberos)")
    public boolean saslEnabled = false;
    @Parameter(names={"--config-file"}, description="Read the given client config file. If omitted, the path searched can be specified with $ACCUMULO_CLIENT_CONF_PATH, which defaults to ~/.accumulo/config:$ACCUMULO_CONF_DIR/client.conf:/etc/accumulo/client.conf")
    public String clientConfigFile = null;
    @Parameter(names={"--trace"}, description="turn on distributed tracing")
    public boolean trace = false;
    @Parameter(names={"--keytab"}, description="Kerberos keytab on the local filesystem")
    public String keytabPath = null;
    protected Instance cachedInstance = null;
    protected ClientConfiguration cachedClientConfig = null;

    public AuthenticationToken getToken() {
        if (null != this.tokenClassName) {
            AuthenticationToken.Properties props = new AuthenticationToken.Properties();
            if (!this.loginProps.isEmpty()) {
                for (Map.Entry<String, String> loginOption : this.loginProps.entrySet()) {
                    props.put(loginOption.getKey(), loginOption.getValue());
                }
            }
            try {
                AuthenticationToken token = Class.forName(this.tokenClassName).asSubclass(AuthenticationToken.class).newInstance();
                token.init(props);
                return token;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.securePassword != null) {
            return new PasswordToken(this.securePassword.value);
        }
        if (this.password != null) {
            return new PasswordToken(this.password.value);
        }
        return null;
    }

    public void startDebugLogging() {
        if (this.debug) {
            Logger.getLogger((String)"org.apache.accumulo.core").setLevel(Level.TRACE);
        }
    }

    public void startTracing(String applicationName) {
        if (this.trace) {
            Trace.on(applicationName);
        }
    }

    public void stopTracing() {
        Trace.off();
    }

    public void updateKerberosCredentials() {
        ClientConfiguration clientConfig;
        try {
            clientConfig = this.clientConfigFile == null ? ClientConfiguration.loadDefault() : new ClientConfiguration(this.clientConfigFile);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.updateKerberosCredentials(clientConfig);
    }

    public void updateKerberosCredentials(ClientConfiguration clientConfig) {
        boolean clientConfSaslEnabled = Boolean.parseBoolean(clientConfig.get(ClientConfiguration.ClientProperty.INSTANCE_RPC_SASL_ENABLED));
        if ((this.saslEnabled || clientConfSaslEnabled) && null == this.tokenClassName) {
            this.tokenClassName = KerberosToken.CLASS_NAME;
            if (null != this.keytabPath) {
                File keytab = new File(this.keytabPath);
                if (!keytab.exists() || !keytab.isFile()) {
                    throw new IllegalArgumentException("Keytab isn't a normal file: " + this.keytabPath);
                }
                if (null == this.principal) {
                    throw new IllegalArgumentException("Principal must be provided if logging in via Keytab");
                }
                try {
                    UserGroupInformation.loginUserFromKeytab((String)this.principal, (String)keytab.getAbsolutePath());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to log in with keytab", e);
                }
            }
        }
    }

    @Override
    public void parseArgs(String programName, String[] args, Object ... others) {
        super.parseArgs(programName, args, others);
        this.startDebugLogging();
        this.startTracing(programName);
        this.updateKerberosCredentials();
    }

    public synchronized Instance getInstance() {
        if (this.cachedInstance != null) {
            return this.cachedInstance;
        }
        if (this.mock) {
            this.cachedInstance = new MockInstance(this.instance);
            return this.cachedInstance;
        }
        this.cachedInstance = new ZooKeeperInstance((org.apache.commons.configuration.Configuration)this.getClientConfiguration());
        return this.cachedInstance;
    }

    public String getPrincipal() throws AccumuloSecurityException {
        if (null == this.principal) {
            AuthenticationToken token = this.getToken();
            if (null == token) {
                throw new AccumuloSecurityException("No principal or authentication token was provided", SecurityErrorCode.BAD_CREDENTIALS);
            }
            if (null != this.principal) {
                return this.principal;
            }
            this.principal = token instanceof KerberosToken ? ((KerberosToken)token).getPrincipal() : System.getProperty("user.name");
        }
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public Password getPassword() {
        return this.password;
    }

    public void setPassword(Password password) {
        this.password = password;
    }

    public Password getSecurePassword() {
        return this.securePassword;
    }

    public void setSecurePassword(Password securePassword) {
        this.securePassword = securePassword;
    }

    public String getTokenClassName() {
        return this.tokenClassName;
    }

    public Connector getConnector() throws AccumuloException, AccumuloSecurityException {
        return this.getInstance().getConnector(this.getPrincipal(), this.getToken());
    }

    public ClientConfiguration getClientConfiguration() throws IllegalArgumentException {
        ClientConfiguration clientConfig;
        if (this.cachedClientConfig != null) {
            return this.cachedClientConfig;
        }
        try {
            clientConfig = this.clientConfigFile == null ? ClientConfiguration.loadDefault() : new ClientConfiguration(this.clientConfigFile);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (this.sslEnabled) {
            clientConfig.setProperty(ClientConfiguration.ClientProperty.INSTANCE_RPC_SSL_ENABLED, "true");
        }
        if (this.saslEnabled) {
            clientConfig.setProperty(ClientConfiguration.ClientProperty.INSTANCE_RPC_SASL_ENABLED, "true");
        }
        if (this.siteFile != null) {
            AccumuloConfiguration config = new AccumuloConfiguration(){
                Configuration xml = new Configuration();
                {
                    this.xml.addResource(new Path(ClientOpts.this.siteFile));
                }

                @Override
                public void getProperties(Map<String, String> props, Predicate<String> filter) {
                    for (Map.Entry prop : DefaultConfiguration.getInstance()) {
                        if (!filter.apply((Object)prop.getKey())) continue;
                        props.put((String)prop.getKey(), (String)prop.getValue());
                    }
                    for (Map.Entry prop : this.xml) {
                        if (!filter.apply(prop.getKey())) continue;
                        props.put((String)prop.getKey(), (String)prop.getValue());
                    }
                }

                @Override
                public String get(Property property) {
                    String value = this.xml.get(property.getKey());
                    if (value != null) {
                        return value;
                    }
                    return DefaultConfiguration.getInstance().get(property);
                }
            };
            this.zookeepers = config.get(Property.INSTANCE_ZK_HOST);
            String volDir = VolumeConfiguration.getVolumeUris(config)[0];
            Path instanceDir = new Path(volDir, "instance_id");
            String instanceIDFromFile = ZooUtil.getInstanceIDFromHdfs(instanceDir, config);
            if (config.getBoolean(Property.INSTANCE_RPC_SSL_ENABLED)) {
                clientConfig.setProperty(ClientConfiguration.ClientProperty.INSTANCE_RPC_SSL_ENABLED, "true");
            }
            this.cachedClientConfig = clientConfig.withInstance(UUID.fromString(instanceIDFromFile)).withZkHosts(this.zookeepers);
            return this.cachedClientConfig;
        }
        this.cachedClientConfig = clientConfig.withInstance(this.instance).withZkHosts(this.zookeepers);
        return this.cachedClientConfig;
    }

    public static class VisibilityConverter
    implements IStringConverter<ColumnVisibility> {
        public ColumnVisibility convert(String value) {
            return new ColumnVisibility(value);
        }
    }

    public static class PasswordConverter
    implements IStringConverter<Password> {
        public Password convert(String value) {
            return new Password(value);
        }
    }

    public static class Password {
        public byte[] value;

        public Password(String dfault) {
            this.value = dfault.getBytes(StandardCharsets.UTF_8);
        }

        public String toString() {
            return new String(this.value, StandardCharsets.UTF_8);
        }
    }

    public static class AuthConverter
    implements IStringConverter<Authorizations> {
        public Authorizations convert(String value) {
            return new Authorizations(value.split(","));
        }
    }

    public static class MemoryConverter
    implements IStringConverter<Long> {
        public Long convert(String value) {
            return AccumuloConfiguration.getMemoryInBytes(value);
        }
    }

    public static class TimeConverter
    implements IStringConverter<Long> {
        public Long convert(String value) {
            return AccumuloConfiguration.getTimeInMillis(value);
        }
    }
}

