/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfiguration
extends CompositeConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ClientConfiguration.class);
    public static final String USER_ACCUMULO_DIR_NAME = ".accumulo";
    public static final String USER_CONF_FILENAME = "config";
    public static final String GLOBAL_CONF_FILENAME = "client.conf";

    public ClientConfiguration(String configFile) throws ConfigurationException {
        this(new PropertiesConfiguration(), configFile);
    }

    private ClientConfiguration(PropertiesConfiguration propertiesConfiguration, String configFile) throws ConfigurationException {
        super((Configuration)propertiesConfiguration);
        this.setListDelimiter('\u0000');
        propertiesConfiguration.setListDelimiter('\u0000');
        propertiesConfiguration.load(configFile);
    }

    public ClientConfiguration(File configFile) throws ConfigurationException {
        this(new PropertiesConfiguration(), configFile);
    }

    private ClientConfiguration(PropertiesConfiguration propertiesConfiguration, File configFile) throws ConfigurationException {
        super((Configuration)propertiesConfiguration);
        this.setListDelimiter('\u0000');
        propertiesConfiguration.setListDelimiter('\u0000');
        propertiesConfiguration.load(configFile);
    }

    public ClientConfiguration(List<? extends Configuration> configs) {
        super(configs);
        this.setListDelimiter('\u0000');
        for (Configuration configuration : configs) {
            AbstractConfiguration abstractConfiguration;
            if (!(configuration instanceof AbstractConfiguration) || (abstractConfiguration = (AbstractConfiguration)configuration).isDelimiterParsingDisabled() || abstractConfiguration.getListDelimiter() == '\u0000') continue;
            log.warn("Client configuration constructed with a Configuration that did not have list delimiter disabled or overridden, multi-valued config properties may be unavailable");
            abstractConfiguration.setListDelimiter('\u0000');
        }
    }

    public ClientConfiguration(Configuration ... configs) {
        this(Arrays.asList(configs));
    }

    public static ClientConfiguration loadDefault() {
        return ClientConfiguration.loadFromSearchPath(ClientConfiguration.getDefaultSearchPath());
    }

    private static ClientConfiguration loadFromSearchPath(List<String> paths) {
        try {
            LinkedList<ClientConfiguration> configs = new LinkedList<ClientConfiguration>();
            for (String path : paths) {
                File conf = new File(path);
                if (!conf.isFile() || !conf.canRead()) continue;
                configs.add(new ClientConfiguration(conf));
            }
            if (configs.isEmpty()) {
                log.warn("Found no client.conf in default paths. Using default client configuration values.");
            }
            return new ClientConfiguration(configs);
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException("Error loading client configuration", e);
        }
    }

    public static ClientConfiguration deserialize(String serializedConfig) {
        PropertiesConfiguration propConfig = new PropertiesConfiguration();
        propConfig.setListDelimiter('\u0000');
        try {
            propConfig.load((Reader)new StringReader(serializedConfig));
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Error deserializing client configuration: " + serializedConfig, e);
        }
        return new ClientConfiguration(new Configuration[]{propConfig});
    }

    static String getClientConfPath(String clientConfPath) {
        if (null == clientConfPath) {
            return null;
        }
        File filePath = new File(clientConfPath);
        if (filePath.exists() && filePath.isDirectory()) {
            return new File(filePath, GLOBAL_CONF_FILENAME).toString();
        }
        return clientConfPath;
    }

    private static List<String> getDefaultSearchPath() {
        LinkedList<String> clientConfPaths;
        String clientConfSearchPath = ClientConfiguration.getClientConfPath(System.getenv("ACCUMULO_CLIENT_CONF_PATH"));
        if (clientConfSearchPath != null) {
            clientConfPaths = Arrays.asList(clientConfSearchPath.split(File.pathSeparator));
        } else {
            clientConfPaths = new LinkedList();
            clientConfPaths.add(System.getProperty("user.home") + File.separator + USER_ACCUMULO_DIR_NAME + File.separator + USER_CONF_FILENAME);
            if (System.getenv("ACCUMULO_CONF_DIR") != null) {
                clientConfPaths.add(System.getenv("ACCUMULO_CONF_DIR") + File.separator + GLOBAL_CONF_FILENAME);
            } else if (System.getenv("ACCUMULO_HOME") != null) {
                clientConfPaths.add(System.getenv("ACCUMULO_HOME") + File.separator + "conf" + File.separator + GLOBAL_CONF_FILENAME);
            }
            clientConfPaths.add("/etc/accumulo/client.conf");
            clientConfPaths.add("/etc/accumulo/conf/client.conf");
        }
        return clientConfPaths;
    }

    public String serialize() {
        PropertiesConfiguration propConfig = new PropertiesConfiguration();
        propConfig.copy((Configuration)this);
        StringWriter writer = new StringWriter();
        try {
            propConfig.save((Writer)writer);
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException(e);
        }
        return writer.toString();
    }

    public String get(ClientProperty prop) {
        if (this.containsKey(prop.getKey())) {
            return this.getString(prop.getKey());
        }
        return prop.getDefaultValue();
    }

    private void checkType(ClientProperty property, PropertyType type) {
        if (!property.getType().equals((Object)type)) {
            String msg = "Configuration method intended for type " + (Object)((Object)type) + " called with a " + (Object)((Object)property.getType()) + " argument (" + property.getKey() + ")";
            throw new IllegalArgumentException(msg);
        }
    }

    public Map<String, String> getAllPropertiesWithPrefix(ClientProperty property) {
        this.checkType(property, PropertyType.PREFIX);
        HashMap<String, String> propMap = new HashMap<String, String>();
        String prefix = property.getKey();
        if (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        Iterator iter = this.getKeys(prefix);
        while (iter.hasNext()) {
            String p = (String)iter.next();
            propMap.put(p, this.getString(p));
        }
        return propMap;
    }

    public void setProperty(ClientProperty prop, String value) {
        this.setProperty(prop.getKey(), value);
    }

    public ClientConfiguration with(ClientProperty prop, String value) {
        this.setProperty(prop.getKey(), value);
        return this;
    }

    public ClientConfiguration withInstance(String instanceName) {
        Preconditions.checkArgument((instanceName != null ? 1 : 0) != 0, (Object)"instanceName is null");
        return this.with(ClientProperty.INSTANCE_NAME, instanceName);
    }

    public ClientConfiguration withInstance(UUID instanceId) {
        Preconditions.checkArgument((instanceId != null ? 1 : 0) != 0, (Object)"instanceId is null");
        return this.with(ClientProperty.INSTANCE_ID, instanceId.toString());
    }

    public ClientConfiguration withZkHosts(String zooKeepers) {
        Preconditions.checkArgument((zooKeepers != null ? 1 : 0) != 0, (Object)"zooKeepers is null");
        return this.with(ClientProperty.INSTANCE_ZK_HOST, zooKeepers);
    }

    public ClientConfiguration withZkTimeout(int timeout) {
        return this.with(ClientProperty.INSTANCE_ZK_TIMEOUT, String.valueOf(timeout));
    }

    public ClientConfiguration withSsl(boolean sslEnabled) {
        return this.withSsl(sslEnabled, false);
    }

    public ClientConfiguration withSsl(boolean sslEnabled, boolean useJsseConfig) {
        return this.with(ClientProperty.INSTANCE_RPC_SSL_ENABLED, String.valueOf(sslEnabled)).with(ClientProperty.RPC_USE_JSSE, String.valueOf(useJsseConfig));
    }

    public ClientConfiguration withTruststore(String path) {
        return this.withTruststore(path, null, null);
    }

    public ClientConfiguration withTruststore(String path, String password, String type) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path is null");
        this.setProperty(ClientProperty.RPC_SSL_TRUSTSTORE_PATH, path);
        if (password != null) {
            this.setProperty(ClientProperty.RPC_SSL_TRUSTSTORE_PASSWORD, password);
        }
        if (type != null) {
            this.setProperty(ClientProperty.RPC_SSL_TRUSTSTORE_TYPE, type);
        }
        return this;
    }

    public ClientConfiguration withKeystore(String path) {
        return this.withKeystore(path, null, null);
    }

    public ClientConfiguration withKeystore(String path, String password, String type) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path is null");
        this.setProperty(ClientProperty.INSTANCE_RPC_SSL_CLIENT_AUTH, "true");
        this.setProperty(ClientProperty.RPC_SSL_KEYSTORE_PATH, path);
        if (password != null) {
            this.setProperty(ClientProperty.RPC_SSL_KEYSTORE_PASSWORD, password);
        }
        if (type != null) {
            this.setProperty(ClientProperty.RPC_SSL_KEYSTORE_TYPE, type);
        }
        return this;
    }

    public ClientConfiguration withSasl(boolean saslEnabled) {
        return this.with(ClientProperty.INSTANCE_RPC_SASL_ENABLED, String.valueOf(saslEnabled));
    }

    public ClientConfiguration withSasl(boolean saslEnabled, String kerberosServerPrimary) {
        return this.withSasl(saslEnabled).with(ClientProperty.KERBEROS_SERVER_PRIMARY, kerberosServerPrimary);
    }

    public static enum ClientProperty {
        RPC_SSL_TRUSTSTORE_PATH(Property.RPC_SSL_TRUSTSTORE_PATH),
        RPC_SSL_TRUSTSTORE_PASSWORD(Property.RPC_SSL_TRUSTSTORE_PASSWORD),
        RPC_SSL_TRUSTSTORE_TYPE(Property.RPC_SSL_TRUSTSTORE_TYPE),
        RPC_SSL_KEYSTORE_PATH(Property.RPC_SSL_KEYSTORE_PATH),
        RPC_SSL_KEYSTORE_PASSWORD(Property.RPC_SSL_KEYSTORE_PASSWORD),
        RPC_SSL_KEYSTORE_TYPE(Property.RPC_SSL_KEYSTORE_TYPE),
        RPC_USE_JSSE(Property.RPC_USE_JSSE),
        GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS),
        INSTANCE_RPC_SSL_CLIENT_AUTH(Property.INSTANCE_RPC_SSL_CLIENT_AUTH),
        INSTANCE_RPC_SSL_ENABLED(Property.INSTANCE_RPC_SSL_ENABLED),
        INSTANCE_ZK_HOST(Property.INSTANCE_ZK_HOST),
        INSTANCE_ZK_TIMEOUT(Property.INSTANCE_ZK_TIMEOUT),
        INSTANCE_NAME("instance.name", null, PropertyType.STRING, "Name of Accumulo instance to connect to"),
        INSTANCE_ID("instance.id", null, PropertyType.STRING, "UUID of Accumulo instance to connect to"),
        TRACE_SPAN_RECEIVERS(Property.TRACE_SPAN_RECEIVERS),
        TRACE_SPAN_RECEIVER_PREFIX(Property.TRACE_SPAN_RECEIVER_PREFIX),
        TRACE_ZK_PATH(Property.TRACE_ZK_PATH),
        INSTANCE_RPC_SASL_ENABLED(Property.INSTANCE_RPC_SASL_ENABLED),
        RPC_SASL_QOP(Property.RPC_SASL_QOP),
        KERBEROS_SERVER_PRIMARY("kerberos.server.primary", "accumulo", PropertyType.STRING, "The first component of the Kerberos principal, the 'primary', that Accumulo servers use to login");

        private String key;
        private String defaultValue;
        private PropertyType type;
        private String description;
        private Property accumuloProperty = null;

        private ClientProperty(Property prop) {
            this(prop.getKey(), prop.getDefaultValue(), prop.getType(), prop.getDescription());
            this.accumuloProperty = prop;
        }

        private ClientProperty(String key, String defaultValue, PropertyType type, String description) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.type = type;
            this.description = description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Deprecated
        public PropertyType getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        @Deprecated
        public Property getAccumuloProperty() {
            return this.accumuloProperty;
        }

        public static ClientProperty getPropertyByKey(String key) {
            for (ClientProperty prop : ClientProperty.values()) {
                if (!prop.getKey().equals(key)) continue;
                return prop;
            }
            return null;
        }
    }
}

