/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.SecurityPermission;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tables {
    private static final Logger log = LoggerFactory.getLogger(Tables.class);
    public static final String VALID_NAME_REGEX = "^(\\w+\\.)?(\\w+)$";
    private static final SecurityPermission TABLES_PERMISSION = new SecurityPermission("tablesPermission");
    private static final AtomicLong cacheResetCount = new AtomicLong(0L);

    private static ZooCache getZooCache(Instance instance) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(TABLES_PERMISSION);
        }
        return new ZooCacheFactory().getZooCache(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut());
    }

    private static SortedMap<String, String> getMap(Instance instance, boolean nameAsKey) {
        ZooCache zc = Tables.getZooCache(instance);
        List tableIds = zc.getChildren(ZooUtil.getRoot(instance) + "/tables");
        TreeMap<String, String> tableMap = new TreeMap<String, String>();
        HashMap<String, String> namespaceIdToNameMap = new HashMap<String, String>();
        for (String tableId : tableIds) {
            String namespaceName;
            byte[] tableName;
            block7: {
                tableName = zc.get(ZooUtil.getRoot(instance) + "/tables" + "/" + tableId + "/name");
                byte[] nId = zc.get(ZooUtil.getRoot(instance) + "/tables" + "/" + tableId + "/namespace");
                namespaceName = "";
                if (nId == null) {
                    namespaceName = null;
                } else {
                    String namespaceId = new String(nId, StandardCharsets.UTF_8);
                    if (!namespaceId.equals("+default")) {
                        try {
                            namespaceName = (String)namespaceIdToNameMap.get(namespaceId);
                            if (namespaceName != null) break block7;
                            namespaceName = Namespaces.getNamespaceName(instance, namespaceId);
                            namespaceIdToNameMap.put(namespaceId, namespaceName);
                        }
                        catch (NamespaceNotFoundException e) {
                            log.error("Table (" + tableId + ") contains reference to namespace (" + namespaceId + ") that doesn't exist", (Throwable)e);
                            continue;
                        }
                    }
                }
            }
            if (tableName == null || namespaceName == null) continue;
            String tableNameStr = Tables.qualified(new String(tableName, StandardCharsets.UTF_8), namespaceName);
            if (nameAsKey) {
                tableMap.put(tableNameStr, tableId);
                continue;
            }
            tableMap.put(tableId, tableNameStr);
        }
        return tableMap;
    }

    public static String getTableId(Instance instance, String tableName) throws TableNotFoundException {
        try {
            return Tables._getTableId(instance, tableName);
        }
        catch (NamespaceNotFoundException e) {
            throw new TableNotFoundException(tableName, e);
        }
    }

    public static String _getTableId(Instance instance, String tableName) throws NamespaceNotFoundException, TableNotFoundException {
        String tableId = (String)Tables.getNameToIdMap(instance).get(tableName);
        if (tableId == null) {
            Tables.clearCache(instance);
            tableId = (String)Tables.getNameToIdMap(instance).get(tableName);
            if (tableId == null) {
                String namespace = Tables.qualify(tableName).getFirst();
                if (Namespaces.getNameToIdMap(instance).containsKey(namespace)) {
                    throw new TableNotFoundException(null, tableName, null);
                }
                throw new NamespaceNotFoundException(null, namespace, null);
            }
        }
        return tableId;
    }

    public static String getTableName(Instance instance, String tableId) throws TableNotFoundException {
        String tableName = (String)Tables.getIdToNameMap(instance).get(tableId);
        if (tableName == null) {
            throw new TableNotFoundException(tableId, null, null);
        }
        return tableName;
    }

    public static SortedMap<String, String> getNameToIdMap(Instance instance) {
        return Tables.getMap(instance, true);
    }

    public static SortedMap<String, String> getIdToNameMap(Instance instance) {
        return Tables.getMap(instance, false);
    }

    public static boolean exists(Instance instance, String tableId) {
        ZooCache zc = Tables.getZooCache(instance);
        List tableIds = zc.getChildren(ZooUtil.getRoot(instance) + "/tables");
        return tableIds.contains(tableId);
    }

    public static void clearCache(Instance instance) {
        cacheResetCount.incrementAndGet();
        Tables.getZooCache(instance).clear(ZooUtil.getRoot(instance) + "/tables");
        Tables.getZooCache(instance).clear(ZooUtil.getRoot(instance) + "/namespaces");
    }

    public static String getPrintableTableNameFromId(Map<String, String> tidToNameMap, String tableId) {
        String tableName = tidToNameMap.get(tableId);
        return tableName == null ? "(ID:" + tableId + ")" : tableName;
    }

    public static String getPrintableTableInfoFromId(Instance instance, String tableId) {
        String tableName = null;
        try {
            tableName = Tables.getTableName(instance, tableId);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        return tableName == null ? String.format("?(ID:%s)", tableId) : String.format("%s(ID:%s)", tableName, tableId);
    }

    public static String getPrintableTableInfoFromName(Instance instance, String tableName) {
        String tableId = null;
        try {
            tableId = Tables.getTableId(instance, tableName);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        return tableId == null ? String.format("%s(?)", tableName) : String.format("%s(ID:%s)", tableName, tableId);
    }

    public static TableState getTableState(Instance instance, String tableId) {
        String statePath = ZooUtil.getRoot(instance) + "/tables" + "/" + tableId + "/state";
        ZooCache zc = Tables.getZooCache(instance);
        byte[] state = zc.get(statePath);
        if (state == null) {
            return TableState.UNKNOWN;
        }
        return TableState.valueOf(new String(state, StandardCharsets.UTF_8));
    }

    public static long getCacheResetCount() {
        return cacheResetCount.get();
    }

    public static String qualified(String tableName) {
        return Tables.qualified(tableName, "");
    }

    public static String qualified(String tableName, String defaultNamespace) {
        Pair<String, String> qualifiedTableName = Tables.qualify(tableName, defaultNamespace);
        if ("".equals(qualifiedTableName.getFirst())) {
            return qualifiedTableName.getSecond();
        }
        return qualifiedTableName.toString("", ".", "");
    }

    public static Pair<String, String> qualify(String tableName) {
        return Tables.qualify(tableName, "");
    }

    public static Pair<String, String> qualify(String tableName, String defaultNamespace) {
        if (!tableName.matches(VALID_NAME_REGEX)) {
            throw new IllegalArgumentException("Invalid table name '" + tableName + "'");
        }
        if ("!METADATA".equals(tableName)) {
            tableName = "accumulo.metadata";
        }
        if (tableName.contains(".")) {
            String[] s = tableName.split("\\.", 2);
            return new Pair<String, String>(s[0], s[1]);
        }
        return new Pair<String, String>(defaultNamespace, tableName);
    }

    public static String getNamespaceId(Instance instance, String tableId) throws IllegalArgumentException {
        Preconditions.checkArgument((instance != null ? 1 : 0) != 0, (Object)"instance is null");
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId is null");
        ZooCache zc = Tables.getZooCache(instance);
        byte[] n = zc.get(ZooUtil.getRoot(instance) + "/tables" + "/" + tableId + "/namespace");
        if (null == n) {
            throw new IllegalArgumentException("Table with id " + tableId + " does not exist");
        }
        return new String(n, StandardCharsets.UTF_8);
    }
}

