/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.security.tokens;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.hadoop.security.UserGroupInformation;

public class KerberosToken
implements AuthenticationToken {
    public static final String CLASS_NAME = KerberosToken.class.getName();
    private static final int VERSION = 1;
    private String principal;
    private File keytab;

    public KerberosToken(String principal) throws IOException {
        Objects.requireNonNull(principal);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Preconditions.checkArgument((boolean)ugi.hasKerberosCredentials(), (Object)"Subject is not logged in via Kerberos");
        Preconditions.checkArgument((boolean)principal.equals(ugi.getUserName()), (Object)"Provided principal does not match currently logged-in user");
        this.principal = ugi.getUserName();
    }

    public KerberosToken(String principal, File keytab, boolean replaceCurrentUser) throws IOException {
        UserGroupInformation ugi;
        Objects.requireNonNull(principal, "Principal was null");
        Objects.requireNonNull(keytab, "Keytab was null");
        Preconditions.checkArgument((keytab.exists() && keytab.isFile() ? 1 : 0) != 0, (Object)"Keytab was not a normal file");
        if (replaceCurrentUser) {
            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab.getAbsolutePath());
            ugi = UserGroupInformation.getCurrentUser();
        } else {
            ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab.getAbsolutePath());
        }
        this.principal = ugi.getUserName();
        this.keytab = keytab;
    }

    public KerberosToken() throws IOException {
        this(UserGroupInformation.getCurrentUser().getUserName());
    }

    @Override
    public KerberosToken clone() {
        try {
            KerberosToken clone = (KerberosToken)super.clone();
            clone.principal = this.principal;
            clone.keytab = this.keytab == null ? this.keytab : this.keytab.getCanonicalFile();
            return clone;
        }
        catch (IOException | CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KerberosToken)) {
            return false;
        }
        KerberosToken other = (KerberosToken)obj;
        return this.principal.equals(other.principal);
    }

    public String getPrincipal() {
        return this.principal;
    }

    public File getKeytab() {
        return this.keytab;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(1);
    }

    public void readFields(DataInput in) throws IOException {
        int actualVersion = in.readInt();
        if (1 != actualVersion) {
            throw new IOException("Did not find expected version in serialized KerberosToken");
        }
    }

    @Override
    public synchronized void destroy() throws DestroyFailedException {
        this.principal = null;
    }

    @Override
    public boolean isDestroyed() {
        return null == this.principal;
    }

    @Override
    public void init(AuthenticationToken.Properties properties) {
    }

    @Override
    public Set<AuthenticationToken.TokenProperty> getProperties() {
        return Collections.emptySet();
    }

    public int hashCode() {
        return this.principal.hashCode();
    }
}

