/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.TKey;
import org.apache.accumulo.core.data.thrift.TKeyValue;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class Key
implements WritableComparable<Key>,
Cloneable {
    protected byte[] row;
    protected byte[] colFamily;
    protected byte[] colQualifier;
    protected byte[] colVisibility;
    protected long timestamp;
    protected boolean deleted;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public boolean equals(Object o) {
        if (o instanceof Key) {
            return this.equals((Key)o, PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME_DEL);
        }
        return false;
    }

    private byte[] copyIfNeeded(byte[] ba, int off, int len, boolean copyData) {
        if (len == 0) {
            return EMPTY_BYTES;
        }
        if (!copyData && ba.length == len && off == 0) {
            return ba;
        }
        byte[] copy = new byte[len];
        System.arraycopy(ba, off, copy, 0, len);
        return copy;
    }

    private final void init(byte[] r, int rOff, int rLen, byte[] cf, int cfOff, int cfLen, byte[] cq, int cqOff, int cqLen, byte[] cv, int cvOff, int cvLen, long ts, boolean del, boolean copy) {
        this.row = this.copyIfNeeded(r, rOff, rLen, copy);
        this.colFamily = this.copyIfNeeded(cf, cfOff, cfLen, copy);
        this.colQualifier = this.copyIfNeeded(cq, cqOff, cqLen, copy);
        this.colVisibility = this.copyIfNeeded(cv, cvOff, cvLen, copy);
        this.timestamp = ts;
        this.deleted = del;
    }

    public Key() {
        this.row = EMPTY_BYTES;
        this.colFamily = EMPTY_BYTES;
        this.colQualifier = EMPTY_BYTES;
        this.colVisibility = EMPTY_BYTES;
        this.timestamp = Long.MAX_VALUE;
        this.deleted = false;
    }

    public Key(Text row) {
        this.init(row.getBytes(), 0, row.getLength(), EMPTY_BYTES, 0, 0, EMPTY_BYTES, 0, 0, EMPTY_BYTES, 0, 0, Long.MAX_VALUE, false, true);
    }

    public Key(Text row, long ts) {
        this(row);
        this.timestamp = ts;
    }

    public Key(byte[] row, int rOff, int rLen, byte[] cf, int cfOff, int cfLen, byte[] cq, int cqOff, int cqLen, byte[] cv, int cvOff, int cvLen, long ts) {
        this.init(row, rOff, rLen, cf, cfOff, cfLen, cq, cqOff, cqLen, cv, cvOff, cvLen, ts, false, true);
    }

    public Key(byte[] row, byte[] colFamily, byte[] colQualifier, byte[] colVisibility, long timestamp) {
        this(row, colFamily, colQualifier, colVisibility, timestamp, false, true);
    }

    public Key(byte[] row, byte[] cf, byte[] cq, byte[] cv, long ts, boolean deleted) {
        this(row, cf, cq, cv, ts, deleted, true);
    }

    public Key(byte[] row, byte[] cf, byte[] cq, byte[] cv, long ts, boolean deleted, boolean copy) {
        this.init(row, 0, row.length, cf, 0, cf.length, cq, 0, cq.length, cv, 0, cv.length, ts, deleted, copy);
    }

    public Key(Text row, Text cf) {
        this.init(row.getBytes(), 0, row.getLength(), cf.getBytes(), 0, cf.getLength(), EMPTY_BYTES, 0, 0, EMPTY_BYTES, 0, 0, Long.MAX_VALUE, false, true);
    }

    public Key(Text row, Text cf, Text cq) {
        this.init(row.getBytes(), 0, row.getLength(), cf.getBytes(), 0, cf.getLength(), cq.getBytes(), 0, cq.getLength(), EMPTY_BYTES, 0, 0, Long.MAX_VALUE, false, true);
    }

    public Key(Text row, Text cf, Text cq, Text cv) {
        this.init(row.getBytes(), 0, row.getLength(), cf.getBytes(), 0, cf.getLength(), cq.getBytes(), 0, cq.getLength(), cv.getBytes(), 0, cv.getLength(), Long.MAX_VALUE, false, true);
    }

    public Key(Text row, Text cf, Text cq, long ts) {
        this.init(row.getBytes(), 0, row.getLength(), cf.getBytes(), 0, cf.getLength(), cq.getBytes(), 0, cq.getLength(), EMPTY_BYTES, 0, 0, ts, false, true);
    }

    public Key(Text row, Text cf, Text cq, Text cv, long ts) {
        this.init(row.getBytes(), 0, row.getLength(), cf.getBytes(), 0, cf.getLength(), cq.getBytes(), 0, cq.getLength(), cv.getBytes(), 0, cv.getLength(), ts, false, true);
    }

    public Key(Text row, Text cf, Text cq, ColumnVisibility cv, long ts) {
        byte[] expr = cv.getExpression();
        this.init(row.getBytes(), 0, row.getLength(), cf.getBytes(), 0, cf.getLength(), cq.getBytes(), 0, cq.getLength(), expr, 0, expr.length, ts, false, true);
    }

    public Key(CharSequence row) {
        this(new Text(row.toString()));
    }

    public Key(CharSequence row, CharSequence cf) {
        this(new Text(row.toString()), new Text(cf.toString()));
    }

    public Key(CharSequence row, CharSequence cf, CharSequence cq) {
        this(new Text(row.toString()), new Text(cf.toString()), new Text(cq.toString()));
    }

    public Key(CharSequence row, CharSequence cf, CharSequence cq, CharSequence cv) {
        this(new Text(row.toString()), new Text(cf.toString()), new Text(cq.toString()), new Text(cv.toString()));
    }

    public Key(CharSequence row, CharSequence cf, CharSequence cq, long ts) {
        this(new Text(row.toString()), new Text(cf.toString()), new Text(cq.toString()), ts);
    }

    public Key(CharSequence row, CharSequence cf, CharSequence cq, CharSequence cv, long ts) {
        this(new Text(row.toString()), new Text(cf.toString()), new Text(cq.toString()), new Text(cv.toString()), ts);
    }

    public Key(CharSequence row, CharSequence cf, CharSequence cq, ColumnVisibility cv, long ts) {
        this(new Text(row.toString()), new Text(cf.toString()), new Text(cq.toString()), new Text(cv.getExpression()), ts);
    }

    private byte[] followingArray(byte[] ba) {
        byte[] fba = new byte[ba.length + 1];
        System.arraycopy(ba, 0, fba, 0, ba.length);
        fba[ba.length] = 0;
        return fba;
    }

    public Key followingKey(PartialKey part) {
        Key returnKey = new Key();
        switch (part) {
            case ROW: {
                returnKey.row = this.followingArray(this.row);
                break;
            }
            case ROW_COLFAM: {
                returnKey.row = this.row;
                returnKey.colFamily = this.followingArray(this.colFamily);
                break;
            }
            case ROW_COLFAM_COLQUAL: {
                returnKey.row = this.row;
                returnKey.colFamily = this.colFamily;
                returnKey.colQualifier = this.followingArray(this.colQualifier);
                break;
            }
            case ROW_COLFAM_COLQUAL_COLVIS: {
                returnKey.row = this.row;
                returnKey.colFamily = this.colFamily;
                returnKey.colQualifier = this.colQualifier;
                returnKey.colVisibility = this.followingArray(this.colVisibility);
                break;
            }
            case ROW_COLFAM_COLQUAL_COLVIS_TIME: {
                returnKey.row = this.row;
                returnKey.colFamily = this.colFamily;
                returnKey.colQualifier = this.colQualifier;
                returnKey.colVisibility = this.colVisibility;
                returnKey.setTimestamp(this.timestamp - 1L);
                returnKey.deleted = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Partial key specification " + (Object)((Object)part) + " disallowed");
            }
        }
        return returnKey;
    }

    public Key(Key other) {
        this.set(other);
    }

    public Key(TKey tkey) {
        this.row = ByteBufferUtil.toBytes(tkey.row);
        this.colFamily = ByteBufferUtil.toBytes(tkey.colFamily);
        this.colQualifier = ByteBufferUtil.toBytes(tkey.colQualifier);
        this.colVisibility = ByteBufferUtil.toBytes(tkey.colVisibility);
        this.timestamp = tkey.timestamp;
        this.deleted = false;
        if (this.row == null) {
            throw new IllegalArgumentException("null row");
        }
        if (this.colFamily == null) {
            throw new IllegalArgumentException("null column family");
        }
        if (this.colQualifier == null) {
            throw new IllegalArgumentException("null column qualifier");
        }
        if (this.colVisibility == null) {
            throw new IllegalArgumentException("null column visibility");
        }
    }

    public Text getRow(Text r) {
        r.set(this.row, 0, this.row.length);
        return r;
    }

    public ByteSequence getRowData() {
        return new ArrayByteSequence(this.row);
    }

    public Text getRow() {
        return this.getRow(new Text());
    }

    public int compareRow(Text r) {
        return WritableComparator.compareBytes((byte[])this.row, (int)0, (int)this.row.length, (byte[])r.getBytes(), (int)0, (int)r.getLength());
    }

    public ByteSequence getColumnFamilyData() {
        return new ArrayByteSequence(this.colFamily);
    }

    public Text getColumnFamily(Text cf) {
        cf.set(this.colFamily, 0, this.colFamily.length);
        return cf;
    }

    public Text getColumnFamily() {
        return this.getColumnFamily(new Text());
    }

    public int compareColumnFamily(Text cf) {
        return WritableComparator.compareBytes((byte[])this.colFamily, (int)0, (int)this.colFamily.length, (byte[])cf.getBytes(), (int)0, (int)cf.getLength());
    }

    public ByteSequence getColumnQualifierData() {
        return new ArrayByteSequence(this.colQualifier);
    }

    public Text getColumnQualifier(Text cq) {
        cq.set(this.colQualifier, 0, this.colQualifier.length);
        return cq;
    }

    public Text getColumnQualifier() {
        return this.getColumnQualifier(new Text());
    }

    public int compareColumnQualifier(Text cq) {
        return WritableComparator.compareBytes((byte[])this.colQualifier, (int)0, (int)this.colQualifier.length, (byte[])cq.getBytes(), (int)0, (int)cq.getLength());
    }

    public void setTimestamp(long ts) {
        this.timestamp = ts;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public ByteSequence getColumnVisibilityData() {
        return new ArrayByteSequence(this.colVisibility);
    }

    public final Text getColumnVisibility() {
        return this.getColumnVisibility(new Text());
    }

    public final Text getColumnVisibility(Text cv) {
        cv.set(this.colVisibility, 0, this.colVisibility.length);
        return cv;
    }

    public final ColumnVisibility getColumnVisibilityParsed() {
        return new ColumnVisibility(this.colVisibility);
    }

    public void set(Key k) {
        this.row = k.row;
        this.colFamily = k.colFamily;
        this.colQualifier = k.colQualifier;
        this.colVisibility = k.colVisibility;
        this.timestamp = k.timestamp;
        this.deleted = k.deleted;
    }

    public void readFields(DataInput in) throws IOException {
        int colFamilyOffset = WritableUtils.readVInt((DataInput)in);
        int colQualifierOffset = WritableUtils.readVInt((DataInput)in);
        int colVisibilityOffset = WritableUtils.readVInt((DataInput)in);
        int totalLen = WritableUtils.readVInt((DataInput)in);
        this.row = new byte[colFamilyOffset];
        this.colFamily = new byte[colQualifierOffset - colFamilyOffset];
        this.colQualifier = new byte[colVisibilityOffset - colQualifierOffset];
        this.colVisibility = new byte[totalLen - colVisibilityOffset];
        in.readFully(this.row);
        in.readFully(this.colFamily);
        in.readFully(this.colQualifier);
        in.readFully(this.colVisibility);
        this.timestamp = WritableUtils.readVLong((DataInput)in);
        this.deleted = in.readBoolean();
    }

    public void write(DataOutput out) throws IOException {
        int colFamilyOffset = this.row.length;
        int colQualifierOffset = colFamilyOffset + this.colFamily.length;
        int colVisibilityOffset = colQualifierOffset + this.colQualifier.length;
        int totalLen = colVisibilityOffset + this.colVisibility.length;
        WritableUtils.writeVInt((DataOutput)out, (int)colFamilyOffset);
        WritableUtils.writeVInt((DataOutput)out, (int)colQualifierOffset);
        WritableUtils.writeVInt((DataOutput)out, (int)colVisibilityOffset);
        WritableUtils.writeVInt((DataOutput)out, (int)totalLen);
        out.write(this.row);
        out.write(this.colFamily);
        out.write(this.colQualifier);
        out.write(this.colVisibility);
        WritableUtils.writeVLong((DataOutput)out, (long)this.timestamp);
        out.writeBoolean(this.deleted);
    }

    public boolean equals(Key other, PartialKey part) {
        switch (part) {
            case ROW: {
                return Key.isEqual(this.row, other.row);
            }
            case ROW_COLFAM: {
                return Key.isEqual(this.row, other.row) && Key.isEqual(this.colFamily, other.colFamily);
            }
            case ROW_COLFAM_COLQUAL: {
                return Key.isEqual(this.row, other.row) && Key.isEqual(this.colFamily, other.colFamily) && Key.isEqual(this.colQualifier, other.colQualifier);
            }
            case ROW_COLFAM_COLQUAL_COLVIS: {
                return Key.isEqual(this.row, other.row) && Key.isEqual(this.colFamily, other.colFamily) && Key.isEqual(this.colQualifier, other.colQualifier) && Key.isEqual(this.colVisibility, other.colVisibility);
            }
            case ROW_COLFAM_COLQUAL_COLVIS_TIME: {
                return Key.isEqual(this.row, other.row) && Key.isEqual(this.colFamily, other.colFamily) && Key.isEqual(this.colQualifier, other.colQualifier) && Key.isEqual(this.colVisibility, other.colVisibility) && this.timestamp == other.timestamp;
            }
            case ROW_COLFAM_COLQUAL_COLVIS_TIME_DEL: {
                return Key.isEqual(this.row, other.row) && Key.isEqual(this.colFamily, other.colFamily) && Key.isEqual(this.colQualifier, other.colQualifier) && Key.isEqual(this.colVisibility, other.colVisibility) && this.timestamp == other.timestamp && this.deleted == other.deleted;
            }
        }
        throw new IllegalArgumentException("Unrecognized partial key specification " + (Object)((Object)part));
    }

    public int compareTo(Key other, PartialKey part) {
        int result = WritableComparator.compareBytes((byte[])this.row, (int)0, (int)this.row.length, (byte[])other.row, (int)0, (int)other.row.length);
        if (result != 0 || part.equals((Object)PartialKey.ROW)) {
            return result;
        }
        result = WritableComparator.compareBytes((byte[])this.colFamily, (int)0, (int)this.colFamily.length, (byte[])other.colFamily, (int)0, (int)other.colFamily.length);
        if (result != 0 || part.equals((Object)PartialKey.ROW_COLFAM)) {
            return result;
        }
        result = WritableComparator.compareBytes((byte[])this.colQualifier, (int)0, (int)this.colQualifier.length, (byte[])other.colQualifier, (int)0, (int)other.colQualifier.length);
        if (result != 0 || part.equals((Object)PartialKey.ROW_COLFAM_COLQUAL)) {
            return result;
        }
        result = WritableComparator.compareBytes((byte[])this.colVisibility, (int)0, (int)this.colVisibility.length, (byte[])other.colVisibility, (int)0, (int)other.colVisibility.length);
        if (result != 0 || part.equals((Object)PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
            return result;
        }
        result = this.timestamp < other.timestamp ? 1 : (this.timestamp > other.timestamp ? -1 : 0);
        if (result != 0 || part.equals((Object)PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME)) {
            return result;
        }
        result = this.deleted ? (other.deleted ? 0 : -1) : (other.deleted ? 1 : 0);
        return result;
    }

    public int compareTo(Key other) {
        return this.compareTo(other, PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME_DEL);
    }

    public int hashCode() {
        return WritableComparator.hashBytes((byte[])this.row, (int)this.row.length) + WritableComparator.hashBytes((byte[])this.colFamily, (int)this.colFamily.length) + WritableComparator.hashBytes((byte[])this.colQualifier, (int)this.colQualifier.length) + WritableComparator.hashBytes((byte[])this.colVisibility, (int)this.colVisibility.length) + (int)(this.timestamp ^ this.timestamp >>> 32);
    }

    public static String toPrintableString(byte[] ba, int offset, int len, int maxLen) {
        return Key.appendPrintableString(ba, offset, len, maxLen, new StringBuilder()).toString();
    }

    public static StringBuilder appendPrintableString(byte[] ba, int offset, int len, int maxLen, StringBuilder sb) {
        int plen = Math.min(len, maxLen);
        for (int i = 0; i < plen; ++i) {
            int c = 0xFF & ba[offset + i];
            if (c >= 32 && c <= 126) {
                sb.append((char)c);
                continue;
            }
            sb.append("%" + String.format("%02x;", c));
        }
        if (len > maxLen) {
            sb.append("... TRUNCATED");
        }
        return sb;
    }

    private StringBuilder rowColumnStringBuilder() {
        return this.rowColumnStringBuilder(64);
    }

    private StringBuilder rowColumnStringBuilder(int maxComponentLength) {
        StringBuilder sb = new StringBuilder();
        Key.appendPrintableString(this.row, 0, this.row.length, maxComponentLength, sb);
        sb.append(" ");
        Key.appendPrintableString(this.colFamily, 0, this.colFamily.length, maxComponentLength, sb);
        sb.append(":");
        Key.appendPrintableString(this.colQualifier, 0, this.colQualifier.length, maxComponentLength, sb);
        sb.append(" [");
        Key.appendPrintableString(this.colVisibility, 0, this.colVisibility.length, maxComponentLength, sb);
        sb.append("]");
        return sb;
    }

    public String toString() {
        StringBuilder sb = this.rowColumnStringBuilder();
        sb.append(" ");
        sb.append(Long.toString(this.timestamp));
        sb.append(" ");
        sb.append(this.deleted);
        return sb.toString();
    }

    public String toStringNoTruncate() {
        StringBuilder sb = this.rowColumnStringBuilder(Integer.MAX_VALUE);
        sb.append(" ");
        sb.append(Long.toString(this.timestamp));
        sb.append(" ");
        sb.append(this.deleted);
        return sb.toString();
    }

    public String toStringNoTime() {
        return this.rowColumnStringBuilder().toString();
    }

    public int getLength() {
        return this.row.length + this.colFamily.length + this.colQualifier.length + this.colVisibility.length;
    }

    public int getSize() {
        return this.getLength();
    }

    private static boolean isEqual(byte[] a1, byte[] a2) {
        if (a1 == a2) {
            return true;
        }
        int last = a1.length;
        if (last != a2.length) {
            return false;
        }
        if (last == 0) {
            return true;
        }
        if (a1[--last] == a2[last]) {
            for (int i = 0; i < last; ++i) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static List<TKeyValue> compress(List<? extends KeyValue> param) {
        List<TKeyValue> tkvl = Arrays.asList(new TKeyValue[param.size()]);
        if (param.size() > 0) {
            tkvl.set(0, new TKeyValue(((Key)param.get(0).getKey()).toThrift(), ByteBuffer.wrap(((Value)param.get(0).getValue()).get())));
        }
        for (int i = param.size() - 1; i > 0; --i) {
            Key prevKey = (Key)param.get(i - 1).getKey();
            KeyValue kv = param.get(i);
            Key key = (Key)kv.getKey();
            TKey newKey = null;
            if (Key.isEqual(prevKey.row, key.row)) {
                newKey = key.toThrift();
                newKey.row = null;
            }
            if (Key.isEqual(prevKey.colFamily, key.colFamily)) {
                if (newKey == null) {
                    newKey = key.toThrift();
                }
                newKey.colFamily = null;
            }
            if (Key.isEqual(prevKey.colQualifier, key.colQualifier)) {
                if (newKey == null) {
                    newKey = key.toThrift();
                }
                newKey.colQualifier = null;
            }
            if (Key.isEqual(prevKey.colVisibility, key.colVisibility)) {
                if (newKey == null) {
                    newKey = key.toThrift();
                }
                newKey.colVisibility = null;
            }
            if (newKey == null) {
                newKey = key.toThrift();
            }
            tkvl.set(i, new TKeyValue(newKey, ByteBuffer.wrap(((Value)kv.getValue()).get())));
        }
        return tkvl;
    }

    public static void decompress(List<TKeyValue> param) {
        for (int i = 1; i < param.size(); ++i) {
            TKey prevKey = param.get((int)(i - 1)).key;
            TKey key = param.get((int)i).key;
            if (key.row == null) {
                key.row = prevKey.row;
            }
            if (key.colFamily == null) {
                key.colFamily = prevKey.colFamily;
            }
            if (key.colQualifier == null) {
                key.colQualifier = prevKey.colQualifier;
            }
            if (key.colVisibility != null) continue;
            key.colVisibility = prevKey.colVisibility;
        }
    }

    byte[] getRowBytes() {
        return this.row;
    }

    byte[] getColFamily() {
        return this.colFamily;
    }

    byte[] getColQualifier() {
        return this.colQualifier;
    }

    byte[] getColVisibility() {
        return this.colVisibility;
    }

    public TKey toThrift() {
        return new TKey(ByteBuffer.wrap(this.row), ByteBuffer.wrap(this.colFamily), ByteBuffer.wrap(this.colQualifier), ByteBuffer.wrap(this.colVisibility), this.timestamp);
    }

    public Object clone() throws CloneNotSupportedException {
        Key r = (Key)super.clone();
        r.row = Arrays.copyOf(this.row, this.row.length);
        r.colFamily = Arrays.copyOf(this.colFamily, this.colFamily.length);
        r.colQualifier = Arrays.copyOf(this.colQualifier, this.colQualifier.length);
        r.colVisibility = Arrays.copyOf(this.colVisibility, this.colVisibility.length);
        return r;
    }
}

