/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile.bcfile;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.file.rfile.bcfile.BCFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;

public class PrintInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMetaBlockInfo(Configuration conf, FileSystem fs, Path path) throws IOException {
        FSDataInputStream fsin = fs.open(path);
        try (BCFile.Reader bcfr = null;){
            bcfr = new BCFile.Reader(fsin, fs.getFileStatus(path).getLen(), conf, SiteConfiguration.getInstance(DefaultConfiguration.getInstance()));
            Set<Map.Entry<String, BCFile.MetaIndexEntry>> es = bcfr.metaIndex.index.entrySet();
            for (Map.Entry<String, BCFile.MetaIndexEntry> entry : es) {
                PrintStream out = System.out;
                out.println("Meta block     : " + entry.getKey());
                out.println("      Raw size             : " + String.format("%,d", entry.getValue().getRegion().getRawSize()) + " bytes");
                out.println("      Compressed size      : " + String.format("%,d", entry.getValue().getRegion().getCompressedSize()) + " bytes");
                out.println("      Compression type     : " + entry.getValue().getCompressionAlgorithm().getName());
                out.println();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        FileSystem hadoopFs = FileSystem.get((Configuration)conf);
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path path = new Path(args[0]);
        Object fs = args[0].contains(":") ? path.getFileSystem(conf) : (hadoopFs.exists(path) ? hadoopFs : localFs);
        PrintInfo.printMetaBlockInfo(conf, fs, path);
    }
}

