/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

public class OrIterator
implements SortedKeyValueIterator<Key, Value> {
    private TermSource currentTerm;
    private ArrayList<TermSource> sources;
    private PriorityQueue<TermSource> sorted = new PriorityQueue(5);
    private static final Text nullText = new Text();
    private static final Key nullKey = new Key();

    public OrIterator() {
        this.sources = new ArrayList();
    }

    private OrIterator(OrIterator other, IteratorEnvironment env) {
        this.sources = new ArrayList();
        for (TermSource TS : other.sources) {
            this.sources.add(new TermSource(TS.iter.deepCopy(env), TS.term));
        }
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new OrIterator(this, env);
    }

    public void addTerm(SortedKeyValueIterator<Key, Value> source, Text term, IteratorEnvironment env) {
        this.sources.add(new TermSource(source.deepCopy(env), term));
    }

    @Override
    public final void next() throws IOException {
        if (this.currentTerm == null) {
            return;
        }
        this.currentTerm.iter.next();
        if (!this.currentTerm.iter.hasTop() || this.currentTerm.term != null && this.currentTerm.term.compareTo((BinaryComparable)this.currentTerm.iter.getTopKey().getColumnFamily()) != 0) {
            this.currentTerm = null;
        }
        if (this.sorted.size() > 0) {
            if (this.currentTerm != null) {
                this.sorted.add(this.currentTerm);
            }
            this.currentTerm = this.sorted.poll();
        }
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        if (this.sources.size() == 0) {
            this.currentTerm = null;
            return;
        }
        if (this.sources.size() == 1) {
            if (this.currentTerm == null) {
                this.currentTerm = this.sources.get(0);
            }
            Range newRange = null;
            if (range != null) {
                if (range.getStartKey() == null || range.getStartKey().getRow() == null) {
                    newRange = range;
                } else {
                    Key newKey = null;
                    newKey = range.getStartKey().getColumnQualifier() == null ? new Key(range.getStartKey().getRow(), this.currentTerm.term == null ? nullText : this.currentTerm.term) : new Key(range.getStartKey().getRow(), this.currentTerm.term == null ? nullText : this.currentTerm.term, range.getStartKey().getColumnQualifier());
                    newRange = new Range(newKey == null ? nullKey : newKey, true, range.getEndKey(), false);
                }
            }
            this.currentTerm.iter.seek(newRange, this.currentTerm.seekColfams, true);
            if (!this.currentTerm.iter.hasTop() || this.currentTerm.term != null && this.currentTerm.term.compareTo((BinaryComparable)this.currentTerm.iter.getTopKey().getColumnFamily()) != 0) {
                this.currentTerm = null;
            }
            return;
        }
        this.sorted.clear();
        if (this.currentTerm == null) {
            for (TermSource TS : this.sources) {
                TS.iter.seek(range, TS.seekColfams, true);
                if (!TS.iter.hasTop() || TS.term == null || TS.term.compareTo((BinaryComparable)TS.iter.getTopKey().getColumnFamily()) != 0) continue;
                this.sorted.add(TS);
            }
            this.currentTerm = this.sorted.poll();
            return;
        }
        TermSource TS = null;
        Iterator<TermSource> iter = this.sources.iterator();
        while (iter.hasNext()) {
            TS = iter.next();
            Range newRange = null;
            if (range != null) {
                if (range.getStartKey() == null || range.getStartKey().getRow() == null) {
                    newRange = range;
                } else {
                    Key newKey = null;
                    newKey = range.getStartKey().getColumnQualifier() == null ? new Key(range.getStartKey().getRow(), TS.term == null ? nullText : TS.term) : new Key(range.getStartKey().getRow(), TS.term == null ? nullText : TS.term, range.getStartKey().getColumnQualifier());
                    newRange = new Range(newKey == null ? nullKey : newKey, true, range.getEndKey(), false);
                }
            }
            TS.iter.seek(newRange, TS.seekColfams, true);
            if (!TS.iter.hasTop() || TS.term != null && TS.term.compareTo((BinaryComparable)TS.iter.getTopKey().getColumnFamily()) != 0) {
                iter.remove();
            }
            this.sorted.add(TS);
        }
        this.currentTerm = this.sorted.poll();
    }

    @Override
    public final Key getTopKey() {
        return this.currentTerm.iter.getTopKey();
    }

    @Override
    public final Value getTopValue() {
        return this.currentTerm.iter.getTopValue();
    }

    @Override
    public final boolean hasTop() {
        return this.currentTerm != null;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected static class TermSource
    implements Comparable<TermSource> {
        public SortedKeyValueIterator<Key, Value> iter;
        public Text term;
        public Collection<ByteSequence> seekColfams;

        public TermSource(TermSource other) {
            this.iter = other.iter;
            this.term = other.term;
            this.seekColfams = other.seekColfams;
        }

        public TermSource(SortedKeyValueIterator<Key, Value> iter, Text term) {
            this.iter = iter;
            this.term = term;
            this.seekColfams = Collections.singletonList(new ArrayByteSequence(term.getBytes(), 0, term.getLength()));
        }

        public int hashCode() {
            return Objects.hashCode(this.iter.getTopKey().getColumnQualifier());
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof TermSource && 0 == this.compareTo((TermSource)obj);
        }

        @Override
        public int compareTo(TermSource o) {
            return this.iter.getTopKey().compareColumnQualifier(o.iter.getTopKey().getColumnQualifier());
        }
    }
}

