/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security.crypto;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.crypto.CryptoModuleParameters;
import org.apache.accumulo.core.security.crypto.DefaultCryptoModuleUtils;
import org.apache.accumulo.core.security.crypto.SecretKeyEncryptionStrategy;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonCachingSecretKeyEncryptionStrategy
implements SecretKeyEncryptionStrategy {
    private static final Logger log = LoggerFactory.getLogger(NonCachingSecretKeyEncryptionStrategy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doKeyEncryptionOperation(int encryptionMode, CryptoModuleParameters params, String pathToKeyName, Path pathToKey, FileSystem fs) throws IOException {
        block20: {
            try (FilterInputStream in = null;){
                Key plaintextKey;
                if (!fs.exists(pathToKey)) {
                    if (encryptionMode == 4) {
                        log.error("There was a call to decrypt the session key but no key encryption key exists. Either restore it, reconfigure the conf file to point to it in HDFS, or throw the affected data away and begin again.");
                        throw new RuntimeException("Could not find key encryption key file in configured location in HDFS (" + pathToKeyName + ")");
                    }
                    try (FSDataOutputStream out = null;){
                        out = fs.create(pathToKey);
                        fs.setReplication(pathToKey, (short)5);
                        SecureRandom random = DefaultCryptoModuleUtils.getSecureRandom(params.getRandomNumberGenerator(), params.getRandomNumberGeneratorProvider());
                        int keyLength = params.getKeyLength();
                        byte[] newRandomKeyEncryptionKey = new byte[keyLength / 8];
                        random.nextBytes(newRandomKeyEncryptionKey);
                        out.writeInt(newRandomKeyEncryptionKey.length);
                        out.write(newRandomKeyEncryptionKey);
                        out.flush();
                    }
                }
                in = fs.open(pathToKey);
                int keyEncryptionKeyLength = ((DataInputStream)in).readInt();
                byte[] keyEncryptionKey = new byte[keyEncryptionKeyLength];
                ((DataInputStream)in).read(keyEncryptionKey);
                Cipher cipher = DefaultCryptoModuleUtils.getCipher(params.getAllOptions().get(Property.CRYPTO_DEFAULT_KEY_STRATEGY_CIPHER_SUITE.getKey()));
                try {
                    cipher.init(encryptionMode, new SecretKeySpec(keyEncryptionKey, params.getAlgorithmName()));
                }
                catch (InvalidKeyException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                    throw new RuntimeException(e);
                }
                if (4 == encryptionMode) {
                    try {
                        plaintextKey = cipher.unwrap(params.getEncryptedKey(), params.getAlgorithmName(), 3);
                        params.setPlaintextKey(plaintextKey.getEncoded());
                        break block20;
                    }
                    catch (InvalidKeyException e) {
                        log.error("{}", (Object)e.getMessage(), (Object)e);
                        throw new RuntimeException(e);
                    }
                    catch (NoSuchAlgorithmException e) {
                        log.error("{}", (Object)e.getMessage(), (Object)e);
                        throw new RuntimeException(e);
                    }
                }
                plaintextKey = new SecretKeySpec(params.getPlaintextKey(), params.getAlgorithmName());
                try {
                    byte[] encryptedSecretKey = cipher.wrap(plaintextKey);
                    params.setEncryptedKey(encryptedSecretKey);
                    params.setOpaqueKeyEncryptionKeyID(pathToKeyName);
                }
                catch (InvalidKeyException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                    throw new RuntimeException(e);
                }
                catch (IllegalBlockSizeException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private String getFullPathToKey(CryptoModuleParameters params) {
        String pathToKeyName = params.getAllOptions().get(Property.CRYPTO_DEFAULT_KEY_STRATEGY_KEY_LOCATION.getKey());
        String instanceDirectory = params.getAllOptions().get(Property.INSTANCE_DFS_DIR.getKey());
        if (pathToKeyName == null) {
            pathToKeyName = Property.CRYPTO_DEFAULT_KEY_STRATEGY_KEY_LOCATION.getDefaultValue();
        }
        if (instanceDirectory == null) {
            instanceDirectory = Property.INSTANCE_DFS_DIR.getDefaultValue();
        }
        if (!pathToKeyName.startsWith("/")) {
            pathToKeyName = "/" + pathToKeyName;
        }
        String fullPath = instanceDirectory + pathToKeyName;
        return fullPath;
    }

    @Override
    public CryptoModuleParameters encryptSecretKey(CryptoModuleParameters params) {
        String hdfsURI = params.getAllOptions().get(Property.INSTANCE_DFS_URI.getKey());
        if (hdfsURI == null) {
            hdfsURI = Property.INSTANCE_DFS_URI.getDefaultValue();
        }
        String fullPath = this.getFullPathToKey(params);
        Path pathToKey = new Path(fullPath);
        try {
            FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
            this.doKeyEncryptionOperation(3, params, fullPath, pathToKey, fs);
        }
        catch (IOException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        return params;
    }

    @Override
    public CryptoModuleParameters decryptSecretKey(CryptoModuleParameters params) {
        String hdfsURI = params.getAllOptions().get(Property.INSTANCE_DFS_URI.getKey());
        if (hdfsURI == null) {
            hdfsURI = Property.INSTANCE_DFS_URI.getDefaultValue();
        }
        String pathToKeyName = this.getFullPathToKey(params);
        Path pathToKey = new Path(pathToKeyName);
        try {
            FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
            this.doKeyEncryptionOperation(4, params, pathToKeyName, pathToKey, fs);
        }
        catch (IOException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        return params;
    }
}

