/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mrunit.types.Pair;

public class MapOutputShuffler<K, V> {
    private final Configuration configuration;
    private final Comparator<K> outputKeyComparator;
    private final Comparator<K> outputValueGroupingComparator;

    public MapOutputShuffler(Configuration configuration, Comparator<K> outputKeyComparator, Comparator<K> outputValueGroupingComparator) {
        this.configuration = configuration;
        this.outputKeyComparator = outputKeyComparator;
        this.outputValueGroupingComparator = outputValueGroupingComparator;
    }

    public List<Pair<K, List<V>>> shuffle(List<Pair<K, V>> mapOutputs) {
        if (mapOutputs.isEmpty()) {
            return Collections.emptyList();
        }
        JobConf conf = new JobConf(this.configuration != null ? this.configuration : new Configuration());
        K firstKey = mapOutputs.get(0).getFirst();
        conf.setMapOutputKeyClass(firstKey.getClass());
        Object keyOrderComparator = this.outputKeyComparator == null ? conf.getOutputKeyComparator() : this.outputKeyComparator;
        Object keyGroupComparator = this.outputValueGroupingComparator == null ? conf.getOutputValueGroupingComparator() : this.outputValueGroupingComparator;
        Collections.sort(mapOutputs, new Comparator<Pair<K, V>>((Comparator)keyOrderComparator){
            final /* synthetic */ Comparator val$keyOrderComparator;
            {
                this.val$keyOrderComparator = comparator;
            }

            @Override
            public int compare(Pair<K, V> o1, Pair<K, V> o2) {
                return this.val$keyOrderComparator.compare(o1.getFirst(), o2.getFirst());
            }
        });
        LinkedHashMap groupedByKey = new LinkedHashMap();
        ArrayList<Pair<K, V>> groupedKeyList = null;
        Pair<K, V> previous = null;
        for (Pair<K, V> mapOutput : mapOutputs) {
            if (previous == null || keyGroupComparator.compare(previous.getFirst(), mapOutput.getFirst()) != 0) {
                groupedKeyList = new ArrayList<Pair<K, V>>();
                groupedByKey.put(mapOutput.getFirst(), groupedKeyList);
            }
            groupedKeyList.add(mapOutput);
            previous = mapOutput;
        }
        ArrayList<Pair<K, List<V>>> outputKeyValuesList = new ArrayList<Pair<K, List<V>>>();
        for (Map.Entry groupedByKeyEntry : groupedByKey.entrySet()) {
            ArrayList valuesList = new ArrayList();
            for (Pair pair : (List)groupedByKeyEntry.getValue()) {
                valuesList.add(pair.getSecond());
            }
            outputKeyValuesList.add(new Pair(groupedByKeyEntry.getKey(), valuesList));
        }
        return outputKeyValuesList;
    }
}

