/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mrunit.MapReduceDriver;
import org.apache.hadoop.mrunit.TestDriver;
import org.apache.hadoop.mrunit.internal.counters.CounterWrapper;
import org.apache.hadoop.mrunit.internal.util.ArgumentChecker;
import org.apache.hadoop.mrunit.types.Pair;

public class PipelineMapReduceDriver<K1, V1, K2, V2>
extends TestDriver<K2, V2, PipelineMapReduceDriver<K1, V1, K2, V2>> {
    public static final Log LOG = LogFactory.getLog(PipelineMapReduceDriver.class);
    private List<Pair<Mapper, Reducer>> mapReducePipeline;
    private final List<Pair<K1, V1>> inputList;
    private Counters counters;
    protected Path mapInputPath = new Path("somefile");

    public PipelineMapReduceDriver(List<Pair<Mapper, Reducer>> pipeline) {
        this();
        this.mapReducePipeline = ArgumentChecker.returnNonNull(pipeline);
    }

    public PipelineMapReduceDriver() {
        this.mapReducePipeline = new ArrayList<Pair<Mapper, Reducer>>();
        this.inputList = new ArrayList<Pair<K1, V1>>();
        this.setCounters(new Counters());
    }

    public Counters getCounters() {
        return this.counters;
    }

    public void setCounters(Counters ctrs) {
        this.counters = ctrs;
        this.counterWrapper = new CounterWrapper(ctrs);
    }

    public PipelineMapReduceDriver<K1, V1, K2, V2> withCounters(Counters ctrs) {
        this.setCounters(ctrs);
        return this;
    }

    public void addMapReduce(Mapper m, Reducer r) {
        this.mapReducePipeline.add(new Pair<Mapper, Reducer>(m, r));
    }

    public void addMapReduce(Pair<Mapper, Reducer> p) {
        this.mapReducePipeline.add(ArgumentChecker.returnNonNull(p));
    }

    public PipelineMapReduceDriver<K1, V1, K2, V2> withMapReduce(Mapper m, Reducer r) {
        this.addMapReduce(m, r);
        return this;
    }

    public PipelineMapReduceDriver<K1, V1, K2, V2> withMapReduce(Pair<Mapper, Reducer> p) {
        this.addMapReduce(p);
        return this;
    }

    public List<Pair<Mapper, Reducer>> getMapReducePipeline() {
        return new ArrayList<Pair<Mapper, Reducer>>(this.mapReducePipeline);
    }

    public void addInput(K1 key, V1 val) {
        this.inputList.add(this.copyPair(key, val));
    }

    public void addAll(List<Pair<K1, V1>> inputs) {
        for (Pair<K1, V1> input : inputs) {
            this.addInput(input);
        }
    }

    public PipelineMapReduceDriver<K1, V1, K2, V2> withInput(K1 key, V1 val) {
        this.addInput(key, val);
        return this;
    }

    public void addInput(Pair<K1, V1> input) {
        this.addInput(input.getFirst(), input.getSecond());
    }

    public PipelineMapReduceDriver<K1, V1, K2, V2> withInput(Pair<K1, V1> input) {
        this.addInput(input);
        return this;
    }

    @Deprecated
    public void addInputFromString(String input) {
        this.addInput(PipelineMapReduceDriver.parseTabbedPair(input));
    }

    @Deprecated
    public PipelineMapReduceDriver<K1, V1, K2, V2> withInputFromString(String input) {
        this.addInputFromString(input);
        return this;
    }

    public PipelineMapReduceDriver<K1, V1, K2, V2> withAll(List<Pair<K1, V1>> inputRecords) {
        this.addAll(inputRecords);
        return this;
    }

    public Path getMapInputPath() {
        return this.mapInputPath;
    }

    public void setMapInputPath(Path mapInputPath) {
        this.mapInputPath = mapInputPath;
    }

    public final PipelineMapReduceDriver<K1, V1, K2, V2> withMapInputPath(Path mapInputPath) {
        this.setMapInputPath(mapInputPath);
        return this;
    }

    @Override
    public List<Pair<K2, V2>> run() throws IOException {
        List<Pair<Object, Object>> inputs = this.inputList;
        if (inputs.isEmpty()) {
            throw new IllegalStateException("No input was provided");
        }
        if (this.mapReducePipeline.isEmpty()) {
            throw new IllegalStateException("No Mappers or Reducers in pipeline");
        }
        if (this.driverReused()) {
            throw new IllegalStateException("Driver reuse not allowed");
        }
        this.setUsedOnceStatus();
        for (Pair<Mapper, Reducer> job : this.mapReducePipeline) {
            MapReduceDriver mrDriver = MapReduceDriver.newMapReduceDriver(job.getFirst(), job.getSecond());
            mrDriver.setCounters(this.getCounters());
            mrDriver.setConfiguration(this.getConfiguration());
            mrDriver.setMapInputPath(this.mapInputPath);
            for (Pair<K2, V2> input : inputs) {
                mrDriver.addInput(input);
            }
            inputs = mrDriver.run();
        }
        return inputs;
    }

    public static <K1, V1, K2, V2> PipelineMapReduceDriver<K1, V1, K2, V2> newPipelineMapReduceDriver() {
        return new PipelineMapReduceDriver<K1, V1, K2, V2>();
    }

    public static <K1, V1, K2, V2> PipelineMapReduceDriver<K1, V1, K2, V2> newPipelineMapReduceDriver(List<Pair<Mapper, Reducer>> pipeline) {
        return new PipelineMapReduceDriver<K1, V1, K2, V2>(pipeline);
    }
}

