/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.mapreduce;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mrunit.internal.io.Serialization;
import org.apache.hadoop.mrunit.internal.output.OutputCollectable;
import org.apache.hadoop.mrunit.types.Pair;
import org.apache.hadoop.util.ReflectionUtils;
import org.mockito.Mockito;

public class MockMapreduceOutputFormat<K, V>
implements OutputCollectable<K, V> {
    private static String ATTEMPT = "attempt_000000000000_0000_m_000000_0";
    private static TaskAttemptID TASK_ID = TaskAttemptID.forName((String)ATTEMPT);
    private final File outputPath = new File(System.getProperty("java.io.tmpdir"), "mrunit-" + Math.random());
    private TaskAttemptContext taskAttemptContext;
    private RecordWriter recordWriter;
    private final InputFormat inputFormat;
    private final OutputFormat outputFormat;
    private final List<Pair<K, V>> outputs = new ArrayList<Pair<K, V>>();

    public MockMapreduceOutputFormat(Job outputFormatJob, Class<? extends OutputFormat> outputFormatClass, Class<? extends InputFormat> inputFormatClass, Job inputFormatJob, TaskAttemptContext taskAttemptContext) throws IOException {
        this.taskAttemptContext = taskAttemptContext;
        this.outputFormat = (OutputFormat)ReflectionUtils.newInstance(outputFormatClass, (Configuration)outputFormatJob.getConfiguration());
        this.inputFormat = (InputFormat)ReflectionUtils.newInstance(inputFormatClass, (Configuration)inputFormatJob.getConfiguration());
        if (this.outputPath.exists()) {
            throw new IllegalStateException("Generated the same random dir name twice: " + this.outputPath);
        }
        if (!this.outputPath.mkdir()) {
            throw new IOException("Failed to create output dir " + this.outputPath);
        }
        String output = new Path(this.outputPath.toString()).toString();
        String input = new Path(this.outputPath + "/*/*/*/*").toString();
        taskAttemptContext.getConfiguration().set("mapreduce.output.fileoutputformat.outputdir", output);
        taskAttemptContext.getConfiguration().set("mapreduce.input.fileinputformat.inputdir", input);
        taskAttemptContext.getConfiguration().set("mapred.output.dir", output);
        taskAttemptContext.getConfiguration().set("mapred.input.dir", input);
    }

    public void collect(K key, V value) throws IOException {
        try {
            if (this.recordWriter == null) {
                if (this.taskAttemptContext.getOutputKeyClass() == null) {
                    Mockito.when((Object)this.taskAttemptContext.getOutputKeyClass()).thenReturn(key.getClass());
                }
                if (this.taskAttemptContext.getOutputValueClass() == null) {
                    Mockito.when((Object)this.taskAttemptContext.getOutputValueClass()).thenReturn(value.getClass());
                }
                if (this.taskAttemptContext.getTaskAttemptID() == null) {
                    Mockito.when((Object)this.taskAttemptContext.getTaskAttemptID()).thenReturn((Object)TASK_ID);
                }
                this.recordWriter = this.outputFormat.getRecordWriter(this.taskAttemptContext);
            }
            this.recordWriter.write(key, value);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Pair<K, V>> getOutputs() throws IOException {
        try {
            this.recordWriter.close(this.taskAttemptContext);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        Serialization serialization = new Serialization(this.taskAttemptContext.getConfiguration());
        try {
            List inputSplits = this.inputFormat.getSplits((JobContext)this.taskAttemptContext);
            for (InputSplit inputSplit : inputSplits) {
                RecordReader recordReader = this.inputFormat.createRecordReader(inputSplit, this.taskAttemptContext);
                recordReader.initialize(inputSplit, this.taskAttemptContext);
                while (recordReader.nextKeyValue()) {
                    this.outputs.add(new Pair<Object, Object>(serialization.copy(recordReader.getCurrentKey()), serialization.copy(recordReader.getCurrentValue())));
                }
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        FileUtil.fullyDelete((File)this.outputPath);
        return this.outputs;
    }
}

