/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mrunit.types.Pair;

public class StringUtils {
    public static Pair<Text, Text> parseTabbedPair(String tabSeparatedPair) {
        int split = tabSeparatedPair.indexOf(9);
        if (split == -1) {
            throw new IllegalArgumentException("String pair missing a tab separator");
        }
        return new Pair<Text, Text>(new Text(tabSeparatedPair.substring(0, split)), new Text(tabSeparatedPair.substring(split + 1)));
    }

    public static List<Text> parseCommaDelimitedList(String commaDelimList) {
        ArrayList<Text> outList = new ArrayList<Text>();
        int len = commaDelimList.length();
        int curPos = 0;
        int curComma = commaDelimList.indexOf(44);
        if (curComma == -1) {
            curComma = len;
        }
        while (curPos < len) {
            outList.add(new Text(commaDelimList.substring(curPos, curComma).trim()));
            curPos = curComma + 1;
            if ((curComma = commaDelimList.indexOf(44, curPos)) != -1) continue;
            curComma = len;
        }
        return outList;
    }

    public static void formatValueList(List<?> values, StringBuilder sb) {
        sb.append("(");
        boolean first = true;
        for (Object val : values) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(val);
        }
        sb.append(")");
    }

    public static <K, V> void formatPairList(List<Pair<K, V>> pairs, StringBuilder sb) {
        sb.append("[");
        boolean first = true;
        for (Pair<K, V> p : pairs) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append("(" + p.getFirst() + ", " + p.getSecond() + ")");
        }
        sb.append("]");
    }
}

