/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mrunit.MapReduceDriverBase;
import org.apache.hadoop.mrunit.internal.counters.CounterWrapper;
import org.apache.hadoop.mrunit.internal.util.ArgumentChecker;
import org.apache.hadoop.mrunit.mapreduce.MapDriver;
import org.apache.hadoop.mrunit.mapreduce.ReduceFeeder;
import org.apache.hadoop.mrunit.mapreduce.ReducePhaseRunner;
import org.apache.hadoop.mrunit.types.KeyValueReuseList;
import org.apache.hadoop.mrunit.types.Pair;

public class MapReduceDriver<K1, V1, K2, V2, K3, V3>
extends MapReduceDriverBase<K1, V1, K2, V2, K3, V3, MapReduceDriver<K1, V1, K2, V2, K3, V3>> {
    public static final Log LOG = LogFactory.getLog(MapReduceDriver.class);
    private Mapper<K1, V1, K2, V2> myMapper;
    private Reducer<K2, V2, K3, V3> myReducer;
    private Reducer<K2, V2, K2, V2> myCombiner;
    private Counters counters;
    private Class<? extends OutputFormat> outputFormatClass;
    private Class<? extends InputFormat> inputFormatClass;

    public MapReduceDriver(Mapper<K1, V1, K2, V2> m, Reducer<K2, V2, K3, V3> r) {
        this();
        this.setMapper(m);
        this.setReducer(r);
    }

    public MapReduceDriver(Mapper<K1, V1, K2, V2> m, Reducer<K2, V2, K3, V3> r, Reducer<K2, V2, K2, V2> c) {
        this(m, r);
        this.setCombiner(c);
    }

    public MapReduceDriver() {
        this.setCounters(new Counters());
    }

    public void setMapper(Mapper<K1, V1, K2, V2> m) {
        this.myMapper = ArgumentChecker.returnNonNull(m);
    }

    public MapReduceDriver<K1, V1, K2, V2, K3, V3> withMapper(Mapper<K1, V1, K2, V2> m) {
        this.setMapper(m);
        return this;
    }

    public Mapper<K1, V1, K2, V2> getMapper() {
        return this.myMapper;
    }

    public void setReducer(Reducer<K2, V2, K3, V3> r) {
        this.myReducer = ArgumentChecker.returnNonNull(r);
    }

    public MapReduceDriver<K1, V1, K2, V2, K3, V3> withReducer(Reducer<K2, V2, K3, V3> r) {
        this.setReducer(r);
        return this;
    }

    public Reducer<K2, V2, K3, V3> getReducer() {
        return this.myReducer;
    }

    public void setCombiner(Reducer<K2, V2, K2, V2> c) {
        this.myCombiner = ArgumentChecker.returnNonNull(c);
    }

    public MapReduceDriver<K1, V1, K2, V2, K3, V3> withCombiner(Reducer<K2, V2, K2, V2> c) {
        this.setCombiner(c);
        return this;
    }

    public Reducer<K2, V2, K2, V2> getCombiner() {
        return this.myCombiner;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public void setCounters(Counters ctrs) {
        this.counters = ctrs;
        this.counterWrapper = new CounterWrapper(this.counters);
    }

    public MapReduceDriver<K1, V1, K2, V2, K3, V3> withCounters(Counters ctrs) {
        this.setCounters(ctrs);
        return this;
    }

    public MapReduceDriver<K1, V1, K2, V2, K3, V3> withOutputFormat(Class<? extends OutputFormat> outputFormatClass, Class<? extends InputFormat> inputFormatClass) {
        this.outputFormatClass = ArgumentChecker.returnNonNull(outputFormatClass);
        this.inputFormatClass = ArgumentChecker.returnNonNull(inputFormatClass);
        return this;
    }

    protected List<KeyValueReuseList<K2, V2>> sortAndGroup(List<Pair<K2, V2>> mapOutputs) {
        if (mapOutputs.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.keyValueOrderComparator == null || this.keyGroupComparator == null) {
            JobConf conf = new JobConf(this.getConfiguration());
            conf.setMapOutputKeyClass(mapOutputs.get(0).getFirst().getClass());
            if (this.keyGroupComparator == null) {
                this.keyGroupComparator = conf.getOutputValueGroupingComparator();
            }
            if (this.keyValueOrderComparator == null) {
                this.keyValueOrderComparator = conf.getOutputKeyComparator();
            }
        }
        ReduceFeeder reduceFeeder = new ReduceFeeder(this.getConfiguration());
        return reduceFeeder.sortAndGroup(mapOutputs, this.keyValueOrderComparator, this.keyGroupComparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Pair<K3, V3>> run() throws IOException {
        try {
            this.preRunChecks(this.myMapper, this.myReducer);
            this.initDistributedCache();
            List<Pair<Object, Object>> mapOutputs = new ArrayList<Pair<K2, V2>>();
            LOG.debug((Object)("Starting map phase with mapper: " + this.myMapper));
            mapOutputs.addAll(((MapDriver)((MapDriver)((MapDriver)MapDriver.newMapDriver(this.myMapper).withCounters(this.getCounters()).withConfiguration(this.getConfiguration())).withAll(this.inputList)).withMapInputPath(this.getMapInputPath())).run());
            if (this.myCombiner != null) {
                LOG.debug((Object)("Starting combine phase with combiner: " + this.myCombiner));
                mapOutputs = new ReducePhaseRunner(this.inputFormatClass, this.getConfiguration(), this.counters, this.getOutputSerializationConfiguration(), this.outputFormatClass).runReduce(this.sortAndGroup(mapOutputs), this.myCombiner);
            }
            LOG.debug((Object)("Starting reduce phase with reducer: " + this.myReducer));
            List<Pair<K3, V3>> list = new ReducePhaseRunner(this.inputFormatClass, this.getConfiguration(), this.counters, this.getOutputSerializationConfiguration(), this.outputFormatClass).runReduce(this.sortAndGroup(mapOutputs), this.myReducer);
            return list;
        }
        finally {
            this.cleanupDistributedCache();
        }
    }

    public String toString() {
        return "MapReduceDriver (0.20+) (" + this.myMapper + ", " + this.myReducer + ")";
    }

    public static <K1, V1, K2, V2, K3, V3> MapReduceDriver<K1, V1, K2, V2, K3, V3> newMapReduceDriver() {
        return new MapReduceDriver<K1, V1, K2, V2, K3, V3>();
    }

    public static <K1, V1, K2, V2, K3, V3> MapReduceDriver<K1, V1, K2, V2, K3, V3> newMapReduceDriver(Mapper<K1, V1, K2, V2> mapper, Reducer<K2, V2, K3, V3> reducer) {
        return new MapReduceDriver<K1, V1, K2, V2, K3, V3>(mapper, reducer);
    }

    public static <K1, V1, K2, V2, K3, V3> MapReduceDriver<K1, V1, K2, V2, K3, V3> newMapReduceDriver(Mapper<K1, V1, K2, V2> mapper, Reducer<K2, V2, K3, V3> reducer, Reducer<K2, V2, K2, V2> combiner) {
        return new MapReduceDriver<K1, V1, K2, V2, K3, V3>(mapper, reducer, combiner);
    }
}

