/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium;

import java.util.Arrays;
import java.util.Iterator;
import org.vertexium.util.ArrayIterable;

public class Path
implements Iterable<String> {
    private final String[] vertexIds;

    public Path(String ... vertexIds) {
        this.vertexIds = vertexIds;
    }

    public Path(Path path, String vertexId) {
        this.vertexIds = Arrays.copyOf(path.vertexIds, path.vertexIds.length + 1);
        this.vertexIds[this.vertexIds.length - 1] = vertexId;
    }

    public int length() {
        return this.vertexIds.length;
    }

    public String get(int i) {
        return this.vertexIds[i];
    }

    @Override
    public Iterator<String> iterator() {
        return new ArrayIterable<String>(this.vertexIds).iterator();
    }

    public String toString() {
        return Arrays.toString(this.vertexIds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path pathOther = (Path)o;
        if (pathOther.vertexIds.length != this.vertexIds.length) {
            return false;
        }
        for (int i = 0; i < this.vertexIds.length; ++i) {
            if (pathOther.vertexIds[i].equals(this.vertexIds[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.vertexIds);
    }
}

