/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.id;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cache2k.Cache;
import org.cache2k.CacheBuilder;
import org.cache2k.CacheSource;
import org.vertexium.id.NameSubstitutionStrategy;
import org.vertexium.id.SimpleSubstitutionUtils;

public class SimpleNameSubstitutionStrategy
implements NameSubstitutionStrategy {
    private List<DeflateItem> deflateSubstitutionList = new ArrayList<DeflateItem>();
    private final Cache<String, String> deflateCache;
    private long deflateCalls;
    private long deflateCacheMisses;
    private List<InflateItem> inflateSubstitutionList = new ArrayList<InflateItem>();
    private final Cache<String, String> inflateCache;
    private long inflateCalls;
    private long inflateCacheMisses;
    public static final String SUBS_DELIM = "\u0002";

    public SimpleNameSubstitutionStrategy() {
        this.deflateCache = CacheBuilder.newCache(String.class, String.class).name(SimpleNameSubstitutionStrategy.class, "deflateCache-" + System.identityHashCode(this)).maxSize(10000).source((CacheSource)new DeflateCacheSource()).build();
        this.inflateCache = CacheBuilder.newCache(String.class, String.class).name(SimpleNameSubstitutionStrategy.class, "inflateCache-" + System.identityHashCode(this)).maxSize(10000).source((CacheSource)new InflateCacheSource()).build();
    }

    @Override
    public void setup(Map config) {
        this.setSubstitutionList(SimpleSubstitutionUtils.getSubstitutionList(config));
    }

    @Override
    public String deflate(String value) {
        ++this.deflateCalls;
        return (String)this.deflateCache.get((Object)value);
    }

    @Override
    public String inflate(String value) {
        ++this.inflateCalls;
        return (String)this.inflateCache.get((Object)value);
    }

    public static String wrap(String str) {
        return SUBS_DELIM + str + SUBS_DELIM;
    }

    public void setSubstitutionList(List<Pair<String, String>> substitutionList) {
        this.inflateSubstitutionList.clear();
        this.deflateSubstitutionList.clear();
        for (Pair<String, String> pair : substitutionList) {
            this.inflateSubstitutionList.add(new InflateItem(SimpleNameSubstitutionStrategy.wrap((String)pair.getValue()), (String)pair.getKey()));
            this.deflateSubstitutionList.add(new DeflateItem((String)pair.getKey(), SimpleNameSubstitutionStrategy.wrap((String)pair.getValue())));
        }
    }

    public long getDeflateCalls() {
        return this.deflateCalls;
    }

    public long getDeflateCacheMisses() {
        return this.deflateCacheMisses;
    }

    public long getInflateCalls() {
        return this.inflateCalls;
    }

    public long getInflateCacheMisses() {
        return this.inflateCacheMisses;
    }

    private class DeflateCacheSource
    implements CacheSource<String, String> {
        private DeflateCacheSource() {
        }

        public String get(String value) throws Throwable {
            SimpleNameSubstitutionStrategy.this.deflateCacheMisses++;
            String deflatedVal = value;
            for (DeflateItem deflateItem : SimpleNameSubstitutionStrategy.this.deflateSubstitutionList) {
                deflatedVal = deflateItem.deflate(deflatedVal);
            }
            return deflatedVal;
        }
    }

    private static class DeflateItem {
        private final String pattern;
        private final String replacement;

        public DeflateItem(String pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        public String deflate(String value) {
            return StringUtils.replace((String)value, (String)this.pattern, (String)this.replacement);
        }
    }

    private class InflateCacheSource
    implements CacheSource<String, String> {
        private InflateCacheSource() {
        }

        public String get(String value) throws Throwable {
            SimpleNameSubstitutionStrategy.this.inflateCacheMisses++;
            String inflatedValue = value;
            for (InflateItem inflateItem : SimpleNameSubstitutionStrategy.this.inflateSubstitutionList) {
                inflatedValue = inflateItem.inflate(inflatedValue);
            }
            return inflatedValue;
        }
    }

    private static class InflateItem {
        private final String pattern;
        private final String replacement;

        public InflateItem(String pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        public String inflate(String value) {
            return StringUtils.replace((String)value, (String)this.pattern, (String)this.replacement);
        }
    }
}

