/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.query;

import java.util.Comparator;
import java.util.List;
import org.vertexium.Element;
import org.vertexium.query.QueryBase;
import org.vertexium.query.SortDirection;
import org.vertexium.util.IterableUtils;

public class SortContainersComparator<T extends Element>
implements Comparator<T> {
    private final List<QueryBase.SortContainer> sortContainers;

    public SortContainersComparator(List<QueryBase.SortContainer> sortContainers) {
        this.sortContainers = sortContainers;
    }

    @Override
    public int compare(T elem1, T elem2) {
        for (QueryBase.SortContainer sortContainer : this.sortContainers) {
            int result = this.compare(sortContainer, elem1, elem2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private int compare(QueryBase.SortContainer sortContainer, T elem1, T elem2) {
        List<Object> elem1PropertyValues = IterableUtils.toList(elem1.getPropertyValues(sortContainer.propertyName));
        List<Object> elem2PropertyValues = IterableUtils.toList(elem2.getPropertyValues(sortContainer.propertyName));
        if (elem1PropertyValues.size() > 0 && elem2PropertyValues.size() == 0) {
            return -1;
        }
        if (elem2PropertyValues.size() > 0 && elem1PropertyValues.size() == 0) {
            return 1;
        }
        for (Object elem1PropertyValue : elem1PropertyValues) {
            for (Object elem2PropertyValue : elem2PropertyValues) {
                int result = this.comparePropertyValues(elem1PropertyValue, elem2PropertyValue);
                if (result == 0) continue;
                return sortContainer.direction == SortDirection.ASCENDING ? result : -result;
            }
        }
        return 0;
    }

    private int comparePropertyValues(Object v1, Object v2) {
        if (v1.getClass() == v2.getClass() && v1 instanceof Comparable) {
            return ((Comparable)v1).compareTo(v2);
        }
        return 0;
    }
}

