/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.vertexium.Graph;
import org.vertexium.GraphConfiguration;
import org.vertexium.VertexiumException;
import org.vertexium.util.Preconditions;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class ConfigurationUtils {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(ConfigurationUtils.class);

    public static <T> T createProvider(Graph graph, GraphConfiguration config, String propPrefix, String defaultProvider) throws VertexiumException {
        String implClass = config.getString(propPrefix, defaultProvider);
        Preconditions.checkNotNull(implClass, "createProvider could not find " + propPrefix + " configuration item");
        return ConfigurationUtils.createProvider(implClass, graph, config);
    }

    public static <T> T createProvider(String className, Graph graph, GraphConfiguration config) throws VertexiumException {
        Preconditions.checkNotNull(className, "className is required");
        className = className.trim();
        LOGGER.debug("creating provider '%s'", className);
        Class<Graph> graphClass = Graph.class;
        Class<GraphConfiguration> graphConfigurationClass = GraphConfiguration.class;
        try {
            Class<?> clazz = Class.forName(className);
            try {
                try {
                    Constructor<?> constructor = clazz.getConstructor(graphClass);
                    return (T)constructor.newInstance(graph);
                }
                catch (NoSuchMethodException ignore1) {
                    try {
                        Constructor<?> constructor = clazz.getConstructor(graphClass, graphConfigurationClass);
                        return (T)constructor.newInstance(graph, config);
                    }
                    catch (NoSuchMethodException ignore2) {
                        try {
                            Constructor<?> constructor = clazz.getConstructor(graphConfigurationClass);
                            return (T)constructor.newInstance(config);
                        }
                        catch (NoSuchMethodException ignore3) {
                            try {
                                Constructor<?> constructor = clazz.getConstructor(Map.class);
                                return (T)constructor.newInstance(config.getConfig());
                            }
                            catch (NoSuchMethodException ignoreInner) {
                                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                                return (T)constructor.newInstance(new Object[0]);
                            }
                        }
                    }
                }
            }
            catch (IllegalArgumentException e) {
                StringBuilder possibleMatches = new StringBuilder();
                for (Constructor<?> s : clazz.getConstructors()) {
                    possibleMatches.append(s.toGenericString());
                    possibleMatches.append(", ");
                }
                throw new VertexiumException("Invalid constructor for " + className + ". Expected <init>(" + graphConfigurationClass.getName() + "). Found: " + possibleMatches, e);
            }
        }
        catch (NoSuchMethodException e) {
            throw new VertexiumException("Provider must have a single argument constructor taking a " + graphConfigurationClass.getName(), e);
        }
        catch (ClassNotFoundException e) {
            throw new VertexiumException("No provider found with class name " + className, e);
        }
        catch (Exception e) {
            throw new VertexiumException(e);
        }
    }

    public static Map<String, String> loadConfig(List<String> configFileNames, String configPropertyPrefix) throws IOException {
        Map<String, String> props = ConfigurationUtils.loadFiles(configFileNames);
        ConfigurationUtils.resolvePropertyReferences(props);
        return ConfigurationUtils.stripPrefix(props, configPropertyPrefix);
    }

    private static Map<String, String> loadFiles(List<String> configFileNames) throws IOException {
        Properties props = new Properties();
        for (String configFileName : configFileNames) {
            File configFile = new File(configFileName);
            if (!configFile.exists()) {
                throw new RuntimeException("Could not load config file: " + configFile.getAbsolutePath());
            }
            FileInputStream in = new FileInputStream(configFile);
            Throwable throwable = null;
            try {
                props.load(in);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)in).close();
            }
        }
        return ConfigurationUtils.propertiesToMap(props);
    }

    private static Map<String, String> stripPrefix(Map<String, String> propsMap, String configPropertyPrefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (configPropertyPrefix == null) {
            result.putAll(propsMap);
        } else {
            for (Map.Entry<String, String> p : propsMap.entrySet()) {
                if (p.getKey().startsWith(configPropertyPrefix + ".")) {
                    result.put(p.getKey().substring((configPropertyPrefix + ".").length()), p.getValue());
                    continue;
                }
                if (!p.getKey().startsWith(configPropertyPrefix)) continue;
                result.put(p.getKey().substring(configPropertyPrefix.length()), p.getValue());
            }
        }
        return result;
    }

    private static Map<String, String> propertiesToMap(Properties props) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            results.put("" + entry.getKey(), "" + entry.getValue());
        }
        return results;
    }

    private static void resolvePropertyReferences(Map<String, String> config) {
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String entryValue = entry.getValue();
            if (StringUtils.isBlank((CharSequence)entryValue)) continue;
            entry.setValue(StrSubstitutor.replace((Object)entryValue, config));
        }
    }
}

