/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copy(input, output, 0L, Long.MAX_VALUE);
    }

    public static long copy(InputStream input, OutputStream output, long offset, long limit) throws IOException {
        int n;
        long skipResult;
        byte[] buffer = new byte[4096];
        long count = 0L;
        if (offset > 0L && (skipResult = input.skip(offset)) < offset) {
            return 0L;
        }
        long len = limit;
        while (-1 != (n = input.read(buffer, 0, (int)Math.min((long)buffer.length, len)))) {
            output.write(buffer, 0, n);
            count += (long)n;
            if ((len -= (long)n) != 0L) continue;
            break;
        }
        return count;
    }

    public static byte[] toBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy(in, out);
        return out.toByteArray();
    }

    public static byte[] toBytes(InputStream in, long offset, long limit) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy(in, out, offset, limit);
        return out.toByteArray();
    }

    public static String toString(InputStream in) throws IOException {
        return new String(IOUtils.toBytes(in));
    }

    public static String toString(InputStream in, long offset, long limit) throws IOException {
        return new String(IOUtils.toBytes(in, offset, limit));
    }
}

