/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.inmemory;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.vertexium.Authorizations;
import org.vertexium.HistoricalPropertyValue;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.inmemory.InMemoryElement;
import org.vertexium.inmemory.InMemoryGraph;
import org.vertexium.inmemory.mutations.AddPropertyMetadataMutation;
import org.vertexium.inmemory.mutations.AddPropertyValueMutation;
import org.vertexium.inmemory.mutations.AlterEdgeLabelMutation;
import org.vertexium.inmemory.mutations.AlterVisibilityMutation;
import org.vertexium.inmemory.mutations.ElementTimestampMutation;
import org.vertexium.inmemory.mutations.MarkHiddenMutation;
import org.vertexium.inmemory.mutations.MarkPropertyHiddenMutation;
import org.vertexium.inmemory.mutations.MarkPropertyVisibleMutation;
import org.vertexium.inmemory.mutations.MarkVisibleMutation;
import org.vertexium.inmemory.mutations.Mutation;
import org.vertexium.inmemory.mutations.PropertyMutation;
import org.vertexium.inmemory.mutations.SoftDeleteMutation;
import org.vertexium.inmemory.mutations.SoftDeletePropertyMutation;
import org.vertexium.property.MutablePropertyImpl;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.property.StreamingPropertyValueRef;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.FilterIterable;
import org.vertexium.util.IncreasingTime;
import org.vertexium.util.LookAheadIterable;

public abstract class InMemoryTableElement<TElement extends InMemoryElement>
implements Serializable {
    private final String id;
    private TreeSet<Mutation> mutations = new TreeSet();

    protected InMemoryTableElement(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void addAll(Mutation ... newMutations) {
        Collections.addAll(this.mutations, newMutations);
    }

    public long getFirstTimestamp() {
        return this.findFirstMutation(ElementTimestampMutation.class).getTimestamp();
    }

    protected <T extends Mutation> T findLastMutation(Class<T> clazz) {
        Mutation last = null;
        for (Mutation m : this.mutations) {
            if (!clazz.isAssignableFrom(m.getClass())) continue;
            last = m;
        }
        return (T)last;
    }

    protected <T extends Mutation> T findFirstMutation(Class<T> clazz) {
        for (Mutation m : this.mutations) {
            if (!clazz.isAssignableFrom(m.getClass())) continue;
            return (T)m;
        }
        return null;
    }

    protected <T extends Mutation> Iterable<T> findMutations(final Class<T> clazz) {
        return new ConvertingIterable<Mutation, T>((Iterable)new FilterIterable<Mutation>(this.mutations){

            protected boolean isIncluded(Mutation m) {
                return clazz.isAssignableFrom(m.getClass());
            }
        }){

            protected T convert(Mutation o) {
                return o;
            }
        };
    }

    public Visibility getVisibility() {
        return this.findLastMutation(AlterVisibilityMutation.class).getNewVisibility();
    }

    public long getTimestamp() {
        return this.findLastMutation(ElementTimestampMutation.class).getTimestamp();
    }

    private List<PropertyMutation> findPropertyMutations(Property p) {
        return this.findPropertyMutations(p.getKey(), p.getName(), p.getVisibility());
    }

    public Property deleteProperty(String key, String name, Authorizations authorizations) {
        return this.deleteProperty(key, name, null, authorizations);
    }

    public Property getProperty(String key, String name, Visibility visibility, Authorizations authorizations) {
        List<PropertyMutation> propertyMutations = this.findPropertyMutations(key, name, visibility);
        if (propertyMutations == null || propertyMutations.size() == 0) {
            return null;
        }
        return this.toProperty(propertyMutations, true, authorizations);
    }

    public Property deleteProperty(String key, String name, Visibility visibility, Authorizations authorizations) {
        Property p = this.getProperty(key, name, visibility, authorizations);
        if (p != null) {
            this.deleteProperty(p);
        }
        return p;
    }

    protected void deleteProperty(Property p) {
        List<PropertyMutation> propertyMutations = this.findPropertyMutations(p);
        this.mutations.removeAll(propertyMutations);
    }

    private List<PropertyMutation> findPropertyMutations(String key, String name, Visibility visibility) {
        ArrayList<PropertyMutation> results = new ArrayList<PropertyMutation>();
        for (Mutation m : this.mutations) {
            if (!(m instanceof PropertyMutation)) continue;
            PropertyMutation pm = (PropertyMutation)m;
            if (key != null && !pm.getPropertyKey().equals(key) || name != null && !pm.getPropertyName().equals(name) || visibility != null && !pm.getPropertyVisibility().equals((Object)visibility)) continue;
            results.add(pm);
        }
        return results;
    }

    public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(String key, String name, Visibility visibility, Long startTime, Long endTime, Authorizations authorizations) {
        List<PropertyMutation> propertyMutations = this.findPropertyMutations(key, name, visibility);
        ArrayList<HistoricalPropertyValue> historicalPropertyValues = new ArrayList<HistoricalPropertyValue>();
        HashMap currentPropertyBuilders = Maps.newHashMap();
        HashSet hiddenVisibilities = new HashSet();
        for (PropertyMutation m : propertyMutations) {
            String propertyIdentifier = m.getPropertyKey() + m.getPropertyName();
            HistoricalPropertyValue.HistoricalPropertyValueBuilder builder = (HistoricalPropertyValue.HistoricalPropertyValueBuilder)currentPropertyBuilders.get(propertyIdentifier);
            if (builder == null) {
                builder = new HistoricalPropertyValue.HistoricalPropertyValueBuilder(m.getPropertyKey(), m.getPropertyName(), m.getTimestamp());
                currentPropertyBuilders.put(propertyIdentifier, builder);
            }
            if (startTime != null && m.getTimestamp() < startTime || endTime != null && m.getTimestamp() > endTime || !InMemoryTableElement.canRead(m.getVisibility(), authorizations) || m.getVisibility() != null && m.getPropertyVisibility().getVisibilityString().matches("(.*)WORKSPACE(.*)")) continue;
            if (m instanceof SoftDeletePropertyMutation) {
                builder.isDeleted(Boolean.valueOf(true));
                builder.timestamp(m.getTimestamp());
                historicalPropertyValues.add(builder.build());
                continue;
            }
            if (m instanceof AddPropertyMetadataMutation) {
                builder.metadata(((AddPropertyMetadataMutation)m).getMetadata());
                builder.timestamp(m.getTimestamp());
                continue;
            }
            if (m instanceof MarkPropertyHiddenMutation || m instanceof MarkPropertyVisibleMutation) continue;
            if (m instanceof AddPropertyValueMutation) {
                HistoricalPropertyValue last;
                AddPropertyValueMutation apvm = (AddPropertyValueMutation)m;
                Object value = apvm.getValue();
                value = this.loadIfStreamingPropertyValue(value, m.getTimestamp());
                builder.propertyVisibility(m.getPropertyVisibility()).timestamp(m.getTimestamp()).value(value).metadata(apvm.getMetadata()).hiddenVisibilities(hiddenVisibilities).isDeleted(Boolean.valueOf(false));
                if (historicalPropertyValues.size() > 0 && propertyIdentifier.equals((last = (HistoricalPropertyValue)historicalPropertyValues.get(historicalPropertyValues.size() - 1)).getPropertyKey() + last.getPropertyName()) && last.isDeleted()) {
                    historicalPropertyValues.remove(historicalPropertyValues.size() - 1);
                }
                historicalPropertyValues.add(builder.build());
                continue;
            }
            throw new VertexiumException("Unhandled PropertyMutation: " + m.getClass().getName());
        }
        Collections.reverse(historicalPropertyValues);
        return historicalPropertyValues;
    }

    public Iterable<Property> getProperties(final boolean includeHidden, Long endTime, final Authorizations authorizations) {
        final TreeMap<String, ArrayList<PropertyMutation>> propertiesMutations = new TreeMap<String, ArrayList<PropertyMutation>>();
        for (PropertyMutation m : this.findMutations(PropertyMutation.class)) {
            if (endTime != null && m.getTimestamp() > endTime) continue;
            String mapKey = this.toMapKey(m);
            ArrayList<PropertyMutation> propertyMutations = (ArrayList<PropertyMutation>)propertiesMutations.get(mapKey);
            if (propertyMutations == null) {
                propertyMutations = new ArrayList<PropertyMutation>();
                propertiesMutations.put(mapKey, propertyMutations);
            }
            propertyMutations.add(m);
        }
        return new LookAheadIterable<List<PropertyMutation>, Property>(){

            protected boolean isIncluded(List<PropertyMutation> src, Property property) {
                return property != null;
            }

            protected Property convert(List<PropertyMutation> propertyMutations) {
                return InMemoryTableElement.this.toProperty(propertyMutations, includeHidden, authorizations);
            }

            protected Iterator<List<PropertyMutation>> createIterator() {
                return propertiesMutations.values().iterator();
            }
        };
    }

    private Property toProperty(List<PropertyMutation> propertyMutations, boolean includeHidden, Authorizations authorizations) {
        String propertyKey = null;
        String propertyName = null;
        Object value = null;
        Metadata metadata = null;
        long timestamp = 0L;
        HashSet<Visibility> hiddenVisibilities = new HashSet<Visibility>();
        Visibility visibility = null;
        boolean softDeleted = false;
        boolean hidden = false;
        for (PropertyMutation m : propertyMutations) {
            if (!InMemoryTableElement.canRead(m.getVisibility(), authorizations)) continue;
            propertyKey = m.getPropertyKey();
            propertyName = m.getPropertyName();
            visibility = m.getPropertyVisibility();
            if (m.getTimestamp() > timestamp) {
                timestamp = m.getTimestamp();
            }
            if (m instanceof AddPropertyValueMutation) {
                AddPropertyValueMutation apvm = (AddPropertyValueMutation)m;
                value = apvm.getValue();
                metadata = apvm.getMetadata();
                softDeleted = false;
                continue;
            }
            if (m instanceof AddPropertyMetadataMutation) {
                AddPropertyMetadataMutation apmm = (AddPropertyMetadataMutation)m;
                metadata = apmm.getMetadata();
                continue;
            }
            if (m instanceof SoftDeletePropertyMutation) {
                softDeleted = true;
                continue;
            }
            if (m instanceof MarkPropertyHiddenMutation) {
                hidden = true;
                hiddenVisibilities.add(m.getVisibility());
                continue;
            }
            if (m instanceof MarkPropertyVisibleMutation) {
                hidden = false;
                hiddenVisibilities.remove(m.getVisibility());
                continue;
            }
            throw new VertexiumException("Unhandled PropertyMutation: " + m.getClass().getName());
        }
        if (softDeleted) {
            return null;
        }
        if (!includeHidden && hidden) {
            return null;
        }
        if (propertyKey == null) {
            return null;
        }
        value = this.loadIfStreamingPropertyValue(value, timestamp);
        return new MutablePropertyImpl(propertyKey, propertyName, value, metadata, Long.valueOf(timestamp), hiddenVisibilities, visibility);
    }

    private Object loadIfStreamingPropertyValue(Object value, long timestamp) {
        if (value instanceof StreamingPropertyValueRef) {
            value = this.loadStreamingPropertyValue((StreamingPropertyValueRef)value, timestamp);
        }
        return value;
    }

    protected StreamingPropertyValue loadStreamingPropertyValue(StreamingPropertyValueRef<?> streamingPropertyValueRef, long timestamp) {
        return streamingPropertyValueRef.toStreamingPropertyValue(null, timestamp);
    }

    private String toMapKey(PropertyMutation m) {
        return m.getPropertyName() + m.getPropertyKey() + m.getPropertyVisibility().getVisibilityString();
    }

    public void appendSoftDeleteMutation(Long timestamp) {
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.mutations.add(new SoftDeleteMutation(timestamp));
    }

    public void appendMarkHiddenMutation(Visibility visibility) {
        long timestamp = IncreasingTime.currentTimeMillis();
        this.mutations.add(new MarkHiddenMutation(timestamp, visibility));
    }

    public void appendMarkVisibleMutation(Visibility visibility) {
        long timestamp = IncreasingTime.currentTimeMillis();
        this.mutations.add(new MarkVisibleMutation(timestamp, visibility));
    }

    public Property appendMarkPropertyHiddenMutation(String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Property prop = this.getProperty(key, name, propertyVisibility, authorizations);
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.mutations.add(new MarkPropertyHiddenMutation(key, name, propertyVisibility, timestamp, visibility));
        return prop;
    }

    public Property appendMarkPropertyVisibleMutation(String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Property prop = this.getProperty(key, name, propertyVisibility, authorizations);
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.mutations.add(new MarkPropertyVisibleMutation(key, name, propertyVisibility, timestamp, visibility));
        return prop;
    }

    public void appendSoftDeletePropertyMutation(String key, String name, Visibility propertyVisibility, Long timestamp) {
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.mutations.add(new SoftDeletePropertyMutation(timestamp, key, name, propertyVisibility));
    }

    public void appendAlterVisibilityMutation(Visibility newVisibility) {
        long timestamp = IncreasingTime.currentTimeMillis();
        this.mutations.add(new AlterVisibilityMutation(timestamp, newVisibility));
    }

    public void appendAddPropertyValueMutation(String key, String name, Object value, Metadata metadata, Visibility visibility, Long timestamp) {
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.mutations.add(new AddPropertyValueMutation(timestamp, key, name, value, metadata, visibility));
    }

    public void appendAddPropertyMetadataMutation(String key, String name, Metadata metadata, Visibility visibility, Long timestamp) {
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.mutations.add(new AddPropertyMetadataMutation((long)timestamp, key, name, metadata, visibility));
    }

    public void appendAlterEdgeLabelMutation(long timestamp, String newEdgeLabel) {
        this.mutations.add(new AlterEdgeLabelMutation(timestamp, newEdgeLabel));
    }

    protected List<Mutation> getFilteredMutations(boolean includeHidden, Long endTime, Authorizations authorizations) {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        for (Mutation m : this.mutations) {
            if (!InMemoryTableElement.canRead(m.getVisibility(), authorizations) || endTime != null && m.getTimestamp() > endTime || includeHidden && (m instanceof MarkHiddenMutation || m instanceof MarkPropertyHiddenMutation)) continue;
            mutations.add(m);
        }
        return mutations;
    }

    public boolean canRead(Authorizations authorizations) {
        if (this.getVisibility().getVisibilityString().length() == 0) {
            return true;
        }
        return authorizations.canRead(this.getVisibility());
    }

    private static boolean canRead(Visibility visibility, Authorizations authorizations) {
        if (visibility.getVisibilityString().length() == 0) {
            return true;
        }
        return authorizations.canRead(visibility);
    }

    public Set<Visibility> getHiddenVisibilities() {
        HashSet<Visibility> results = new HashSet<Visibility>();
        for (Mutation m : this.mutations) {
            if (m instanceof MarkHiddenMutation) {
                results.add(m.getVisibility());
                continue;
            }
            if (!(m instanceof MarkVisibleMutation)) continue;
            results.remove(m.getVisibility());
        }
        return results;
    }

    public boolean isHidden(Authorizations authorizations) {
        for (Visibility visibility : this.getHiddenVisibilities()) {
            if (!authorizations.canRead(visibility)) continue;
            return true;
        }
        return false;
    }

    public TElement createElement(InMemoryGraph graph, Authorizations authorizations) {
        return this.createElement(graph, true, null, authorizations);
    }

    public final TElement createElement(InMemoryGraph graph, boolean includeHidden, Long endTime, Authorizations authorizations) {
        if (endTime != null && this.getFirstTimestamp() > endTime) {
            return null;
        }
        if (this.isDeleted(endTime, authorizations)) {
            return null;
        }
        return this.createElementInternal(graph, includeHidden, endTime, authorizations);
    }

    public boolean isDeleted(Long endTime, Authorizations authorizations) {
        boolean deleted = false;
        for (Mutation m : this.mutations) {
            if (!InMemoryTableElement.canRead(m.getVisibility(), authorizations) || endTime != null && m.getTimestamp() > endTime) continue;
            if (m instanceof SoftDeleteMutation) {
                deleted = true;
                continue;
            }
            if (!(m instanceof ElementTimestampMutation)) continue;
            deleted = false;
        }
        return deleted;
    }

    protected abstract TElement createElementInternal(InMemoryGraph var1, boolean var2, Long var3, Authorizations var4);
}

