/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.graphdb.schema.EdgeLabelDefinition;
import com.thinkaurelius.titan.graphdb.schema.PropertyKeyDefinition;
import com.thinkaurelius.titan.graphdb.schema.RelationTypeDefinition;
import com.thinkaurelius.titan.graphdb.schema.SchemaProvider;
import com.thinkaurelius.titan.graphdb.schema.VertexLabelDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchemaProvider
implements SchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultSchemaProvider.class);
    public static final DefaultSchemaProvider INSTANCE = new DefaultSchemaProvider();

    private DefaultSchemaProvider() {
    }

    public EdgeLabelDefinition getEdgeLabel(String name) {
        log.debug("Creating default edge label definition for {}", (Object)name);
        return new EdgeLabelDefinition(name, -1L, Multiplicity.MULTI, false);
    }

    public PropertyKeyDefinition getPropertyKey(String name) {
        log.debug("Creating default property key definition for {}", (Object)name);
        return new PropertyKeyDefinition(name, -1L, Cardinality.SINGLE, Object.class);
    }

    public RelationTypeDefinition getRelationType(String name) {
        log.debug("Forced null relation type {}", (Object)name, (Object)new RuntimeException());
        return null;
    }

    public VertexLabelDefinition getVertexLabel(String name) {
        log.debug("Creating default vertex label definition for {}", (Object)name);
        return new VertexLabelDefinition(name, -1L, false, false);
    }

    public static SchemaProvider asBackupProvider(SchemaProvider provider) {
        return DefaultSchemaProvider.asBackupProvider(provider, INSTANCE);
    }

    public static SchemaProvider asBackupProvider(final SchemaProvider provider, final SchemaProvider backup) {
        return new SchemaProvider(){

            public EdgeLabelDefinition getEdgeLabel(String name) {
                EdgeLabelDefinition def = provider.getEdgeLabel(name);
                if (def != null) {
                    return def;
                }
                return backup.getEdgeLabel(name);
            }

            public PropertyKeyDefinition getPropertyKey(String name) {
                PropertyKeyDefinition def = provider.getPropertyKey(name);
                if (def != null) {
                    return def;
                }
                return backup.getPropertyKey(name);
            }

            public RelationTypeDefinition getRelationType(String name) {
                RelationTypeDefinition def = provider.getRelationType(name);
                if (def != null) {
                    return def;
                }
                return backup.getRelationType(name);
            }

            public VertexLabelDefinition getVertexLabel(String name) {
                VertexLabelDefinition def = provider.getVertexLabel(name);
                if (def != null) {
                    return def;
                }
                return backup.getVertexLabel(name);
            }

            public String toString() {
                return "DelegatingSchemaProvider[provider=" + provider + ",backup=" + backup + "]";
            }
        };
    }
}

