/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.thinkaurelius.titan.core.schema.SchemaInspector;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.graphdb.schema.EdgeLabelDefinition;
import com.thinkaurelius.titan.graphdb.schema.PropertyKeyDefinition;
import com.thinkaurelius.titan.graphdb.schema.RelationTypeDefinition;
import com.thinkaurelius.titan.graphdb.schema.SchemaProvider;
import com.thinkaurelius.titan.hadoop.DefaultSchemaProvider;
import com.thinkaurelius.titan.hadoop.FaunusEdgeLabel;
import com.thinkaurelius.titan.hadoop.FaunusPropertyKey;
import com.thinkaurelius.titan.hadoop.FaunusRelationType;
import com.thinkaurelius.titan.hadoop.FaunusVertexLabel;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaunusSchemaManager
implements SchemaInspector {
    private static final Logger log = LoggerFactory.getLogger(FaunusSchemaManager.class);
    private static final FaunusSchemaManager DEFAULT_MANAGER = new FaunusSchemaManager();
    private final ConcurrentMap<String, FaunusVertexLabel> vertexLabels = Maps.newConcurrentMap();
    private final ConcurrentMap<String, FaunusRelationType> relationTypes = Maps.newConcurrentMap();
    private SchemaProvider schemaProvider;
    private boolean isSchemaProviderDefault;

    private FaunusSchemaManager() {
        this(DefaultSchemaProvider.INSTANCE);
    }

    public FaunusSchemaManager(SchemaProvider provider) {
        this.setSchemaProvider(provider);
        this.initialize();
    }

    private final void initialize() {
        this.vertexLabels.put(FaunusVertexLabel.DEFAULT_VERTEXLABEL.getName(), FaunusVertexLabel.DEFAULT_VERTEXLABEL);
        this.relationTypes.put(FaunusPropertyKey.COUNT.getName(), FaunusPropertyKey.COUNT);
        this.relationTypes.put(FaunusEdgeLabel.LINK.getName(), FaunusEdgeLabel.LINK);
        this.relationTypes.put(FaunusPropertyKey.VALUE.getName(), FaunusPropertyKey.VALUE);
        this.relationTypes.put(FaunusPropertyKey.ID.getName(), FaunusPropertyKey.ID);
        this.relationTypes.put(FaunusPropertyKey._ID.getName(), FaunusPropertyKey._ID);
        this.relationTypes.put(FaunusPropertyKey.LABEL.getName(), FaunusPropertyKey.LABEL);
    }

    public void setSchemaProvider(SchemaProvider provider) {
        boolean bl = this.isSchemaProviderDefault = provider == DefaultSchemaProvider.INSTANCE;
        if (!this.isSchemaProviderDefault) {
            provider = DefaultSchemaProvider.asBackupProvider(provider);
        }
        log.debug("Set schema provider: {}", (Object)provider);
        this.schemaProvider = provider;
    }

    public void clear() {
        this.vertexLabels.clear();
        this.relationTypes.clear();
        this.initialize();
    }

    public FaunusVertexLabel getVertexLabel(String name) {
        FaunusVertexLabel vl = (FaunusVertexLabel)((Object)this.vertexLabels.get(name));
        if (vl == null) {
            this.vertexLabels.putIfAbsent(name, new FaunusVertexLabel(this.schemaProvider.getVertexLabel(name)));
            vl = (FaunusVertexLabel)((Object)this.vertexLabels.get(name));
        }
        assert (vl != null);
        return vl;
    }

    public boolean containsVertexLabel(String name) {
        return this.vertexLabels.containsKey(name) || this.schemaProvider.getVertexLabel(name) != null;
    }

    public boolean containsRelationType(String name) {
        return this.relationTypes.containsKey(name) || this.schemaProvider.getRelationType(name) != null;
    }

    public FaunusRelationType getRelationType(String name) {
        FaunusRelationType rt = (FaunusPropertyKey)((Object)this.relationTypes.get(name));
        if (rt == null) {
            RelationTypeDefinition def = this.schemaProvider.getRelationType(name);
            if (def == null) {
                log.debug("Relation type name \"{}\" does not map to a type (returning null)", (Object)name);
                return null;
            }
            if (def instanceof PropertyKeyDefinition) {
                rt = new FaunusPropertyKey((PropertyKeyDefinition)def, false, this.isSchemaProviderDefault);
                log.debug("Relation type name \"{}\" mapped to property key {}", (Object)name, rt);
            } else {
                rt = new FaunusEdgeLabel((EdgeLabelDefinition)def, false, this.isSchemaProviderDefault);
                log.debug("Relation type name \"{}\" mapped to edge label {}", (Object)name, rt);
            }
            this.relationTypes.putIfAbsent(name, rt);
            rt = (FaunusRelationType)((Object)this.relationTypes.get(name));
        }
        assert (rt != null);
        log.debug("Relation type name \"{}\" mapped to instance {}", (Object)name, (Object)rt);
        return rt;
    }

    public boolean containsPropertyKey(String name) {
        FaunusRelationType rt = this.getRelationType(name);
        return rt != null && rt.isPropertyKey();
    }

    public boolean containsEdgeLabel(String name) {
        FaunusRelationType rt = this.getRelationType(name);
        return rt != null && rt.isEdgeLabel();
    }

    public FaunusPropertyKey getOrCreatePropertyKey(String name) {
        FaunusRelationType rt = this.getRelationType(name);
        if (rt == null) {
            this.relationTypes.putIfAbsent(name, new FaunusPropertyKey(this.schemaProvider.getPropertyKey(name), false, this.isSchemaProviderDefault));
            rt = (FaunusRelationType)((Object)this.relationTypes.get(name));
        }
        assert (rt != null);
        if (!(rt instanceof FaunusPropertyKey)) {
            throw new IllegalArgumentException("Not a property key: " + name);
        }
        return (FaunusPropertyKey)rt;
    }

    public FaunusPropertyKey getPropertyKey(String name) {
        FaunusRelationType rt = this.getRelationType(name);
        Preconditions.checkArgument((rt == null || rt.isPropertyKey() ? 1 : 0) != 0, (String)"Name does not identify a property key: ", (Object[])new Object[]{name});
        return (FaunusPropertyKey)rt;
    }

    public FaunusEdgeLabel getOrCreateEdgeLabel(String name) {
        FaunusRelationType rt = this.getRelationType(name);
        if (rt == null) {
            this.relationTypes.putIfAbsent(name, new FaunusEdgeLabel(this.schemaProvider.getEdgeLabel(name), false, this.isSchemaProviderDefault));
            rt = (FaunusRelationType)((Object)this.relationTypes.get(name));
        }
        assert (rt != null);
        if (!(rt instanceof FaunusEdgeLabel)) {
            throw new IllegalArgumentException("Not an edge label: " + name);
        }
        return (FaunusEdgeLabel)rt;
    }

    public FaunusEdgeLabel getEdgeLabel(String name) {
        FaunusRelationType rt = this.getRelationType(name);
        Preconditions.checkArgument((rt == null || rt.isEdgeLabel() ? 1 : 0) != 0, (String)"Name does not identify an edge label: ", (Object[])new Object[]{name});
        return (FaunusEdgeLabel)rt;
    }

    public static FaunusSchemaManager getTypeManager(Configuration config) {
        return DEFAULT_MANAGER;
    }
}

