/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.util;

import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.FaunusVertexQueryFilter;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.util.input.TitanHadoopSetup;
import com.thinkaurelius.titan.util.system.ConfigurationUtil;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;

public abstract class TitanInputFormat
extends InputFormat<NullWritable, FaunusVertex>
implements Configurable {
    private static final String SETUP_PACKAGE_PREFIX = "com.thinkaurelius.titan.hadoop.formats.util.input.";
    private static final String SETUP_CLASS_NAME = ".TitanHadoopSetupImpl";
    protected FaunusVertexQueryFilter vertexQuery;
    protected boolean trackPaths;
    protected ModifiableHadoopConfiguration faunusConf;
    protected ModifiableConfiguration inputConf;
    private String titanVersion;
    private String className;
    private org.apache.hadoop.conf.Configuration apacheConf;

    public void setConf(org.apache.hadoop.conf.Configuration config) {
        this.apacheConf = config;
        this.faunusConf = ModifiableHadoopConfiguration.of(config);
        this.vertexQuery = FaunusVertexQueryFilter.create((Configuration)this.faunusConf);
        this.inputConf = this.faunusConf.getInputConf();
        this.titanVersion = this.faunusConf.get(TitanHadoopConfiguration.TITAN_INPUT_VERSION, new String[0]);
        this.trackPaths = this.faunusConf.get(TitanHadoopConfiguration.PIPELINE_TRACK_PATHS, new String[0]);
        this.className = SETUP_PACKAGE_PREFIX + this.titanVersion + SETUP_CLASS_NAME;
    }

    public TitanHadoopSetup getGraphSetup() {
        return (TitanHadoopSetup)ConfigurationUtil.instantiate((String)this.className, (Object[])new Object[]{this.apacheConf}, (Class[])new Class[]{org.apache.hadoop.conf.Configuration.class});
    }
}

