/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.mapreduce.util.ElementPicker;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.thinkaurelius.titan.hadoop.mapreduce.util.SafeMapperOutputs;
import com.thinkaurelius.titan.hadoop.mapreduce.util.WritableHandler;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class PropertyMap {
    public static final String CLASS = Tokens.makeNamespace(PropertyMap.class) + ".class";
    public static final String KEY = Tokens.makeNamespace(PropertyMap.class) + ".key";
    public static final String TYPE = Tokens.makeNamespace(PropertyMap.class) + ".type";

    public static Configuration createConfiguration(Class<? extends Element> klass, String key, Class<? extends WritableComparable> type) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        configuration.set(KEY, key);
        configuration.setClass(TYPE, type, WritableComparable.class);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, NullWritable, WritableComparable> {
        private String key;
        private boolean isVertex;
        private WritableHandler handler;
        private SafeMapperOutputs outputs;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration cfg = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context);
            this.isVertex = cfg.getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            this.key = cfg.get(KEY);
            this.handler = new WritableHandler(cfg.getClass(TYPE, Text.class, WritableComparable.class));
            this.outputs = new SafeMapperOutputs(context);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            this.outputs.write("graph", (Writable)NullWritable.get(), (Writable)value);
            if (this.isVertex) {
                if (value.hasPaths()) {
                    WritableComparable writable = this.handler.set(ElementPicker.getProperty(value, this.key));
                    int i = 0;
                    while ((long)i < value.pathCount()) {
                        this.outputs.write("sideeffect", (Writable)NullWritable.get(), (Writable)writable);
                        ++i;
                    }
                    HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTICES_PROCESSED, 1L);
                }
            } else {
                long edgesProcessed = 0L;
                for (Edge e : value.getEdges(Direction.OUT, new String[0])) {
                    StandardFaunusEdge edge = (StandardFaunusEdge)e;
                    if (!edge.hasPaths()) continue;
                    WritableComparable writable = this.handler.set(ElementPicker.getProperty(edge, this.key));
                    int i = 0;
                    while ((long)i < edge.pathCount()) {
                        this.outputs.write("sideeffect", (Writable)NullWritable.get(), (Writable)writable);
                        ++i;
                    }
                    ++edgesProcessed;
                }
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.OUT_EDGES_PROCESSED, edgesProcessed);
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            this.outputs.close();
        }
    }

    public static enum Counters {
        VERTICES_PROCESSED,
        OUT_EDGES_PROCESSED;

    }
}

