/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.thrift;

import com.thinkaurelius.titan.CassandraStorageSetup;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.configuration.ReadConfiguration;
import com.thinkaurelius.titan.graphdb.TitanGraphSerialSpeedTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.testcategory.PerformanceTests;
import com.thinkaurelius.titan.testutil.gen.Schema;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={PerformanceTests.class})
public class ThriftGraphSerialSpeedTest
extends TitanGraphSerialSpeedTest {
    private static StandardTitanGraph graph;
    private static Schema schema;
    private static final Logger log;

    public ThriftGraphSerialSpeedTest() throws BackendException {
        super(CassandraStorageSetup.getCassandraThriftGraphConfiguration(ThriftGraphSerialSpeedTest.class.getSimpleName()));
    }

    @BeforeClass
    public static void beforeClass() {
        CassandraStorageSetup.startCleanEmbedded();
    }

    protected StandardTitanGraph getGraph() throws BackendException {
        if (null == graph) {
            GraphDatabaseConfiguration graphconfig = new GraphDatabaseConfiguration((ReadConfiguration)this.conf);
            graphconfig.getBackend().clearStorage();
            log.debug("Cleared backend storage");
            graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)this.conf);
            this.initializeGraph((TitanGraph)graph);
        }
        return graph;
    }

    protected Schema getSchema() {
        if (null == schema) {
            schema = new Schema.Builder(VERTEX_COUNT, EDGE_COUNT).build();
        }
        return schema;
    }

    static {
        log = LoggerFactory.getLogger(ThriftGraphSerialSpeedTest.class);
    }
}

