/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.refresh;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

class ShardRefreshRequest
extends BroadcastShardOperationRequest {
    private boolean force = true;

    ShardRefreshRequest() {
    }

    ShardRefreshRequest(ShardId shardId, RefreshRequest request) {
        super(shardId, request);
        this.force = request.force();
    }

    @Deprecated
    public boolean force() {
        return this.force;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().before(Version.V_1_5_0)) {
            this.force = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_1_5_0)) {
            out.writeBoolean(this.force);
        }
    }
}

