/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.rest.RestStatus;

public class BulkItemResponse
implements Streamable {
    private int id;
    private String opType;
    private ActionResponse response;
    private Failure failure;

    BulkItemResponse() {
    }

    public BulkItemResponse(int id, String opType, ActionResponse response) {
        this.id = id;
        this.opType = opType;
        this.response = response;
    }

    public BulkItemResponse(int id, String opType, Failure failure) {
        this.id = id;
        this.opType = opType;
        this.failure = failure;
    }

    public int getItemId() {
        return this.id;
    }

    public String getOpType() {
        return this.opType;
    }

    public String getIndex() {
        if (this.failure != null) {
            return this.failure.getIndex();
        }
        if (this.response instanceof IndexResponse) {
            return ((IndexResponse)this.response).getIndex();
        }
        if (this.response instanceof DeleteResponse) {
            return ((DeleteResponse)this.response).getIndex();
        }
        if (this.response instanceof UpdateResponse) {
            return ((UpdateResponse)this.response).getIndex();
        }
        return null;
    }

    public String getType() {
        if (this.failure != null) {
            return this.failure.getType();
        }
        if (this.response instanceof IndexResponse) {
            return ((IndexResponse)this.response).getType();
        }
        if (this.response instanceof DeleteResponse) {
            return ((DeleteResponse)this.response).getType();
        }
        if (this.response instanceof UpdateResponse) {
            return ((UpdateResponse)this.response).getType();
        }
        return null;
    }

    public String getId() {
        if (this.failure != null) {
            return this.failure.getId();
        }
        if (this.response instanceof IndexResponse) {
            return ((IndexResponse)this.response).getId();
        }
        if (this.response instanceof DeleteResponse) {
            return ((DeleteResponse)this.response).getId();
        }
        if (this.response instanceof UpdateResponse) {
            return ((UpdateResponse)this.response).getId();
        }
        return null;
    }

    public long getVersion() {
        if (this.failure != null) {
            return -1L;
        }
        if (this.response instanceof IndexResponse) {
            return ((IndexResponse)this.response).getVersion();
        }
        if (this.response instanceof DeleteResponse) {
            return ((DeleteResponse)this.response).getVersion();
        }
        if (this.response instanceof UpdateResponse) {
            return ((UpdateResponse)this.response).getVersion();
        }
        return -1L;
    }

    public <T extends ActionResponse> T getResponse() {
        return (T)this.response;
    }

    public boolean isFailed() {
        return this.failure != null;
    }

    public String getFailureMessage() {
        if (this.failure != null) {
            return this.failure.getMessage();
        }
        return null;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public static BulkItemResponse readBulkItem(StreamInput in) throws IOException {
        BulkItemResponse response = new BulkItemResponse();
        response.readFrom(in);
        return response;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.opType = in.readSharedString();
        byte type = in.readByte();
        if (type == 0) {
            this.response = new IndexResponse();
            this.response.readFrom(in);
        } else if (type == 1) {
            this.response = new DeleteResponse();
            this.response.readFrom(in);
        } else if (type == 3) {
            this.response = new UpdateResponse();
            this.response.readFrom(in);
        }
        if (in.readBoolean()) {
            String fIndex = in.readSharedString();
            String fType = in.readSharedString();
            String fId = in.readOptionalString();
            String fMessage = in.readString();
            RestStatus status = RestStatus.readFrom(in);
            this.failure = new Failure(fIndex, fType, fId, fMessage, status);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        out.writeSharedString(this.opType);
        if (this.response == null) {
            out.writeByte((byte)2);
        } else {
            if (this.response instanceof IndexResponse) {
                out.writeByte((byte)0);
            } else if (this.response instanceof DeleteResponse) {
                out.writeByte((byte)1);
            } else if (this.response instanceof UpdateResponse) {
                out.writeByte((byte)3);
            }
            this.response.writeTo(out);
        }
        if (this.failure == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeSharedString(this.failure.getIndex());
            out.writeSharedString(this.failure.getType());
            out.writeOptionalString(this.failure.getId());
            out.writeString(this.failure.getMessage());
            RestStatus.writeTo(out, this.failure.getStatus());
        }
    }

    public static class Failure {
        private final String index;
        private final String type;
        private final String id;
        private final String message;
        private final RestStatus status;

        public Failure(String index, String type, String id, Throwable t) {
            this.index = index;
            this.type = type;
            this.id = id;
            this.message = ExceptionsHelper.detailedMessage(t);
            this.status = ExceptionsHelper.status(t);
        }

        public Failure(String index, String type, String id, String message, RestStatus status) {
            this.index = index;
            this.type = type;
            this.id = id;
            this.message = message;
            this.status = status;
        }

        public String getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }

        public RestStatus getStatus() {
            return this.status;
        }
    }
}

