/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.count;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;

public class CountResponse
extends BroadcastOperationResponse {
    private boolean terminatedEarly;
    private long count;

    CountResponse() {
    }

    CountResponse(long count, boolean hasTerminatedEarly, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.count = count;
        this.terminatedEarly = hasTerminatedEarly;
    }

    public long getCount() {
        return this.count;
    }

    public boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public RestStatus status() {
        return RestStatus.status(this.getSuccessfulShards(), this.getTotalShards(), this.getShardFailures());
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.count = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            this.terminatedEarly = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.count);
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeBoolean(this.terminatedEarly);
        }
    }
}

