/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldstats;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FieldStatsRequest
extends BroadcastOperationRequest<FieldStatsRequest> {
    public static final String DEFAULT_LEVEL = "cluster";
    private String[] fields;
    private String level = "cluster";

    public String[] fields() {
        return this.fields;
    }

    public void fields(String[] fields) {
        this.fields = fields;
    }

    public String level() {
        return this.level;
    }

    public void level(String level) {
        this.level = level;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (!DEFAULT_LEVEL.equals(this.level) && !"indices".equals(this.level)) {
            validationException = ValidateActions.addValidationError("invalid level option [" + this.level + "]", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.fields = in.readStringArray();
        this.level = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.fields);
        out.writeString(this.level);
    }
}

