/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationResponse;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportBroadcastOperationAction<Request extends BroadcastOperationRequest, Response extends BroadcastOperationResponse, ShardRequest extends BroadcastShardOperationRequest, ShardResponse extends BroadcastShardOperationResponse>
extends TransportAction<Request, Response> {
    protected final ThreadPool threadPool;
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    final String transportShardAction;
    final String executor;

    protected TransportBroadcastOperationAction(Settings settings, String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super(settings, actionName, threadPool, actionFilters);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.threadPool = threadPool;
        this.transportShardAction = actionName + "[s]";
        this.executor = this.executor();
        transportService.registerHandler(actionName, new TransportHandler());
        transportService.registerHandler(this.transportShardAction, new ShardTransportHandler());
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncBroadcastAction(this, request, listener).start();
    }

    protected abstract String executor();

    protected abstract Request newRequest();

    protected abstract Response newResponse(Request var1, AtomicReferenceArray var2, ClusterState var3);

    protected abstract ShardRequest newShardRequest();

    protected abstract ShardRequest newShardRequest(int var1, ShardRouting var2, Request var3);

    protected abstract ShardResponse newShardResponse();

    protected abstract ShardResponse shardOperation(ShardRequest var1) throws ElasticsearchException;

    protected abstract GroupShardsIterator shards(ClusterState var1, Request var2, String[] var3);

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2, String[] var3);

    class ShardTransportHandler
    extends BaseTransportRequestHandler<ShardRequest> {
        ShardTransportHandler() {
        }

        @Override
        public ShardRequest newInstance() {
            return TransportBroadcastOperationAction.this.newShardRequest();
        }

        @Override
        public String executor() {
            return TransportBroadcastOperationAction.this.executor;
        }

        @Override
        public void messageReceived(ShardRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse((TransportResponse)TransportBroadcastOperationAction.this.shardOperation(request));
        }
    }

    class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportBroadcastOperationAction.this.newRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            TransportBroadcastOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    try {
                        channel.sendResponse((TransportResponse)response);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportBroadcastOperationAction.this.logger.warn("Failed to send response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    protected static class AsyncBroadcastAction {
        private final Request request;
        private final ActionListener<Response> listener;
        private final ClusterState clusterState;
        private final DiscoveryNodes nodes;
        private final GroupShardsIterator shardsIts;
        private final int expectedOps;
        private final AtomicInteger counterOps = new AtomicInteger();
        private final AtomicReferenceArray shardsResponses;
        final /* synthetic */ TransportBroadcastOperationAction this$0;

        protected AsyncBroadcastAction(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.request = request;
            this.listener = listener;
            this.clusterState = var1_1.clusterService.state();
            ClusterBlockException blockException = var1_1.checkGlobalBlock(this.clusterState, request);
            if (blockException != null) {
                throw blockException;
            }
            String[] concreteIndices = this.clusterState.metaData().concreteIndices(((BroadcastOperationRequest)request).indicesOptions(), ((BroadcastOperationRequest)request).indices());
            blockException = var1_1.checkRequestBlock(this.clusterState, request, concreteIndices);
            if (blockException != null) {
                throw blockException;
            }
            this.nodes = this.clusterState.nodes();
            ((TransportBroadcastOperationAction)var1_1).logger.trace("resolving shards based on cluster state version [{}]", this.clusterState.version());
            this.shardsIts = var1_1.shards(this.clusterState, request, concreteIndices);
            this.expectedOps = this.shardsIts.size();
            this.shardsResponses = new AtomicReferenceArray(this.expectedOps);
        }

        public void start() {
            if (this.shardsIts.size() == 0) {
                try {
                    this.listener.onResponse(this.this$0.newResponse(this.request, new AtomicReferenceArray(0), this.clusterState));
                }
                catch (Throwable e) {
                    this.listener.onFailure(e);
                }
                return;
            }
            int shardIndex = -1;
            for (ShardIterator shardIt : this.shardsIts) {
                ++shardIndex;
                ShardRouting shard = shardIt.nextOrNull();
                if (shard != null) {
                    this.performOperation(shardIt, shard, shardIndex);
                    continue;
                }
                this.onOperation(null, shardIt, shardIndex, new NoShardAvailableActionException(shardIt.shardId()));
            }
        }

        protected void performOperation(final ShardIterator shardIt, final ShardRouting shard, final int shardIndex) {
            if (shard == null) {
                this.onOperation(null, shardIt, shardIndex, new NoShardAvailableActionException(shardIt.shardId()));
            } else {
                try {
                    Object shardRequest = this.this$0.newShardRequest(shardIt.size(), shard, this.request);
                    if (shard.currentNodeId().equals(this.nodes.localNodeId())) {
                        this.this$0.threadPool.executor(this.this$0.executor).execute(new Runnable((BroadcastShardOperationRequest)shardRequest, shardIt){
                            final /* synthetic */ BroadcastShardOperationRequest val$shardRequest;
                            final /* synthetic */ ShardIterator val$shardIt;
                            {
                                this.val$shardRequest = broadcastShardOperationRequest;
                                this.val$shardIt = shardIterator;
                            }

                            @Override
                            public void run() {
                                try {
                                    AsyncBroadcastAction.this.onOperation(shard, shardIndex, AsyncBroadcastAction.this.this$0.shardOperation(this.val$shardRequest));
                                }
                                catch (Throwable e) {
                                    AsyncBroadcastAction.this.onOperation(shard, this.val$shardIt, shardIndex, e);
                                }
                            }
                        });
                    } else {
                        DiscoveryNode node = this.nodes.get(shard.currentNodeId());
                        if (node == null) {
                            this.onOperation(shard, shardIt, shardIndex, new NoShardAvailableActionException(shardIt.shardId()));
                        } else {
                            this.this$0.transportService.sendRequest(node, this.this$0.transportShardAction, (TransportRequest)shardRequest, new BaseTransportResponseHandler<ShardResponse>(){

                                @Override
                                public ShardResponse newInstance() {
                                    return AsyncBroadcastAction.this.this$0.newShardResponse();
                                }

                                @Override
                                public String executor() {
                                    return "same";
                                }

                                @Override
                                public void handleResponse(ShardResponse response) {
                                    AsyncBroadcastAction.this.onOperation(shard, shardIndex, response);
                                }

                                @Override
                                public void handleException(TransportException e) {
                                    AsyncBroadcastAction.this.onOperation(shard, shardIt, shardIndex, e);
                                }
                            });
                        }
                    }
                }
                catch (Throwable e) {
                    this.onOperation(shard, shardIt, shardIndex, e);
                }
            }
        }

        protected void onOperation(ShardRouting shard, int shardIndex, ShardResponse response) {
            this.this$0.logger.trace("received response for {}", shard);
            this.shardsResponses.set(shardIndex, response);
            if (this.expectedOps == this.counterOps.incrementAndGet()) {
                this.finishHim();
            }
        }

        void onOperation(@Nullable ShardRouting shard, ShardIterator shardIt, int shardIndex, Throwable t) {
            this.setFailure(shardIt, shardIndex, t);
            ShardRouting nextShard = shardIt.nextOrNull();
            if (nextShard != null) {
                if (t != null && this.this$0.logger.isTraceEnabled() && !TransportActions.isShardNotAvailableException(t)) {
                    this.this$0.logger.trace("{}: failed to execute [{}]", t, shard != null ? shard.shortSummary() : shardIt.shardId(), this.request);
                }
                this.performOperation(shardIt, nextShard, shardIndex);
            } else {
                if (this.this$0.logger.isDebugEnabled() && t != null && !TransportActions.isShardNotAvailableException(t)) {
                    this.this$0.logger.debug("{}: failed to execute [{}]", t, shard != null ? shard.shortSummary() : shardIt.shardId(), this.request);
                }
                if (this.expectedOps == this.counterOps.incrementAndGet()) {
                    this.finishHim();
                }
            }
        }

        protected void finishHim() {
            try {
                this.listener.onResponse(this.this$0.newResponse(this.request, this.shardsResponses, this.clusterState));
            }
            catch (Throwable e) {
                this.listener.onFailure(e);
            }
        }

        void setFailure(ShardIterator shardIt, int shardIndex, Throwable t) {
            Object response;
            if (TransportActions.isShardNotAvailableException(t)) {
                return;
            }
            if (!(t instanceof BroadcastShardOperationFailedException)) {
                t = new BroadcastShardOperationFailedException(shardIt.shardId(), t);
            }
            if ((response = this.shardsResponses.get(shardIndex)) == null) {
                this.shardsResponses.set(shardIndex, t);
            }
            if (!(response instanceof Throwable)) {
                return;
            }
            if (TransportActions.isReadOverrideException(t)) {
                this.shardsResponses.set(shardIndex, t);
            }
        }
    }
}

