/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.command;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.allocation.RerouteExplanation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.shard.ShardId;

public class AllocateAllocationCommand
implements AllocationCommand {
    public static final String NAME = "allocate";
    private final ShardId shardId;
    private final String node;
    private final boolean allowPrimary;

    public AllocateAllocationCommand(ShardId shardId, String node, boolean allowPrimary) {
        this.shardId = shardId;
        this.node = node;
        this.allowPrimary = allowPrimary;
    }

    @Override
    public String name() {
        return NAME;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String node() {
        return this.node;
    }

    public boolean allowPrimary() {
        return this.allowPrimary;
    }

    @Override
    public RerouteExplanation execute(RoutingAllocation allocation, boolean explain) throws ElasticsearchException {
        DiscoveryNode discoNode = allocation.nodes().resolveNode(this.node);
        ImmutableShardRouting shardRouting = null;
        for (MutableShardRouting routing : allocation.routingNodes().unassigned()) {
            if (!routing.shardId().equals(this.shardId) || shardRouting != null && !routing.primary()) continue;
            shardRouting = routing;
        }
        if (shardRouting == null) {
            if (explain) {
                return new RerouteExplanation(this, allocation.decision(Decision.NO, "allocate_allocation_command", "failed to find " + this.shardId + " on the list of unassigned shards", new Object[0]));
            }
            throw new ElasticsearchIllegalArgumentException("[allocate] failed to find " + this.shardId + " on the list of unassigned shards");
        }
        if (shardRouting.primary() && !this.allowPrimary) {
            if (explain) {
                return new RerouteExplanation(this, allocation.decision(Decision.NO, "allocate_allocation_command", "trying to allocate a primary shard " + this.shardId + ", which is disabled", new Object[0]));
            }
            throw new ElasticsearchIllegalArgumentException("[allocate] trying to allocate a primary shard " + this.shardId + ", which is disabled");
        }
        RoutingNode routingNode = allocation.routingNodes().node(discoNode.id());
        if (routingNode == null) {
            if (!discoNode.dataNode()) {
                if (explain) {
                    return new RerouteExplanation(this, allocation.decision(Decision.NO, "allocate_allocation_command", "Allocation can only be done on data nodes, not [" + this.node + "]", new Object[0]));
                }
                throw new ElasticsearchIllegalArgumentException("Allocation can only be done on data nodes, not [" + this.node + "]");
            }
            if (explain) {
                return new RerouteExplanation(this, allocation.decision(Decision.NO, "allocate_allocation_command", "Could not find [" + this.node + "] among the routing nodes", new Object[0]));
            }
            throw new ElasticsearchIllegalStateException("Could not find [" + this.node + "] among the routing nodes");
        }
        Decision decision = allocation.deciders().canAllocate(shardRouting, routingNode, allocation);
        if (decision.type() == Decision.Type.NO) {
            if (explain) {
                return new RerouteExplanation(this, decision);
            }
            throw new ElasticsearchIllegalArgumentException("[allocate] allocation of " + this.shardId + " on node " + discoNode + " is not allowed, reason: " + decision);
        }
        RoutingNodes.UnassignedShards.UnassignedIterator it = allocation.routingNodes().unassigned().iterator();
        while (it.hasNext()) {
            if (it.next() != shardRouting) continue;
            it.initialize(routingNode.nodeId(), shardRouting.version());
            if (!shardRouting.primary()) break;
            allocation.routingNodes().addClearPostAllocationFlag(shardRouting.shardId());
            break;
        }
        return new RerouteExplanation(this, decision);
    }

    public static class Factory
    implements AllocationCommand.Factory<AllocateAllocationCommand> {
        @Override
        public AllocateAllocationCommand readFrom(StreamInput in) throws IOException {
            return new AllocateAllocationCommand(ShardId.readShardId(in), in.readString(), in.readBoolean());
        }

        @Override
        public void writeTo(AllocateAllocationCommand command, StreamOutput out) throws IOException {
            command.shardId().writeTo(out);
            out.writeString(command.node());
            out.writeBoolean(command.allowPrimary());
        }

        @Override
        public AllocateAllocationCommand fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token;
            String index = null;
            int shardId = -1;
            String nodeId = null;
            boolean allowPrimary = false;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("index".equals(currentFieldName)) {
                        index = parser.text();
                        continue;
                    }
                    if ("shard".equals(currentFieldName)) {
                        shardId = parser.intValue();
                        continue;
                    }
                    if ("node".equals(currentFieldName)) {
                        nodeId = parser.text();
                        continue;
                    }
                    if ("allow_primary".equals(currentFieldName) || "allowPrimary".equals(currentFieldName)) {
                        allowPrimary = parser.booleanValue();
                        continue;
                    }
                    throw new ElasticsearchParseException("[allocate] command does not support field [" + currentFieldName + "]");
                }
                throw new ElasticsearchParseException("[allocate] command does not support complex json tokens [" + (Object)((Object)token) + "]");
            }
            if (index == null) {
                throw new ElasticsearchParseException("[allocate] command missing the index parameter");
            }
            if (shardId == -1) {
                throw new ElasticsearchParseException("[allocate] command missing the shard parameter");
            }
            if (nodeId == null) {
                throw new ElasticsearchParseException("[allocate] command missing the node parameter");
            }
            return new AllocateAllocationCommand(new ShardId(index, shardId), nodeId, allowPrimary);
        }

        @Override
        public void toXContent(AllocateAllocationCommand command, XContentBuilder builder, ToXContent.Params params, String objectName) throws IOException {
            if (objectName == null) {
                builder.startObject();
            } else {
                builder.startObject(objectName);
            }
            builder.field("index", command.shardId().index().name());
            builder.field("shard", command.shardId().id());
            builder.field("node", command.node());
            builder.field("allow_primary", command.allowPrimary());
            builder.endObject();
        }
    }
}

