/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf.impl;

import java.nio.ByteOrder;
import org.elasticsearch.common.compress.BufferRecycler;
import org.elasticsearch.common.compress.lzf.impl.UnsafeChunkEncoder;
import org.elasticsearch.common.compress.lzf.impl.UnsafeChunkEncoderBE;
import org.elasticsearch.common.compress.lzf.impl.UnsafeChunkEncoderLE;

public final class UnsafeChunkEncoders {
    private static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;

    public static UnsafeChunkEncoder createEncoder(int totalLength) {
        if (LITTLE_ENDIAN) {
            return new UnsafeChunkEncoderLE(totalLength);
        }
        return new UnsafeChunkEncoderBE(totalLength);
    }

    public static UnsafeChunkEncoder createNonAllocatingEncoder(int totalLength) {
        if (LITTLE_ENDIAN) {
            return new UnsafeChunkEncoderLE(totalLength, false);
        }
        return new UnsafeChunkEncoderBE(totalLength, false);
    }

    public static UnsafeChunkEncoder createEncoder(int totalLength, BufferRecycler bufferRecycler) {
        if (LITTLE_ENDIAN) {
            return new UnsafeChunkEncoderLE(totalLength, bufferRecycler);
        }
        return new UnsafeChunkEncoderBE(totalLength, bufferRecycler);
    }

    public static UnsafeChunkEncoder createNonAllocatingEncoder(int totalLength, BufferRecycler bufferRecycler) {
        if (LITTLE_ENDIAN) {
            return new UnsafeChunkEncoderLE(totalLength, bufferRecycler, false);
        }
        return new UnsafeChunkEncoderBE(totalLength, bufferRecycler, false);
    }
}

