/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support.filtering;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.jackson.core.Base64Variant;
import org.elasticsearch.common.jackson.core.JsonGenerator;
import org.elasticsearch.common.jackson.core.JsonParser;
import org.elasticsearch.common.jackson.core.SerializableString;
import org.elasticsearch.common.xcontent.json.BaseJsonGenerator;
import org.elasticsearch.common.xcontent.support.filtering.FilterContext;

public class FilteringJsonGenerator
extends BaseJsonGenerator {
    private Queue<FilterContext> contexts = new ArrayDeque<FilterContext>();
    private static final int MAX_CONTEXTS = 10;
    private FilterContext context;

    public FilteringJsonGenerator(JsonGenerator generator, String[] filters) {
        super(generator);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (filters != null) {
            for (String filter : filters) {
                String[] matcher = Strings.delimitedListToStringArray(filter, ".");
                if (matcher == null) continue;
                builder.add((Object)matcher);
            }
        }
        this.context = this.get(null, null, (List<String[]>)((Object)builder.build()));
    }

    private FilterContext get(String property, FilterContext parent) {
        FilterContext ctx = this.contexts.poll();
        if (ctx == null) {
            ctx = new FilterContext(property, parent);
        } else {
            ctx.reset(property, parent);
        }
        return ctx;
    }

    private FilterContext get(String property, FilterContext context, List<String[]> matchings) {
        FilterContext ctx = this.get(property, context);
        if (matchings != null) {
            for (String[] matching : matchings) {
                ctx.addMatching(matching);
            }
        }
        return ctx;
    }

    private void put(FilterContext ctx) {
        if (this.contexts.size() <= 10) {
            this.contexts.offer(ctx);
        }
    }

    @Override
    public void writeStartArray() throws IOException {
        this.context.initArray();
        if (this.context.include()) {
            super.writeStartArray();
        }
    }

    @Override
    public void writeStartArray(int size) throws IOException {
        this.context.initArray();
        if (this.context.include()) {
            super.writeStartArray(size);
        }
    }

    @Override
    public void writeEndArray() throws IOException {
        if (this.context.isArrayOfObject()) {
            FilterContext parent = this.context.parent();
            this.put(this.context);
            this.context = parent;
        }
        if (this.context.include()) {
            super.writeEndArray();
        }
    }

    @Override
    public void writeStartObject() throws IOException {
        if (this.context.isArray()) {
            this.context = this.get(null, this.context, this.context.matchings());
            this.context.initArrayOfObject();
        }
        if (!this.context.isArrayOfObject()) {
            this.context.initObject();
        }
        if (this.context.include()) {
            super.writeStartObject();
        }
        this.context = this.get(null, this.context);
    }

    @Override
    public void writeEndObject() throws IOException {
        if (!this.context.isRoot()) {
            FilterContext parent = this.context.parent();
            this.put(this.context);
            this.context = parent;
        }
        if (this.context.include()) {
            super.writeEndObject();
        }
    }

    @Override
    public void writeFieldName(String name) throws IOException {
        this.context.reset(name);
        if (this.context.include()) {
            this.context.writePath(this.delegate);
            super.writeFieldName(name);
        }
    }

    @Override
    public void writeFieldName(SerializableString name) throws IOException {
        this.context.reset(name.getValue());
        if (this.context.include()) {
            this.context.writePath(this.delegate);
            super.writeFieldName(name);
        }
    }

    @Override
    public void writeString(String text) throws IOException {
        if (this.context.include()) {
            super.writeString(text);
        }
    }

    @Override
    public void writeString(char[] text, int offset, int len) throws IOException {
        if (this.context.include()) {
            super.writeString(text, offset, len);
        }
    }

    @Override
    public void writeString(SerializableString text) throws IOException {
        if (this.context.include()) {
            super.writeString(text);
        }
    }

    @Override
    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        if (this.context.include()) {
            super.writeRawUTF8String(text, offset, length);
        }
    }

    @Override
    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        if (this.context.include()) {
            super.writeUTF8String(text, offset, length);
        }
    }

    @Override
    public void writeRaw(String text) throws IOException {
        if (this.context.include()) {
            super.writeRaw(text);
        }
    }

    @Override
    public void writeRaw(String text, int offset, int len) throws IOException {
        if (this.context.include()) {
            super.writeRaw(text, offset, len);
        }
    }

    @Override
    public void writeRaw(SerializableString raw) throws IOException {
        if (this.context.include()) {
            super.writeRaw(raw);
        }
    }

    @Override
    public void writeRaw(char[] text, int offset, int len) throws IOException {
        if (this.context.include()) {
            super.writeRaw(text, offset, len);
        }
    }

    @Override
    public void writeRaw(char c) throws IOException {
        if (this.context.include()) {
            super.writeRaw(c);
        }
    }

    @Override
    public void writeRawValue(String text) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(text);
        }
    }

    @Override
    public void writeRawValue(String text, int offset, int len) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(text, offset, len);
        }
    }

    @Override
    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(text, offset, len);
        }
    }

    @Override
    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (this.context.include()) {
            super.writeBinary(b64variant, data, offset, len);
        }
    }

    @Override
    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) throws IOException {
        if (this.context.include()) {
            return super.writeBinary(b64variant, data, dataLength);
        }
        return 0;
    }

    @Override
    public void writeNumber(short v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    @Override
    public void writeNumber(int v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    @Override
    public void writeNumber(long v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    @Override
    public void writeNumber(BigInteger v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    @Override
    public void writeNumber(double v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    @Override
    public void writeNumber(float v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    @Override
    public void writeNumber(BigDecimal v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    @Override
    public void writeNumber(String encodedValue) throws IOException, UnsupportedOperationException {
        if (this.context.include()) {
            super.writeNumber(encodedValue);
        }
    }

    @Override
    public void writeBoolean(boolean state) throws IOException {
        if (this.context.include()) {
            super.writeBoolean(state);
        }
    }

    @Override
    public void writeNull() throws IOException {
        if (this.context.include()) {
            super.writeNull();
        }
    }

    @Override
    public void copyCurrentEvent(JsonParser jp) throws IOException {
        if (this.context.include()) {
            super.copyCurrentEvent(jp);
        }
    }

    @Override
    public void copyCurrentStructure(JsonParser jp) throws IOException {
        if (this.context.include()) {
            super.copyCurrentStructure(jp);
        }
    }

    @Override
    protected void writeRawValue(byte[] content, OutputStream bos) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(content, bos);
        }
    }

    @Override
    protected void writeRawValue(byte[] content, int offset, int length, OutputStream bos) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(content, offset, length, bos);
        }
    }

    @Override
    protected void writeRawValue(InputStream content, OutputStream bos) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(content, bos);
        }
    }

    @Override
    protected void writeRawValue(BytesReference content, OutputStream bos) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(content, bos);
        }
    }

    @Override
    public void close() throws IOException {
        this.contexts.clear();
        super.close();
    }
}

