/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.publish;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.HandlesStreamInput;
import org.elasticsearch.common.io.stream.HandlesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.AckClusterStatePublishResponseHandler;
import org.elasticsearch.discovery.BlockingClusterStatePublishResponseHandler;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BytesTransportRequest;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class PublishClusterStateAction
extends AbstractComponent {
    public static final String ACTION_NAME = "internal:discovery/zen/publish";
    private final TransportService transportService;
    private final DiscoveryNodesProvider nodesProvider;
    private final NewClusterStateListener listener;
    private final DiscoverySettings discoverySettings;
    private final ClusterName clusterName;

    public PublishClusterStateAction(Settings settings, TransportService transportService, DiscoveryNodesProvider nodesProvider, NewClusterStateListener listener, DiscoverySettings discoverySettings, ClusterName clusterName) {
        super(settings);
        this.transportService = transportService;
        this.nodesProvider = nodesProvider;
        this.listener = listener;
        this.discoverySettings = discoverySettings;
        this.clusterName = clusterName;
        transportService.registerHandler(ACTION_NAME, new PublishClusterStateRequestHandler());
    }

    public void close() {
        this.transportService.removeHandler(ACTION_NAME);
    }

    public void publish(ClusterState clusterState, Discovery.AckListener ackListener) {
        HashSet<DiscoveryNode> nodesToPublishTo = new HashSet<DiscoveryNode>(clusterState.nodes().size());
        DiscoveryNode localNode = this.nodesProvider.nodes().localNode();
        for (DiscoveryNode node : clusterState.nodes()) {
            if (node.equals(localNode)) continue;
            nodesToPublishTo.add(node);
        }
        this.publish(clusterState, nodesToPublishTo, new AckClusterStatePublishResponseHandler(nodesToPublishTo, ackListener));
    }

    private void publish(final ClusterState clusterState, Set<DiscoveryNode> nodesToPublishTo, final BlockingClusterStatePublishResponseHandler publishResponseHandler) {
        HashMap<Version, BytesReference> serializedStates = Maps.newHashMap();
        final AtomicBoolean timedOutWaitingForNodes = new AtomicBoolean(false);
        final TimeValue publishTimeout = this.discoverySettings.getPublishTimeout();
        for (final DiscoveryNode node : nodesToPublishTo) {
            BytesReference bytes = (BytesReference)serializedStates.get(node.version());
            if (bytes == null) {
                try {
                    BytesStreamOutput bStream = new BytesStreamOutput();
                    HandlesStreamOutput stream = new HandlesStreamOutput(CompressorFactory.defaultCompressor().streamOutput(bStream));
                    ((StreamOutput)stream).setVersion(node.version());
                    ClusterState.Builder.writeTo(clusterState, stream);
                    ((StreamOutput)stream).close();
                    bytes = bStream.bytes();
                    serializedStates.put(node.version(), bytes);
                }
                catch (Throwable e) {
                    this.logger.warn("failed to serialize cluster_state before publishing it to node {}", e, node);
                    publishResponseHandler.onFailure(node, e);
                    continue;
                }
            }
            try {
                TransportRequestOptions options = TransportRequestOptions.options().withType(TransportRequestOptions.Type.STATE).withCompress(false);
                this.transportService.sendRequest(node, ACTION_NAME, new BytesTransportRequest(bytes, node.version()), options, new EmptyTransportResponseHandler("same"){

                    @Override
                    public void handleResponse(TransportResponse.Empty response) {
                        if (timedOutWaitingForNodes.get()) {
                            PublishClusterStateAction.this.logger.debug("node {} responded for cluster state [{}] (took longer than [{}])", node, clusterState.version(), publishTimeout);
                        }
                        publishResponseHandler.onResponse(node);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        PublishClusterStateAction.this.logger.debug("failed to send cluster state to {}", exp, node);
                        publishResponseHandler.onFailure(node, exp);
                    }
                });
            }
            catch (Throwable t) {
                this.logger.debug("error sending cluster state to {}", t, node);
                publishResponseHandler.onFailure(node, t);
            }
        }
        if (publishTimeout.millis() > 0L) {
            try {
                DiscoveryNode[] pendingNodes;
                timedOutWaitingForNodes.set(!publishResponseHandler.awaitAllNodes(publishTimeout));
                if (timedOutWaitingForNodes.get() && (pendingNodes = publishResponseHandler.pendingNodes()).length > 0) {
                    this.logger.warn("timed out waiting for all nodes to process published state [{}] (timeout [{}], pending nodes: {})", clusterState.version(), publishTimeout, pendingNodes);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class PublishClusterStateRequestHandler
    extends BaseTransportRequestHandler<BytesTransportRequest> {
        private PublishClusterStateRequestHandler() {
        }

        @Override
        public BytesTransportRequest newInstance() {
            return new BytesTransportRequest();
        }

        @Override
        public void messageReceived(BytesTransportRequest request, final TransportChannel channel) throws Exception {
            Compressor compressor = CompressorFactory.compressor(request.bytes());
            HandlesStreamInput in = compressor != null ? CachedStreamInput.cachedHandlesCompressed(compressor, request.bytes().streamInput()) : CachedStreamInput.cachedHandles(request.bytes().streamInput());
            ((StreamInput)in).setVersion(request.version());
            ClusterState clusterState = ClusterState.Builder.readFrom(in, PublishClusterStateAction.this.nodesProvider.nodes().localNode(), PublishClusterStateAction.this.clusterName);
            clusterState.status(ClusterState.ClusterStateStatus.RECEIVED);
            PublishClusterStateAction.this.logger.debug("received cluster state version {}", clusterState.version());
            try {
                PublishClusterStateAction.this.listener.onNewClusterState(clusterState, new NewClusterStateListener.NewStateProcessed(){

                    @Override
                    public void onNewClusterStateProcessed() {
                        try {
                            channel.sendResponse(TransportResponse.Empty.INSTANCE);
                        }
                        catch (Throwable e) {
                            PublishClusterStateAction.this.logger.debug("failed to send response on cluster state processed", e, new Object[0]);
                        }
                    }

                    @Override
                    public void onNewClusterStateFailed(Throwable t) {
                        try {
                            channel.sendResponse(t);
                        }
                        catch (Throwable e) {
                            PublishClusterStateAction.this.logger.debug("failed to send response on cluster state processed", e, new Object[0]);
                        }
                    }
                });
            }
            catch (Exception e) {
                PublishClusterStateAction.this.logger.warn("unexpected error while processing cluster state version [{}]", e, clusterState.version());
                try {
                    channel.sendResponse(e);
                }
                catch (Throwable e1) {
                    PublishClusterStateAction.this.logger.debug("failed to send response on cluster state processed", e1, new Object[0]);
                }
            }
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    public static interface NewClusterStateListener {
        public void onNewClusterState(ClusterState var1, NewStateProcessed var2);

        public static interface NewStateProcessed {
            public void onNewClusterStateProcessed();

            public void onNewClusterStateFailed(Throwable var1);
        }
    }
}

