/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.InternalEngine;
import org.elasticsearch.index.engine.RecoveryEngineException;

public class SharedFSEngine
extends InternalEngine {
    public SharedFSEngine(EngineConfig engineConfig) throws EngineException {
        super(engineConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(Engine.RecoveryHandler recoveryHandler) throws EngineException {
        this.store.incRef();
        try {
            this.logger.trace("[pre-recovery] acquiring write lock", new Object[0]);
            try (ReleasableLock lock = this.writeLock.acquire();){
                this.ensureOpen();
                try {
                    this.logger.trace("[phase1] performing phase 1 recovery (file recovery)", new Object[0]);
                    recoveryHandler.phase1(null);
                }
                catch (Throwable e) {
                    this.maybeFailEngine("recovery phase 1 (file transfer)", e);
                    throw new RecoveryEngineException(this.shardId, 1, "Execution failed", this.wrapIfClosed(e));
                }
            }
            try {
                this.logger.trace("[phase2] performing phase 2 recovery (translog replay)", new Object[0]);
                recoveryHandler.phase2(null);
            }
            catch (Throwable e) {
                this.maybeFailEngine("recovery phase 2 (snapshot transfer)", e);
                throw new RecoveryEngineException(this.shardId, 2, "Execution failed", this.wrapIfClosed(e));
            }
            try {
                this.logger.trace("[phase3] performing phase 3 recovery (finalization)", new Object[0]);
                recoveryHandler.phase3(null);
            }
            catch (Throwable e) {
                this.maybeFailEngine("recovery phase 3 (finalization)", e);
                throw new RecoveryEngineException(this.shardId, 3, "Execution failed", this.wrapIfClosed(e));
            }
        }
        finally {
            this.store.decRef();
        }
        this.logger.trace("[post-recovery] recovery complete", new Object[0]);
    }
}

