/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.elasticsearch.index.query.RegexpFlag;

public class RegexpQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<RegexpQueryBuilder>,
MultiTermQueryBuilder {
    private final String name;
    private final String regexp;
    private int flags = -1;
    private float boost = -1.0f;
    private String rewrite;
    private String queryName;
    private int maxDeterminizedStates = 10000;
    private boolean maxDetermizedStatesSet;

    public RegexpQueryBuilder(String name, String regexp) {
        this.name = name;
        this.regexp = regexp;
    }

    @Override
    public RegexpQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public RegexpQueryBuilder flags(RegexpFlag ... flags) {
        int value = 0;
        if (flags.length == 0) {
            value = RegexpFlag.ALL.value;
        } else {
            for (RegexpFlag flag : flags) {
                value |= flag.value;
            }
        }
        this.flags = value;
        return this;
    }

    public RegexpQueryBuilder maxDeterminizedStates(int value) {
        this.maxDeterminizedStates = value;
        this.maxDetermizedStatesSet = true;
        return this;
    }

    public RegexpQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public RegexpQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("regexp");
        builder.startObject(this.name);
        builder.field("value", this.regexp);
        if (this.flags != -1) {
            builder.field("flags_value", this.flags);
        }
        if (this.maxDetermizedStatesSet) {
            builder.field("max_determinized_states", this.maxDeterminizedStates);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.rewrite != null) {
            builder.field("rewrite", this.rewrite);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
        builder.endObject();
    }
}

