/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.search.child.ConstantScorer;
import org.elasticsearch.index.search.child.ParentIdsFilter;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.internal.SearchContext;

public class ChildrenQuery
extends Query {
    protected final ParentChildIndexFieldData ifd;
    protected final String parentType;
    protected final String childType;
    protected final Filter parentFilter;
    protected final ScoreType scoreType;
    protected Query originalChildQuery;
    protected final int minChildren;
    protected final int maxChildren;
    protected final int shortCircuitParentDocSet;
    protected final FixedBitSetFilter nonNestedDocsFilter;
    protected Query rewrittenChildQuery;
    protected IndexReader rewriteIndexReader;

    public ChildrenQuery(ParentChildIndexFieldData ifd, String parentType, String childType, Filter parentFilter, Query childQuery, ScoreType scoreType, int minChildren, int maxChildren, int shortCircuitParentDocSet, FixedBitSetFilter nonNestedDocsFilter) {
        this.ifd = ifd;
        this.parentType = parentType;
        this.childType = childType;
        this.parentFilter = parentFilter;
        this.originalChildQuery = childQuery;
        this.scoreType = scoreType;
        this.shortCircuitParentDocSet = shortCircuitParentDocSet;
        this.nonNestedDocsFilter = nonNestedDocsFilter;
        assert (maxChildren == 0 || minChildren <= maxChildren);
        this.minChildren = minChildren > 1 ? minChildren : 0;
        this.maxChildren = maxChildren;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ChildrenQuery that = (ChildrenQuery)((Object)obj);
        if (!this.originalChildQuery.equals((Object)that.originalChildQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        if (this.getBoost() != that.getBoost()) {
            return false;
        }
        if (this.minChildren != that.minChildren) {
            return false;
        }
        return this.maxChildren == that.maxChildren;
    }

    public int hashCode() {
        int result = this.originalChildQuery.hashCode();
        result = 31 * result + this.childType.hashCode();
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        result = 31 * result + this.minChildren;
        result = 31 * result + this.maxChildren;
        return result;
    }

    public String toString(String field) {
        int max = this.maxChildren == 0 ? Integer.MAX_VALUE : this.maxChildren;
        return "ChildrenQuery[min(" + Integer.toString(this.minChildren) + ") max(" + Integer.toString(max) + ")of " + this.childType + "/" + this.parentType + "](" + this.originalChildQuery.toString(field) + ')' + ToStringUtils.boost((float)this.getBoost());
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenChildQuery == null) {
            this.rewriteIndexReader = reader;
            this.rewrittenChildQuery = this.originalChildQuery.rewrite(reader);
        }
        return this;
    }

    public Query clone() {
        ChildrenQuery q = (ChildrenQuery)super.clone();
        q.originalChildQuery = this.originalChildQuery.clone();
        if (q.rewrittenChildQuery != null) {
            q.rewrittenChildQuery = this.rewrittenChildQuery.clone();
        }
        return q;
    }

    public void extractTerms(Set<Term> terms) {
        this.rewrittenChildQuery.extractTerms(terms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        block21: {
            block22: {
                sc = SearchContext.current();
                if (!ChildrenQuery.$assertionsDisabled && this.rewrittenChildQuery == null) {
                    throw new AssertionError();
                }
                if (!ChildrenQuery.$assertionsDisabled && this.rewriteIndexReader != searcher.getIndexReader()) {
                    throw new AssertionError((Object)("not equal, rewriteIndexReader=" + this.rewriteIndexReader + " searcher.getIndexReader()=" + searcher.getIndexReader()));
                }
                childQuery = this.rewrittenChildQuery;
                globalIfd = this.ifd.loadGlobal(searcher.getIndexReader());
                if (globalIfd == null) {
                    return Queries.newMatchNoDocsQuery().createWeight(searcher);
                }
                indexSearcher = new IndexSearcher(searcher.getIndexReader());
                indexSearcher.setSimilarity(searcher.getSimilarity());
                abort = true;
                collector = null;
                try {
                    if (this.minChildren == 0 && this.maxChildren == 0 && this.scoreType != ScoreType.NONE) {
                        switch (1.$SwitchMap$org$elasticsearch$index$search$child$ScoreType[this.scoreType.ordinal()]) {
                            case 1: {
                                collector = new MinCollector(globalIfd, sc, this.parentType);
                                break;
                            }
                            case 2: {
                                collector = new MaxCollector(globalIfd, sc, this.parentType);
                                break;
                            }
                            case 3: {
                                collector = new SumCollector(globalIfd, sc, this.parentType);
                            }
                        }
                    }
                    if (collector == null) {
                        switch (1.$SwitchMap$org$elasticsearch$index$search$child$ScoreType[this.scoreType.ordinal()]) {
                            case 1: {
                                collector = new MinCountCollector(globalIfd, sc, this.parentType);
                                break;
                            }
                            case 2: {
                                collector = new MaxCountCollector(globalIfd, sc, this.parentType);
                                break;
                            }
                            case 3: 
                            case 4: {
                                collector = new SumCountAndAvgCollector(globalIfd, sc, this.parentType);
                                break;
                            }
                            case 5: {
                                collector = new CountCollector(globalIfd, sc, this.parentType);
                                break;
                            }
                            default: {
                                throw new RuntimeException("Are we missing a score type here? -- " + (Object)this.scoreType);
                            }
                        }
                    }
                    indexSearcher.search(childQuery, collector);
                    numFoundParents = collector.foundParents();
                    if (numFoundParents != 0L) break block21;
                    var10_9 = Queries.newMatchNoDocsQuery().createWeight(searcher);
                    if (!abort) break block22;
                }
                catch (Throwable var11_11) {
                    if (abort) {
                        Releasables.close(new Releasable[]{collector});
                    }
                    throw var11_11;
                }
                Releasables.close(new Releasable[]{collector});
            }
            return var10_9;
        }
        abort = false;
        ** if (!abort) goto lbl59
lbl-1000:
        // 1 sources

        {
            Releasables.close(new Releasable[]{collector});
        }
        {
        }
lbl59:
        // 2 sources

        sc.addReleasable(collector, SearchContext.Lifetime.COLLECTION);
        parentFilter /* !! */  = numFoundParents <= (long)this.shortCircuitParentDocSet ? ParentIdsFilter.createShortCircuitFilter((Filter)this.nonNestedDocsFilter, sc, this.parentType, collector.values, collector.parentIdxs, numFoundParents) : new ApplyAcceptedDocsFilter(this.parentFilter);
        return new ParentWeight(this.rewrittenChildQuery.createWeight(searcher), parentFilter /* !! */ , numFoundParents, collector, this.minChildren, this.maxChildren);
    }

    private static final class CountParentOrdIterator
    extends FilteredDocIdSetIterator {
        private final LongHash parentIds;
        protected final IntArray occurrences;
        private final int minChildren;
        private final int maxChildren;
        private final SortedDocValues ordinals;
        private final ParentWeight parentWeight;

        private CountParentOrdIterator(ParentWeight parentWeight, DocIdSetIterator innerIterator, ParentCollector collector, SortedDocValues ordinals, int minChildren, int maxChildren) {
            super(innerIterator);
            this.parentIds = ((CountCollector)collector).parentIdxs;
            this.occurrences = ((CountCollector)collector).occurrences;
            this.ordinals = ordinals;
            this.parentWeight = parentWeight;
            this.minChildren = minChildren;
            this.maxChildren = maxChildren == 0 ? Integer.MAX_VALUE : maxChildren;
        }

        protected boolean match(int doc) {
            long parentIdx;
            if (this.parentWeight.remaining == 0L) {
                try {
                    this.advance(Integer.MAX_VALUE);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return false;
            }
            long parentOrd = this.ordinals.getOrd(doc);
            if (parentOrd >= 0L && (parentIdx = this.parentIds.find(parentOrd)) != -1L) {
                --this.parentWeight.remaining;
                int count = this.occurrences.get(parentIdx);
                if (count >= this.minChildren && count <= this.maxChildren) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class AvgParentCountScorer
    extends ParentCountScorer {
        AvgParentCountScorer(ParentWeight weight, DocIdSetIterator parentsIterator, ParentCollector collector, SortedDocValues globalOrdinals, int minChildren, int maxChildren) {
            super(weight, parentsIterator, collector, globalOrdinals, minChildren, maxChildren);
        }

        @Override
        protected boolean acceptAndScore(long parentIdx) {
            int count = this.occurrences.get(parentIdx);
            if (count < this.minChildren || count > this.maxChildren) {
                return false;
            }
            this.currentScore = this.scores.get(parentIdx);
            this.currentScore /= (float)this.occurrences.get(parentIdx);
            return true;
        }
    }

    private static final class AvgParentScorer
    extends ParentCountScorer {
        AvgParentScorer(ParentWeight weight, DocIdSetIterator parentsIterator, ParentCollector collector, SortedDocValues globalOrdinals) {
            super(weight, parentsIterator, collector, globalOrdinals, 0, 0);
        }

        @Override
        protected boolean acceptAndScore(long parentIdx) {
            this.currentScore = this.scores.get(parentIdx);
            this.currentScore /= (float)this.occurrences.get(parentIdx);
            return true;
        }
    }

    private static class ParentCountScorer
    extends ParentScorer {
        protected final IntArray occurrences;
        protected final int minChildren;
        protected final int maxChildren;

        ParentCountScorer(ParentWeight parentWeight, DocIdSetIterator parentsIterator, ParentCollector collector, SortedDocValues globalOrdinals, int minChildren, int maxChildren) {
            super(parentWeight, parentsIterator, (ParentScoreCollector)collector, globalOrdinals);
            this.minChildren = minChildren;
            this.maxChildren = maxChildren == 0 ? Integer.MAX_VALUE : maxChildren;
            this.occurrences = ((ParentScoreCountCollector)collector).occurrences;
        }

        @Override
        protected boolean acceptAndScore(long parentIdx) {
            int count = this.occurrences.get(parentIdx);
            if (count < this.minChildren || count > this.maxChildren) {
                return false;
            }
            return super.acceptAndScore(parentIdx);
        }
    }

    private static class ParentScorer
    extends Scorer {
        final ParentWeight parentWeight;
        final LongHash parentIds;
        final FloatArray scores;
        final SortedDocValues globalOrdinals;
        final DocIdSetIterator parentsIterator;
        int currentDocId = -1;
        float currentScore;

        ParentScorer(ParentWeight parentWeight, DocIdSetIterator parentsIterator, ParentCollector collector, SortedDocValues globalOrdinals) {
            super((Weight)parentWeight);
            this.parentWeight = parentWeight;
            this.globalOrdinals = globalOrdinals;
            this.parentsIterator = parentsIterator;
            this.parentIds = collector.parentIdxs;
            this.scores = ((ParentScoreCollector)collector).scores;
        }

        public float score() throws IOException {
            return this.currentScore;
        }

        protected boolean acceptAndScore(long parentIdx) {
            this.currentScore = this.scores.get(parentIdx);
            return true;
        }

        public int freq() throws IOException {
            return 1;
        }

        public int docID() {
            return this.currentDocId;
        }

        public int nextDoc() throws IOException {
            if (this.parentWeight.remaining == 0L) {
                this.currentDocId = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            while (true) {
                long parentIdx;
                this.currentDocId = this.parentsIterator.nextDoc();
                if (this.currentDocId == Integer.MAX_VALUE) {
                    return this.currentDocId;
                }
                int globalOrdinal = this.globalOrdinals.getOrd(this.currentDocId);
                if (globalOrdinal < 0 || (parentIdx = this.parentIds.find(globalOrdinal)) == -1L) continue;
                --this.parentWeight.remaining;
                if (this.acceptAndScore(parentIdx)) break;
            }
            return this.currentDocId;
        }

        public int advance(int target) throws IOException {
            if (this.parentWeight.remaining == 0L) {
                this.currentDocId = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.currentDocId = this.parentsIterator.advance(target);
            if (this.currentDocId == Integer.MAX_VALUE) {
                return this.currentDocId;
            }
            long globalOrdinal = this.globalOrdinals.getOrd(this.currentDocId);
            if (globalOrdinal < 0L) {
                return this.nextDoc();
            }
            long parentIdx = this.parentIds.find(globalOrdinal);
            if (parentIdx != -1L) {
                --this.parentWeight.remaining;
                if (this.acceptAndScore(parentIdx)) {
                    return this.currentDocId;
                }
            }
            return this.nextDoc();
        }

        public long cost() {
            return this.parentsIterator.cost();
        }
    }

    private static final class SumCountAndAvgCollector
    extends ParentScoreCountCollector {
        SumCountAndAvgCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            this.scores.increment(parentIdx, this.scorer.score());
            this.occurrences.increment(parentIdx, 1);
        }
    }

    private static final class MinCountCollector
    extends ParentScoreCountCollector {
        private MinCountCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            float currentScore = this.scorer.score();
            if (currentScore < this.scores.get(parentIdx)) {
                this.scores.set(parentIdx, currentScore);
            }
            this.occurrences.increment(parentIdx, 1);
        }
    }

    private static final class MaxCountCollector
    extends ParentScoreCountCollector {
        private MaxCountCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            float currentScore = this.scorer.score();
            if (currentScore > this.scores.get(parentIdx)) {
                this.scores.set(parentIdx, currentScore);
            }
            this.occurrences.increment(parentIdx, 1);
        }
    }

    private static final class MinCollector
    extends ParentScoreCollector {
        private MinCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            float currentScore = this.scorer.score();
            if (currentScore < this.scores.get(parentIdx)) {
                this.scores.set(parentIdx, currentScore);
            }
        }
    }

    private static final class MaxCollector
    extends ParentScoreCollector {
        private MaxCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            float currentScore = this.scorer.score();
            if (currentScore > this.scores.get(parentIdx)) {
                this.scores.set(parentIdx, currentScore);
            }
        }
    }

    private static final class SumCollector
    extends ParentScoreCollector {
        private SumCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            this.scores.increment(parentIdx, this.scorer.score());
        }
    }

    private static final class CountCollector
    extends ParentCollector
    implements Releasable {
        protected IntArray occurrences;

        protected CountCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
            this.occurrences = this.bigArrays.newIntArray(512L, false);
        }

        @Override
        protected void newParent(long parentIdx) throws IOException {
            this.occurrences = this.bigArrays.grow(this.occurrences, parentIdx + 1L);
            this.occurrences.set(parentIdx, 1);
        }

        @Override
        protected void existingParent(long parentIdx) throws IOException {
            this.occurrences.increment(parentIdx, 1);
        }

        @Override
        public void close() throws ElasticsearchException {
            Releasables.close(this.parentIdxs, this.occurrences);
        }
    }

    protected static abstract class ParentScoreCountCollector
    extends ParentScoreCollector
    implements Releasable {
        protected IntArray occurrences;

        protected ParentScoreCountCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
            this.occurrences = this.bigArrays.newIntArray(512L, false);
        }

        @Override
        protected void newParent(long parentIdx) throws IOException {
            this.scores = this.bigArrays.grow(this.scores, parentIdx + 1L);
            this.scores.set(parentIdx, this.scorer.score());
            this.occurrences = this.bigArrays.grow(this.occurrences, parentIdx + 1L);
            this.occurrences.set(parentIdx, 1);
        }

        @Override
        public void close() throws ElasticsearchException {
            Releasables.close(this.parentIdxs, this.scores, this.occurrences);
        }
    }

    protected static abstract class ParentScoreCollector
    extends ParentCollector
    implements Releasable {
        protected FloatArray scores;

        protected ParentScoreCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            super(globalIfd, searchContext, parentType);
            this.scores = this.bigArrays.newFloatArray(512L, false);
        }

        @Override
        protected void newParent(long parentIdx) throws IOException {
            this.scores = this.bigArrays.grow(this.scores, parentIdx + 1L);
            this.scores.set(parentIdx, this.scorer.score());
        }

        @Override
        public void close() throws ElasticsearchException {
            Releasables.close(this.parentIdxs, this.scores);
        }
    }

    protected static abstract class ParentCollector
    extends NoopCollector
    implements Releasable {
        protected final IndexParentChildFieldData globalIfd;
        protected final LongHash parentIdxs;
        protected final BigArrays bigArrays;
        protected final SearchContext searchContext;
        protected final String parentType;
        protected SortedDocValues values;
        protected Scorer scorer;

        protected ParentCollector(IndexParentChildFieldData globalIfd, SearchContext searchContext, String parentType) {
            this.globalIfd = globalIfd;
            this.searchContext = searchContext;
            this.bigArrays = searchContext.bigArrays();
            this.parentIdxs = new LongHash(512L, this.bigArrays);
            this.parentType = parentType;
        }

        @Override
        public final void collect(int doc) throws IOException {
            long globalOrdinal;
            if (this.values != null && (globalOrdinal = (long)this.values.getOrd(doc)) >= 0L) {
                long parentIdx = this.parentIdxs.add(globalOrdinal);
                if (parentIdx >= 0L) {
                    this.newParent(parentIdx);
                } else {
                    parentIdx = -1L - parentIdx;
                    this.existingParent(parentIdx);
                }
            }
        }

        protected void newParent(long parentIdx) throws IOException {
        }

        protected void existingParent(long parentIdx) throws IOException {
        }

        public long foundParents() {
            return this.parentIdxs.size();
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = ((AtomicParentChildFieldData)this.globalIfd.load(context)).getOrdinalsValues(this.parentType);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        public void close() throws ElasticsearchException {
            Releasables.close(this.parentIdxs);
        }
    }

    protected class ParentWeight
    extends Weight {
        protected final Weight childWeight;
        protected final Filter parentFilter;
        protected final ParentCollector collector;
        protected final int minChildren;
        protected final int maxChildren;
        protected long remaining;
        protected float queryNorm;
        protected float queryWeight;

        protected ParentWeight(Weight childWeight, Filter parentFilter, long remaining, ParentCollector collector, int minChildren, int maxChildren) {
            this.childWeight = childWeight;
            this.parentFilter = parentFilter;
            this.remaining = remaining;
            this.collector = collector;
            this.minChildren = minChildren;
            this.maxChildren = maxChildren;
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ChildrenQuery.this.getBoost(), "not implemented yet...");
        }

        public Query getQuery() {
            return ChildrenQuery.this;
        }

        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        public float getValueForNormalization() throws IOException {
            this.queryWeight = ChildrenQuery.this.getBoost();
            if (ChildrenQuery.this.scoreType == ScoreType.NONE) {
                return this.queryWeight * this.queryWeight;
            }
            float sum = this.childWeight.getValueForNormalization();
            return sum *= this.queryWeight * this.queryWeight;
        }

        public Scorer scorer(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            DocIdSet parentsSet = this.parentFilter.getDocIdSet(context, acceptDocs);
            if (DocIdSets.isEmpty(parentsSet) || this.remaining == 0L) {
                return null;
            }
            DocIdSetIterator parents = BitsFilteredDocIdSet.wrap((DocIdSet)parentsSet, (Bits)context.reader().getLiveDocs()).iterator();
            if (parents != null) {
                SortedDocValues bytesValues = ((AtomicParentChildFieldData)this.collector.globalIfd.load(context)).getOrdinalsValues(ChildrenQuery.this.parentType);
                if (bytesValues == null) {
                    return null;
                }
                if (this.minChildren > 0 || this.maxChildren != 0 || ChildrenQuery.this.scoreType == ScoreType.NONE) {
                    switch (ChildrenQuery.this.scoreType) {
                        case NONE: {
                            CountParentOrdIterator parentIdIterator = new CountParentOrdIterator(this, parents, this.collector, bytesValues, this.minChildren, this.maxChildren);
                            return ConstantScorer.create((DocIdSetIterator)parentIdIterator, this, this.queryWeight);
                        }
                        case AVG: {
                            return new AvgParentCountScorer(this, parents, this.collector, bytesValues, this.minChildren, this.maxChildren);
                        }
                    }
                    return new ParentCountScorer(this, parents, this.collector, bytesValues, this.minChildren, this.maxChildren);
                }
                switch (ChildrenQuery.this.scoreType) {
                    case AVG: {
                        return new AvgParentScorer(this, parents, this.collector, bytesValues);
                    }
                }
                return new ParentScorer(this, parents, this.collector, bytesValues);
            }
            return null;
        }
    }
}

