/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.fs;

import java.io.File;
import java.io.IOException;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.fs.FsBlobStore;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryName;
import org.elasticsearch.repositories.RepositorySettings;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;

public class FsRepository
extends BlobStoreRepository {
    public static final String TYPE = "fs";
    private final FsBlobStore blobStore;
    private ByteSizeValue chunkSize;
    private final BlobPath basePath;
    private boolean compress;

    @Inject
    public FsRepository(RepositoryName name, RepositorySettings repositorySettings, IndexShardRepository indexShardRepository, Environment environment) throws IOException {
        super(name.getName(), repositorySettings, indexShardRepository);
        String location = repositorySettings.settings().get("location", this.componentSettings.get("location"));
        if (location == null) {
            this.logger.warn("the repository location is missing, it should point to a shared file system location that is available on all master and data nodes", new Object[0]);
            throw new RepositoryException(name.name(), "missing location");
        }
        File locationFile = environment.resolveRepoFile(location);
        if (locationFile == null) {
            if (environment.repoFiles().length > 0) {
                this.logger.warn("The specified location [{}] doesn't start with any repository paths specified by the path.repo setting: [{}] ", location, environment.repoFiles());
                throw new RepositoryException(name.name(), "location [" + location + "] doesn't match any of the locations specified by path.repo");
            }
            this.logger.warn("The specified location [{}] should start with a repository path specified by the path.repo setting, but the path.repo setting was not set on this node", location);
            throw new RepositoryException(name.name(), "location [" + location + "] doesn't match any of the locations specified by path.repo because this setting is empty");
        }
        this.blobStore = new FsBlobStore(this.componentSettings, locationFile);
        this.chunkSize = repositorySettings.settings().getAsBytesSize("chunk_size", this.componentSettings.getAsBytesSize("chunk_size", null));
        this.compress = repositorySettings.settings().getAsBoolean("compress", this.componentSettings.getAsBoolean("compress", (Boolean)false));
        this.basePath = BlobPath.cleanPath();
    }

    @Override
    protected BlobStore blobStore() {
        return this.blobStore;
    }

    @Override
    protected boolean isCompress() {
        return this.compress;
    }

    @Override
    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    @Override
    protected BlobPath basePath() {
        return this.basePath;
    }
}

