/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filters;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.lucene.search.MatchAllDocsFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.ParsedFilter;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.filters.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.filters.InternalFilters;
import org.elasticsearch.search.internal.SearchContext;

public class FiltersParser
implements Aggregator.Parser {
    @Override
    public String type() {
        return InternalFilters.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        ArrayList<FiltersAggregator.KeyedFilter> filters = new ArrayList<FiltersAggregator.KeyedFilter>();
        XContentParser.Token token = null;
        String currentFieldName = null;
        Boolean keyed = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            ParsedFilter filter;
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("filters".equals(currentFieldName)) {
                    keyed = true;
                    String key = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            key = parser.currentName();
                            continue;
                        }
                        filter = context.queryParserService().parseInnerFilter(parser);
                        filters.add(new FiltersAggregator.KeyedFilter(key, filter == null ? new MatchAllDocsFilter() : filter.filter()));
                    }
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("filters".equals(currentFieldName)) {
                    keyed = false;
                    int idx = 0;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        filter = context.queryParserService().parseInnerFilter(parser);
                        filters.add(new FiltersAggregator.KeyedFilter(String.valueOf(idx), filter == null ? new MatchAllDocsFilter() : filter.filter()));
                        ++idx;
                    }
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
        }
        return new FiltersAggregator.Factory(aggregationName, filters, keyed);
    }
}

