/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.tophits;

import java.io.IOException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.tophits.InternalTopHits;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHitsAggregator;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.fielddata.FieldDataFieldsParseElement;
import org.elasticsearch.search.fetch.script.ScriptFieldsParseElement;
import org.elasticsearch.search.fetch.source.FetchSourceParseElement;
import org.elasticsearch.search.highlight.HighlighterParseElement;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.SubSearchContext;
import org.elasticsearch.search.sort.SortParseElement;

public class TopHitsParser
implements Aggregator.Parser {
    private final FetchPhase fetchPhase;
    private final SortParseElement sortParseElement;
    private final FetchSourceParseElement sourceParseElement;
    private final HighlighterParseElement highlighterParseElement;
    private final FieldDataFieldsParseElement fieldDataFieldsParseElement;
    private final ScriptFieldsParseElement scriptFieldsParseElement;

    @Inject
    public TopHitsParser(FetchPhase fetchPhase, SortParseElement sortParseElement, FetchSourceParseElement sourceParseElement, HighlighterParseElement highlighterParseElement, FieldDataFieldsParseElement fieldDataFieldsParseElement, ScriptFieldsParseElement scriptFieldsParseElement) {
        this.fetchPhase = fetchPhase;
        this.sortParseElement = sortParseElement;
        this.sourceParseElement = sourceParseElement;
        this.highlighterParseElement = highlighterParseElement;
        this.fieldDataFieldsParseElement = fieldDataFieldsParseElement;
        this.scriptFieldsParseElement = scriptFieldsParseElement;
    }

    @Override
    public String type() {
        return InternalTopHits.TYPE.name();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        SubSearchContext subSearchContext = new SubSearchContext(context);
        String currentFieldName = null;
        try {
            XContentParser.Token token;
            block33: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if ("sort".equals(currentFieldName)) {
                    this.sortParseElement.parse(parser, subSearchContext);
                    continue;
                }
                if ("_source".equals(currentFieldName)) {
                    this.sourceParseElement.parse(parser, subSearchContext);
                    continue;
                }
                if (token.isValue()) {
                    switch (currentFieldName) {
                        case "from": {
                            subSearchContext.from(parser.intValue());
                            continue block33;
                        }
                        case "size": {
                            subSearchContext.size(parser.intValue());
                            continue block33;
                        }
                        case "track_scores": 
                        case "trackScores": {
                            subSearchContext.trackScores(parser.booleanValue());
                            continue block33;
                        }
                        case "version": {
                            subSearchContext.version(parser.booleanValue());
                            continue block33;
                        }
                        case "explain": {
                            subSearchContext.explain(parser.booleanValue());
                            continue block33;
                        }
                    }
                    throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    switch (currentFieldName) {
                        case "highlight": {
                            this.highlighterParseElement.parse(parser, subSearchContext);
                            continue block33;
                        }
                        case "scriptFields": 
                        case "script_fields": {
                            this.scriptFieldsParseElement.parse(parser, subSearchContext);
                            continue block33;
                        }
                    }
                    throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
                }
                if (token != XContentParser.Token.START_ARRAY) throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].");
                switch (currentFieldName) {
                    case "fielddataFields": 
                    case "fielddata_fields": {
                        this.fieldDataFieldsParseElement.parse(parser, subSearchContext);
                        continue block33;
                    }
                }
            }
            return new TopHitsAggregator.Factory(aggregationName, this.fetchPhase, subSearchContext);
            throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }
}

