/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class TransportInfo
implements Streamable,
Serializable,
ToXContent {
    private BoundTransportAddress address;
    private Map<String, BoundTransportAddress> profileAddresses;

    TransportInfo() {
    }

    public TransportInfo(BoundTransportAddress address, @Nullable Map<String, BoundTransportAddress> profileAddresses) {
        this.address = address;
        this.profileAddresses = profileAddresses;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.TRANSPORT);
        builder.field(Fields.BOUND_ADDRESS, this.address.boundAddress().toString());
        builder.field(Fields.PUBLISH_ADDRESS, this.address.publishAddress().toString());
        builder.startObject(Fields.PROFILES);
        if (this.profileAddresses != null && this.profileAddresses.size() > 0) {
            for (Map.Entry<String, BoundTransportAddress> entry : this.profileAddresses.entrySet()) {
                builder.startObject(entry.getKey());
                builder.field(Fields.BOUND_ADDRESS, entry.getValue().boundAddress().toString());
                builder.field(Fields.PUBLISH_ADDRESS, entry.getValue().publishAddress().toString());
                builder.endObject();
            }
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static TransportInfo readTransportInfo(StreamInput in) throws IOException {
        TransportInfo info = new TransportInfo();
        info.readFrom(in);
        return info;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.address = BoundTransportAddress.readBoundTransportAddress(in);
        if (in.getVersion().onOrAfter(Version.V_1_5_0)) {
            int size = in.readVInt();
            if (size > 0) {
                this.profileAddresses = Maps.newHashMapWithExpectedSize(size);
                for (int i = 0; i < size; ++i) {
                    String key = in.readString();
                    BoundTransportAddress value = BoundTransportAddress.readBoundTransportAddress(in);
                    this.profileAddresses.put(key, value);
                }
            }
        } else {
            this.profileAddresses = Collections.EMPTY_MAP;
            return;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.address.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_1_5_0)) {
            if (this.profileAddresses != null) {
                out.writeVInt(this.profileAddresses.size());
            } else {
                out.writeVInt(0);
            }
            if (this.profileAddresses != null && this.profileAddresses.size() > 0) {
                for (Map.Entry<String, BoundTransportAddress> entry : this.profileAddresses.entrySet()) {
                    out.writeString(entry.getKey());
                    entry.getValue().writeTo(out);
                }
            }
        }
    }

    public BoundTransportAddress address() {
        return this.address;
    }

    public BoundTransportAddress getAddress() {
        return this.address();
    }

    public Map<String, BoundTransportAddress> getProfileAddresses() {
        return this.profileAddresses();
    }

    public Map<String, BoundTransportAddress> profileAddresses() {
        return this.profileAddresses;
    }

    static final class Fields {
        static final XContentBuilderString TRANSPORT = new XContentBuilderString("transport");
        static final XContentBuilderString BOUND_ADDRESS = new XContentBuilderString("bound_address");
        static final XContentBuilderString PUBLISH_ADDRESS = new XContentBuilderString("publish_address");
        static final XContentBuilderString PROFILES = new XContentBuilderString("profiles");

        Fields() {
        }
    }
}

