/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata;

import java.io.OutputStream;
import java.util.UUID;
import net.fortytwo.flow.rdf.SesameOutputAdapter;
import net.fortytwo.ripple.RippleException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;

public final class RDFUtils {
    private RDFUtils() {
    }

    public static SesameOutputAdapter createOutputAdapter(OutputStream out, RDFFormat format) throws RippleException {
        RDFWriter writer;
        try {
            writer = Rio.createWriter((RDFFormat)format, (OutputStream)out);
        }
        catch (Throwable t) {
            throw new RippleException(t);
        }
        return new SesameOutputAdapter((RDFHandler)writer);
    }

    public static boolean isHttpUri(URI uri) {
        return uri.toString().startsWith("http://");
    }

    public static URI inferContextURI(Resource subject, ValueFactory valueFactory) throws RippleException {
        if (!(subject instanceof URI)) {
            return null;
        }
        String s = RDFUtils.removeFragmentIdentifier(subject.toString());
        try {
            return valueFactory.createURI(s);
        }
        catch (Throwable t) {
            throw new RippleException(t);
        }
    }

    public static String removeFragmentIdentifier(String uri) {
        int i = uri.lastIndexOf(35);
        return 0 <= i ? uri.substring(0, i) : uri;
    }

    public static String findGraphUri(String uri) {
        String docUri = RDFUtils.removeFragmentIdentifier(uri);
        return "urn:uuid:" + UUID.nameUUIDFromBytes(docUri.getBytes());
    }
}

