/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;

public class ScannerCallable
extends ServerCallable<Result[]> {
    public static final String LOG_SCANNER_LATENCY_CUTOFF = "hbase.client.log.scanner.latency.cutoff";
    public static final String LOG_SCANNER_ACTIVITY = "hbase.client.log.scanner.activity";
    private static final Log LOG = LogFactory.getLog(ScannerCallable.class);
    private long scannerId = -1L;
    private boolean instantiated = false;
    private boolean closed = false;
    private Scan scan;
    private int caching = 1;
    private ScanMetrics scanMetrics;
    private boolean logScannerActivity = false;
    private int logCutOffLatency = 1000;
    private static String myAddress;
    private boolean isRegionServerRemote = true;

    public ScannerCallable(HConnection connection, byte[] tableName, Scan scan, ScanMetrics scanMetrics) {
        super(connection, tableName, scan.getStartRow());
        this.scan = scan;
        this.scanMetrics = scanMetrics;
        Configuration conf = connection.getConfiguration();
        this.logScannerActivity = conf.getBoolean(LOG_SCANNER_ACTIVITY, false);
        this.logCutOffLatency = conf.getInt(LOG_SCANNER_LATENCY_CUTOFF, 1000);
    }

    @Override
    public void connect(boolean reload) throws IOException {
        if (!this.instantiated || reload) {
            super.connect(reload);
            this.checkIfRegionServerIsRemote();
            this.instantiated = true;
        }
        if (reload && this.scanMetrics != null) {
            this.scanMetrics.countOfRPCRetries.inc();
            if (this.isRegionServerRemote) {
                this.scanMetrics.countOfRemoteRPCRetries.inc();
            }
        }
    }

    private void checkIfRegionServerIsRemote() {
        this.isRegionServerRemote = !this.location.getHostname().equalsIgnoreCase(myAddress);
    }

    @Override
    public Result[] call() throws IOException {
        if (this.scannerId != -1L && this.closed) {
            this.close();
        } else if (this.scannerId == -1L && !this.closed) {
            this.scannerId = this.openScanner();
        } else {
            Result[] rrs = null;
            try {
                long now;
                this.incRPCcallsMetrics();
                long timestamp = System.currentTimeMillis();
                rrs = this.server.next(this.scannerId, this.caching);
                if (this.logScannerActivity && (now = System.currentTimeMillis()) - timestamp > (long)this.logCutOffLatency) {
                    int rows = rrs == null ? 0 : rrs.length;
                    LOG.info((Object)("Took " + (now - timestamp) + "ms to fetch " + rows + " rows from scanner=" + this.scannerId));
                }
                this.updateResultsMetrics(rrs);
            }
            catch (IOException e) {
                if (this.logScannerActivity) {
                    LOG.info((Object)("Got exception in fetching from scanner=" + this.scannerId), (Throwable)e);
                }
                IOException ioe = null;
                if (e instanceof RemoteException) {
                    ioe = RemoteExceptionHandler.decodeRemoteException((RemoteException)e);
                }
                if (ioe == null) {
                    throw new IOException(e);
                }
                if (this.logScannerActivity && ioe instanceof UnknownScannerException) {
                    try {
                        HRegionLocation location = this.connection.relocateRegion(this.tableName, this.scan.getStartRow());
                        LOG.info((Object)("Scanner=" + this.scannerId + " expired, current region location is " + location.toString() + " ip:" + location.getServerAddress().getBindAddress()));
                    }
                    catch (Throwable t) {
                        LOG.info((Object)"Failed to relocate region", t);
                    }
                }
                if (ioe instanceof NotServingRegionException) {
                    if (this.scanMetrics != null) {
                        this.scanMetrics.countOfNSRE.inc();
                    }
                    throw new DoNotRetryIOException("Reset scanner", ioe);
                }
                if (ioe instanceof RegionServerStoppedException) {
                    throw new DoNotRetryIOException("Reset scanner", ioe);
                }
                throw ioe;
            }
            return rrs;
        }
        return null;
    }

    private void incRPCcallsMetrics() {
        if (this.scanMetrics == null) {
            return;
        }
        this.scanMetrics.countOfRPCcalls.inc();
        if (this.isRegionServerRemote) {
            this.scanMetrics.countOfRemoteRPCcalls.inc();
        }
    }

    private void updateResultsMetrics(Result[] rrs) {
        if (this.scanMetrics == null || rrs == null) {
            return;
        }
        for (Result rr : rrs) {
            this.scanMetrics.countOfBytesInResults.inc((long)rr.getBytes().getLength());
            if (!this.isRegionServerRemote) continue;
            this.scanMetrics.countOfBytesInRemoteResults.inc((long)rr.getBytes().getLength());
        }
    }

    private void close() {
        if (this.scannerId == -1L) {
            return;
        }
        try {
            this.incRPCcallsMetrics();
            this.server.close(this.scannerId);
        }
        catch (IOException e) {
            LOG.warn((Object)"Ignore, probably already closed", (Throwable)e);
        }
        this.scannerId = -1L;
    }

    protected long openScanner() throws IOException {
        this.incRPCcallsMetrics();
        long id = this.server.openScanner(this.location.getRegionInfo().getRegionName(), this.scan);
        if (this.logScannerActivity) {
            LOG.info((Object)("Open scanner=" + id + " for scan=" + this.scan.toString() + " on region " + this.location.toString() + " ip:" + this.location.getServerAddress().getBindAddress()));
        }
        return id;
    }

    protected Scan getScan() {
        return this.scan;
    }

    public void setClose() {
        this.closed = true;
    }

    public HRegionInfo getHRegionInfo() {
        if (!this.instantiated) {
            return null;
        }
        return this.location.getRegionInfo();
    }

    public int getCaching() {
        return this.caching;
    }

    public void setCaching(int caching) {
        this.caching = caching;
    }

    static {
        try {
            myAddress = DNS.getDefaultHost((String)"default", (String)"default");
        }
        catch (UnknownHostException uhe) {
            LOG.error((Object)"cannot determine my address", (Throwable)uhe);
        }
    }
}

