/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseEndpointCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.example.BulkDeleteProtocol;
import org.apache.hadoop.hbase.coprocessor.example.BulkDeleteResponse;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class BulkDeleteEndpoint
extends BaseEndpointCoprocessor
implements BulkDeleteProtocol {
    private static final String NO_OF_VERSIONS_TO_DELETE = "noOfVersionsToDelete";
    private static final Log LOG = LogFactory.getLog(BulkDeleteEndpoint.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkDeleteResponse delete(Scan scan, byte deleteType, Long timestamp, int rowBatchSize) {
        long totalRowsDeleted = 0L;
        long totalVersionsDeleted = 0L;
        BulkDeleteResponse response = new BulkDeleteResponse();
        HRegion region = ((RegionCoprocessorEnvironment)this.getEnvironment()).getRegion();
        boolean hasMore = true;
        RegionScanner scanner = null;
        if (scan.getFilter() == null && deleteType == 0) {
            scan.setFilter(new FirstKeyOnlyFilter());
        }
        try {
            scanner = region.getScanner(scan);
            while (hasMore) {
                ArrayList<ArrayList<KeyValue>> deleteRows = new ArrayList<ArrayList<KeyValue>>(rowBatchSize);
                for (int i = 0; i < rowBatchSize; ++i) {
                    ArrayList<KeyValue> results = new ArrayList<KeyValue>();
                    hasMore = scanner.next(results);
                    if (results.size() > 0) {
                        deleteRows.add(results);
                    }
                    if (!hasMore) break;
                }
                if (deleteRows.size() <= 0) continue;
                Pair[] deleteWithLockArr = new Pair[deleteRows.size()];
                int i = 0;
                for (List list : deleteRows) {
                    Delete delete = this.createDeleteMutation(list, deleteType, timestamp);
                    deleteWithLockArr[i++] = new Pair<Delete, Object>(delete, null);
                }
                OperationStatus[] opStatus = region.batchMutate(deleteWithLockArr);
                for (i = 0; i < opStatus.length && opStatus[i].getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS; ++i) {
                    byte[] byArray;
                    ++totalRowsDeleted;
                    if (deleteType != 3 || (byArray = ((Mutation)deleteWithLockArr[i].getFirst()).getAttribute(NO_OF_VERSIONS_TO_DELETE)) == null) continue;
                    totalVersionsDeleted += (long)Bytes.toInt(byArray);
                }
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
            response.setIoException(ioe);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (IOException ioe) {
                    LOG.error((Object)ioe);
                }
            }
        }
        response.setRowsDeleted(totalRowsDeleted);
        response.setVersionsDeleted(totalVersionsDeleted);
        return response;
    }

    private Delete createDeleteMutation(List<KeyValue> deleteRow, byte deleteType, Long timestamp) {
        long ts = timestamp == null ? Long.MAX_VALUE : timestamp;
        byte[] row = deleteRow.get(0).getRow();
        Delete delete = new Delete(row, ts, null);
        if (deleteType != 0) {
            switch (deleteType) {
                case 1: {
                    TreeSet<byte[]> families = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
                    for (KeyValue kv : deleteRow) {
                        if (!families.add(kv.getFamily())) continue;
                        delete.deleteFamily(kv.getFamily(), ts);
                    }
                    break;
                }
                case 2: {
                    HashSet<Column> columns = new HashSet<Column>();
                    for (KeyValue kv : deleteRow) {
                        Column column = new Column(kv.getFamily(), kv.getQualifier());
                        if (!columns.add(column)) continue;
                        delete.deleteColumns(column.family, column.qualifier, ts);
                    }
                    break;
                }
                case 3: {
                    int noOfVersionsToDelete = 0;
                    if (timestamp == null) {
                        for (KeyValue kv : deleteRow) {
                            delete.deleteColumn(kv.getFamily(), kv.getQualifier(), kv.getTimestamp());
                            ++noOfVersionsToDelete;
                        }
                    } else {
                        HashSet<Column> columns = new HashSet<Column>();
                        for (KeyValue kv : deleteRow) {
                            Column column = new Column(kv.getFamily(), kv.getQualifier());
                            if (!columns.add(column)) continue;
                            delete.deleteColumn(column.family, column.qualifier, ts);
                            ++noOfVersionsToDelete;
                        }
                    }
                    delete.setAttribute(NO_OF_VERSIONS_TO_DELETE, Bytes.toBytes(noOfVersionsToDelete));
                }
            }
        }
        return delete;
    }

    private static class Column {
        private byte[] family;
        private byte[] qualifier;

        public Column(byte[] family, byte[] qualifier) {
            this.family = family;
            this.qualifier = qualifier;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Column)) {
                return false;
            }
            Column column = (Column)other;
            return Bytes.equals(this.family, column.family) && Bytes.equals(this.qualifier, column.qualifier);
        }

        public int hashCode() {
            int h = 31;
            h += 13 * Bytes.hashCode(this.family);
            return h += 13 * Bytes.hashCode(this.qualifier);
        }
    }
}

